/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.browser.p2p;

import android.content.Context;
import android.net.wifi.p2p.WifiP2pDevice;
import android.os.Handler;
import android.os.Looper;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.wifidirect.IWDirectController;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.permission.ContextCompat;

public class P2PBrowserBridge {
    private static final String TAG = "P2PBrowserBridge";
    private Context mContext;
    private IWDirectController mWDIRECTController;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public P2PBrowserBridge(Context context) {
        this.mContext = context;
        try {
            this.mWDIRECTController = (IWDirectController)ModuleLinker.getInstance().loadModule("BCA7021EAABA524C12943A60454342A8");
            if (this.mWDIRECTController.isSupportWifiP2p()) {
                this.mWDIRECTController.setWDirectStateListener(new ProtocolListener(){

                    @Override
                    public void onResult(final int n2, final String ... stringArray) {
                        P2PBrowserBridge.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                P2PBrowserBridge.this.WDIRECTCmdParse(n2, stringArray);
                            }
                        });
                    }
                });
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void startBrowser() {
    }

    public void connect(WifiP2pDevice wifiP2pDevice) {
        this.mWDIRECTController.connect(wifiP2pDevice);
    }

    public void stopBrowser() {
        this.mWDIRECTController.disConnect();
    }

    public boolean checkP2pNeedPermission() {
        return ContextCompat.checkSelfPermission(this.mContext, "android.permission.CHANGE_NETWORK_STATE") == 0 && ContextCompat.checkSelfPermission(this.mContext, "android.permission.ACCESS_NETWORK_STATE") == 0 && ContextCompat.checkSelfPermission(this.mContext, "android.permission.ACCESS_WIFI_STATE") == 0 && ContextCompat.checkSelfPermission(this.mContext, "android.permission.CHANGE_WIFI_STATE") == 0 && ContextCompat.checkSelfPermission(this.mContext, "android.permission.ACCESS_FINE_LOCATION") == 0 && ContextCompat.checkSelfPermission(this.mContext, "android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private void WDIRECTCmdParse(int n2, String ... stringArray) {
        switch (n2) {
            case 7: {
                SourceLog.i(TAG, "\u542f\u52a8\u8fde\u63a5\u6210\u529f");
                break;
            }
            case 8: {
                SourceLog.i(TAG, "\u542f\u52a8\u8fde\u63a5\u5931\u8d25");
                break;
            }
            case 2: {
                SourceLog.i(TAG, "\u8fde\u63a5\u65ad\u5f00");
                break;
            }
            case 1: {
                String string = "unkown";
                String string2 = "unkown";
                if (stringArray.length > 0) {
                    string2 = stringArray[0];
                }
                if (stringArray.length > 1) {
                    string = stringArray[1];
                }
                SourceLog.i(TAG, " \u8fde\u63a5\u6210\u529f \u5f53\u524d\u7f51\u7edc\u9891\u7387" + string2 + "  " + string);
                break;
            }
            case 9: {
                SourceLog.i(TAG, "\u8fde\u63a5\u5931\u8d25");
                break;
            }
            case 6: {
                SourceLog.i(TAG, "\u542f\u52a8\u641c\u7d22\u5931\u8d25");
                break;
            }
            case 5: {
                SourceLog.i(TAG, "\u542f\u52a8\u641c\u7d22\u6210\u529f");
                break;
            }
            case 10: {
                SourceLog.i(TAG, "\u5f53\u524d\u8bbe\u5907\u72b6\u6001\u4e3a: " + P2PBrowserBridge.getDeviceStatus(Integer.valueOf(stringArray[0])));
                break;
            }
            case 3: {
                SourceLog.i(TAG, "\u670d\u52a1\u7aef\u542f\u52a8\u6210\u529f, \u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u63a5\u6536\u7aefSDK");
                break;
            }
            case 4: {
                SourceLog.i(TAG, "\u670d\u52a1\u7aef\u542f\u52a8\u5931\u8d25");
            }
        }
    }

    public static String getDeviceStatus(int n2) {
        switch (n2) {
            case 3: {
                return "\u53ef\u7528\u7684";
            }
            case 1: {
                return "\u9080\u8bf7\u4e2d";
            }
            case 0: {
                return "\u5df2\u8fde\u63a5";
            }
            case 2: {
                return "\u5931\u8d25\u7684";
            }
            case 4: {
                return "\u4e0d\u53ef\u7528\u7684";
            }
        }
        return "\u672a\u77e5";
    }
}

