/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.player;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.SparseArray;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.screencupture.IScreenCapture;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.cloud.SDKConfig;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.mirror.a.a;
import com.hpplay.sdk.source.player.AbsPlayer;
import com.hpplay.sdk.source.player.ICastPlayer;
import com.hpplay.sdk.source.player.LelinkPlayer;
import com.hpplay.sdk.source.player.YimPlayer;
import com.hpplay.sdk.source.player.listener.OnCompletionListener;
import com.hpplay.sdk.source.player.listener.OnErrorListener;
import com.hpplay.sdk.source.player.listener.OnInfoListener;
import com.hpplay.sdk.source.player.listener.OnLoadingListener;
import com.hpplay.sdk.source.player.listener.OnPreparedListener;
import com.hpplay.sdk.source.player.listener.OnStateChangeListener;
import com.hpplay.sdk.source.player.listener.OnStopListener;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.CaptureBridge;
import com.hpplay.sdk.source.protocol.LelinkBridge;
import com.hpplay.sdk.source.protocol.YimBridge;
import com.hpplay.sdk.source.utils.BrowserResolver;
import com.hpplay.sdk.source.utils.KeepAliveUtitls;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

public class GroupPlayer
implements ICastPlayer {
    private static final String TAG = "GroupPlayer";
    private static final int WHAT_REPORT_QUALITY = 1;
    private static final int WHAT_RECONNECT_DEVICE = 2;
    private boolean mQualityReportEnable = false;
    private int mReportInterval = 5000;
    private Context mContext;
    private OutParameter mPlayInfo;
    private LelinkPlayer mLelinkPlayer;
    private YimPlayer mYimPlayer;
    private AbsPlayer mCurrentPlayer;
    private long startChangeTime;
    private SparseArray<a> mMirrorInfos = new SparseArray();
    private SparseArray<AbsBridge> mBridges = new SparseArray();
    private boolean isCallLoading = false;
    private long mPrintFrameType;
    private long mPrintAudioFrameType;
    private boolean isStopped = false;
    private OnLoadingListener mLoadingListener;
    private OnLoadingListener onLoadingListener = new OnLoadingListener(){

        @Override
        public void onLoading(ICastPlayer iCastPlayer, String string) {
            if (!GroupPlayer.this.isCallLoading) {
                GroupPlayer.this.isCallLoading = true;
                if (GroupPlayer.this.mLoadingListener != null) {
                    GroupPlayer.this.mLoadingListener.onLoading(iCastPlayer, string);
                }
            }
        }
    };
    private boolean isCallPrepared = false;
    private OnPreparedListener mPreparedListener;
    private OnPreparedListener onPreparedListener = new OnPreparedListener(){

        @Override
        public void onPrepared(ICastPlayer iCastPlayer) {
            if (!GroupPlayer.this.isCallPrepared) {
                GroupPlayer.this.isCallPrepared = true;
                if (GroupPlayer.this.mPreparedListener != null) {
                    GroupPlayer.this.mPreparedListener.onPrepared(iCastPlayer);
                }
            }
            if (!GroupPlayer.this.mQualityReportEnable) {
                return;
            }
            GroupPlayer.this.mHandler.removeMessages(1);
            GroupPlayer.this.mHandler.sendEmptyMessageDelayed(1, (long)GroupPlayer.this.mReportInterval);
        }
    };
    private OnStateChangeListener mStateChangeListener;
    private OnStateChangeListener onStateChangeListener = new OnStateChangeListener(){

        @Override
        public void onStateChanged(ICastPlayer iCastPlayer, int n2) {
            if (GroupPlayer.this.mStateChangeListener != null) {
                GroupPlayer.this.mStateChangeListener.onStateChanged(iCastPlayer, n2);
            }
        }
    };
    private OnInfoListener mInfoListener;
    private OnInfoListener onInfoListener = new OnInfoListener(){

        @Override
        public void onInfo(ICastPlayer iCastPlayer, int n2, int n3, int n4) {
            if (GroupPlayer.this.mInfoListener != null) {
                GroupPlayer.this.mInfoListener.onInfo(iCastPlayer, n2, n3, n4);
            }
        }

        @Override
        public void onInfo(ICastPlayer iCastPlayer, int n2, String string) {
            if (GroupPlayer.this.mInfoListener != null) {
                GroupPlayer.this.mInfoListener.onInfo(iCastPlayer, n2, string);
            }
        }
    };
    private OnErrorListener mErrorListener;
    private OnErrorListener onErrorListener = new OnErrorListener(){

        @Override
        public void onError(ICastPlayer iCastPlayer, int n2, int n3, String string) {
            if (GroupPlayer.this.mErrorListener != null) {
                GroupPlayer.this.mErrorListener.onError(iCastPlayer, n2, n3, string);
            }
        }
    };
    private OnCompletionListener mCompletionListener;
    private OnCompletionListener onCompletionListener = new OnCompletionListener(){

        @Override
        public void onComplete(ICastPlayer iCastPlayer) {
            if (GroupPlayer.this.mCompletionListener != null) {
                GroupPlayer.this.mCompletionListener.onComplete(iCastPlayer);
            }
        }
    };
    private OnStopListener mStopListener;
    private final OnStopListener onStopListener = new OnStopListener(){

        @Override
        public void onStop(ICastPlayer iCastPlayer, StopInfo stopInfo) {
            SourceLog.i(GroupPlayer.TAG, "OnStopListener call stop ");
            GroupPlayer.this.isStopped = true;
            if (GroupPlayer.this.mStopListener != null) {
                GroupPlayer.this.mStopListener.onStop(iCastPlayer, stopInfo);
            }
            GroupPlayer.this.stop(GroupPlayer.this.mPlayInfo.getKey());
        }
    };
    private boolean isCallPlay = false;
    private final YimBridge.IOnSinkChangeListener onSinkChangeListener = new YimBridge.IOnSinkChangeListener(){

        @Override
        public void onChange(int n2) {
            SourceLog.i(GroupPlayer.TAG, " notifySinkChange result " + n2 + " get notify Sink Change result time : " + (System.currentTimeMillis() - GroupPlayer.this.startChangeTime));
            if (n2 == 1) {
                GroupPlayer.this.onNetChangeReconnectDevice(4);
                GroupPlayer.this.startResetEncoder();
                GroupPlayer.this.getChangeReport(1, (int)(System.currentTimeMillis() - GroupPlayer.this.startChangeTime));
            } else {
                GroupPlayer.this.getChangeReport(0, 0);
            }
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (!GroupPlayer.this.mQualityReportEnable) break;
                    GroupPlayer.this.reportQuality();
                    GroupPlayer.this.mHandler.removeMessages(1);
                    GroupPlayer.this.mHandler.sendEmptyMessageDelayed(1, (long)GroupPlayer.this.mReportInterval);
                    break;
                }
                case 2: {
                    ConnectManager.getInstance().groupReconnect();
                }
            }
            return false;
        }
    });
    private CaptureBridge.ICaptureDispatcher mCaptureDispatcher = new CaptureBridge.ICaptureDispatcher(){
        private int wrongFrameCount = 0;

        @Override
        public void onSinkPrepared(int n2, AbsBridge absBridge, int n3, int n4, int n5, int n6, String string) {
            SourceLog.i(GroupPlayer.TAG, "onSinkPrepared type:" + n2);
            a a2 = new a();
            a2.a = n3;
            a2.b = n4;
            a2.c = n5;
            a2.e = string;
            a2.d = n6;
            GroupPlayer.this.mMirrorInfos.put(n2, (Object)a2);
            GroupPlayer.this.mBridges.put(n2, (Object)absBridge);
            if (n2 == 1 && GroupPlayer.this.mCurrentPlayer != GroupPlayer.this.mLelinkPlayer || n2 == 4 && GroupPlayer.this.mCurrentPlayer != GroupPlayer.this.mYimPlayer) {
                SourceLog.i(GroupPlayer.TAG, "onSinkPrepared ignore");
                return;
            }
            GroupPlayer.this.mCurrentPlayer.getBridge().setExternalMirrorData();
            if (CaptureBridge.getInstance().isRunning()) {
                CaptureBridge.getInstance().resetCaptureEncoder(n2, a2.a, a2.b, a2.c, a2.d, a2.e);
            } else {
                CaptureBridge.getInstance().startScreenCapture(n2, a2.a, a2.b, a2.c, n6, a2.e);
            }
        }

        @Override
        public boolean onNetworkPoor() {
            SourceLog.i(GroupPlayer.TAG, "onNetworkPoor");
            GroupPlayer.this.doChangeChannel(4);
            return true;
        }

        @Override
        public void onBroken(int n2) {
            SourceLog.i(GroupPlayer.TAG, "onBroken");
            GroupPlayer.this.startChangeTime = System.currentTimeMillis();
            if (n2 == 1) {
                GroupPlayer.this.doChangeChannel(4);
            }
        }

        @Override
        public void onVideoDataCallback(ByteBuffer byteBuffer, int n2, int n3, int n4, long l2) {
            if (GroupPlayer.this.mCurrentPlayer != null && GroupPlayer.this.mCurrentPlayer.getBridge() != null) {
                if (System.currentTimeMillis() - GroupPlayer.this.mPrintFrameType > 3000L) {
                    GroupPlayer.this.mPrintFrameType = System.currentTimeMillis();
                    SourceLog.i(GroupPlayer.TAG, "onVideoDataCallback print " + n4 + " cloud:" + (GroupPlayer.this.mCurrentPlayer instanceof YimPlayer) + "  " + n2 + "  " + n3);
                }
                if (GroupPlayer.this.startChangeTime > 0L) {
                    SourceLog.i(GroupPlayer.TAG, "onVideoDataCallback startChangeTime  : " + (System.currentTimeMillis() - GroupPlayer.this.startChangeTime));
                    GroupPlayer.this.startChangeTime = 0L;
                }
                if (GroupPlayer.this.isPauseSend) {
                    return;
                }
                GroupPlayer.this.mCurrentPlayer.getBridge().sendVideoData(byteBuffer, n2, n3, n4, l2);
            } else {
                SourceLog.i(GroupPlayer.TAG, "onVideoDataCallback ignore, has no valid player now " + n4);
            }
        }

        @Override
        public void onAudioDataCallback(byte[] byArray, int n2, int n3, int n4) {
            if (GroupPlayer.this.mCurrentPlayer != null && GroupPlayer.this.mCurrentPlayer.getBridge() != null) {
                if (GroupPlayer.this.mCurrentPlayer.getBridge() instanceof YimBridge && n4 == 1) {
                    ++this.wrongFrameCount;
                    if (this.wrongFrameCount > 100) {
                        SourceLog.i(GroupPlayer.TAG, "==================== request pcm data ============ ");
                        this.wrongFrameCount = 0;
                        CaptureBridge.getInstance().setAudioSwitch(CaptureBridge.getInstance().getAudioSwitch(), 0, ((GroupPlayer)GroupPlayer.this).mPlayInfo.requestAudioFocus, true);
                    }
                    return;
                }
                if (n4 == 0 && GroupPlayer.this.mCurrentPlayer.getBridge() instanceof LelinkBridge) {
                    ++this.wrongFrameCount;
                    if (this.wrongFrameCount > 100) {
                        this.wrongFrameCount = 0;
                        SourceLog.i(GroupPlayer.TAG, "==================== request aac data============ ");
                        CaptureBridge.getInstance().setAudioSwitch(CaptureBridge.getInstance().getAudioSwitch(), 1, ((GroupPlayer)GroupPlayer.this).mPlayInfo.requestAudioFocus, true);
                    }
                    return;
                }
                if (System.currentTimeMillis() - GroupPlayer.this.mPrintAudioFrameType > 5000L) {
                    GroupPlayer.this.mPrintAudioFrameType = System.currentTimeMillis();
                    SourceLog.i(GroupPlayer.TAG, "onAudioDataCallback print " + n4 + " ======= " + n3);
                }
                this.wrongFrameCount = 0;
                GroupPlayer.this.mCurrentPlayer.getBridge().sendAudioData(byArray, n2, n3);
            }
        }

        @Override
        public void onCaptureScreenshot(int n2) {
            SourceLog.i(GroupPlayer.TAG, "onCaptureScreenshot");
        }

        @Override
        public void onCaptureStop(int n2) {
            try {
                SourceLog.i(GroupPlayer.TAG, "onCaptureStop " + n2);
                for (int i2 = 0; i2 < GroupPlayer.this.mBridges.size(); ++i2) {
                    ((AbsBridge)GroupPlayer.this.mBridges.valueAt(i2)).onCaptureStop(n2);
                }
            }
            catch (Exception exception) {
                SourceLog.w(GroupPlayer.TAG, exception);
            }
        }

        @Override
        public void onCaptureStart(int n2) {
            SourceLog.i(GroupPlayer.TAG, "onCaptureStart " + n2);
            if (GroupPlayer.this.mCurrentPlayer != null && GroupPlayer.this.mCurrentPlayer.getBridge() != null) {
                GroupPlayer.this.mCurrentPlayer.getBridge().onCaptureStart(n2);
            }
        }

        @Override
        public void onCaptureInfo(int n2, String string) {
            SourceLog.i(GroupPlayer.TAG, "onCaptureInfo " + n2 + "/" + string);
            if (GroupPlayer.this.mCurrentPlayer != null && GroupPlayer.this.mCurrentPlayer.getBridge() != null) {
                GroupPlayer.this.mCurrentPlayer.getBridge().onInfo(n2, string);
            }
        }
    };
    private final ProtocolListener mBrowseListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            try {
                SourceLog.i(GroupPlayer.TAG, "findLocalMirrorDevice  onResult");
                String string = "";
                if (stringArray != null) {
                    string = stringArray[0];
                }
                CLog.i(GroupPlayer.TAG, "restartLocalMirror onResult:" + string);
                if (20 == n2 && !TextUtils.isEmpty((CharSequence)string)) {
                    CLog.i(GroupPlayer.TAG, "restartLocalMirror  ");
                    GroupPlayer.this.assembleServiceInfo(string);
                } else {
                    SourceLog.i(GroupPlayer.TAG, "not find local mirror device");
                }
            }
            catch (Exception exception) {
                CLog.w(GroupPlayer.TAG, exception);
            }
        }
    };
    private boolean isPauseSend;
    private DeviceWLANCheckTask mDeviceWLANCheckTask;
    private int mQualityCount = 0;
    private int mChangeCount = 0;

    private void assembleServiceInfo(String string) {
        ParamsMap paramsMap = ParamsMap.create(string);
        if (paramsMap != null) {
            this.mPlayInfo.serviceInfo.setIp(paramsMap.getIp());
            BrowserInfo browserInfo = this.mPlayInfo.serviceInfo.getBrowserInfos().get(1);
            if (browserInfo == null) {
                browserInfo = BrowserResolver.resolveLelinkInfo(string);
                this.mPlayInfo.serviceInfo.getBrowserInfos().put(1, browserInfo);
            } else {
                browserInfo.getExtras().put("lelinkport", paramsMap.getLelinkPort() + "");
                browserInfo.getExtras().put("mirror", paramsMap.getStringParam("mirror_port"));
                browserInfo.getExtras().put("raop", paramsMap.getStringParam("raop_port"));
                browserInfo.getExtras().put("airplay", paramsMap.getStringParam("airplay_port"));
                browserInfo.getExtras().put("remote", paramsMap.getStringParam("remote"));
                this.mPlayInfo.serviceInfo.getBrowserInfos().put(1, browserInfo);
            }
            if (this.isStopped) {
                ConnectManager.getInstance().groupReconnect();
            } else {
                this.onNetChangeReconnectDevice(1);
            }
        }
    }

    private void restartLocalPlayer() {
        CaptureBridge.getInstance().pauseEncode(true);
        try {
            if (this.mLelinkPlayer != null) {
                this.mLelinkPlayer.setOnCompletionListener(null);
                this.mLelinkPlayer.setOnStateChangeListener(null);
                this.mLelinkPlayer.setOnErrorListener(null);
                this.mLelinkPlayer.setOnInfoListener(null);
                this.mLelinkPlayer.setOnStopListener(null);
                this.mLelinkPlayer.getBridge().frozen(true);
                this.mLelinkPlayer.stop(this.mPlayInfo.getKey());
            }
            this.mLelinkPlayer = null;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceLog.i(TAG, " restartLocalPlayer ... ");
        this.createLocalPlayer(false);
        this.mLelinkPlayer.start(this.mPlayInfo.getKey());
        this.mCurrentPlayer = this.mLelinkPlayer;
        this.isPauseSend = false;
        if (LelinkSdkManager.getInstance().mOuterMirrorChangeListener != null) {
            LelinkSdkManager.getInstance().mOuterMirrorChangeListener.onMirrorChange(4, 1);
        }
    }

    public GroupPlayer(Context context, OutParameter outParameter) {
        this.mContext = context;
        this.mPlayInfo = outParameter;
        SourceLog.i(TAG, TAG);
        switch (outParameter.connectProtocol) {
            case 4: {
                this.createCloudPlayer(false);
                this.mCurrentPlayer = this.mYimPlayer;
                break;
            }
            case 1: {
                this.createLocalPlayer(false);
                this.mCurrentPlayer = this.mLelinkPlayer;
                break;
            }
            case 6: {
                this.createCloudPlayer(true);
                this.createLocalPlayer(false);
                this.mCurrentPlayer = this.mLelinkPlayer;
            }
        }
        CaptureBridge.getInstance().setICaptureDispatcher(this.mCaptureDispatcher);
        this.mQualityReportEnable = SDKConfig.getInstance().getTransferEnable() == 1;
        this.mReportInterval = SDKConfig.getInstance().getQualityInterval();
    }

    void createLocalPlayer(boolean bl) {
        this.mLelinkPlayer = new LelinkPlayer(this.mContext, this.mPlayInfo);
        this.initListener(this.mLelinkPlayer);
        this.mLelinkPlayer.getBridge().frozen(bl);
    }

    void createCloudPlayer(boolean bl) {
        this.mYimPlayer = new YimPlayer(this.mContext, this.mPlayInfo);
        this.initListener(this.mYimPlayer);
        this.mYimPlayer.getBridge().frozen(bl);
    }

    private void initListener(AbsPlayer absPlayer) {
        absPlayer.setOnLoadingListener(this.onLoadingListener);
        absPlayer.setOnPreparedListener(this.onPreparedListener);
        absPlayer.setOnStateChangeListener(this.onStateChangeListener);
        absPlayer.setOnErrorListener(this.onErrorListener);
        absPlayer.setOnInfoListener(this.onInfoListener);
        absPlayer.setOnCompletionListener(this.onCompletionListener);
        absPlayer.setOnStopListener(this.onStopListener);
    }

    public void doChangeChannel(int n2) {
        this.mHandler.removeMessages(2);
        this.isPauseSend = true;
        CaptureBridge.getInstance().pauseEncode(true);
        if (this.isStopped) {
            SourceLog.w(TAG, "doChangeChannel ignore");
            return;
        }
        SourceLog.i(TAG, "doChangeChannel " + n2);
        AbsBridge absBridge = null;
        AbsBridge absBridge2 = null;
        int n3 = 0;
        n3 = this.mCurrentPlayer == this.mLelinkPlayer ? 1 : 4;
        if (n2 == 1) {
            if (this.mLelinkPlayer == null) {
                try {
                    this.findLocalMirrorDevice();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            absBridge = this.mYimPlayer.getBridge();
            absBridge2 = this.mLelinkPlayer.getBridge();
        } else {
            absBridge = this.mLelinkPlayer.getBridge();
            absBridge2 = this.mYimPlayer.getBridge();
        }
        absBridge.frozen(true);
        absBridge2.frozen(false);
        if (absBridge2 instanceof YimBridge) {
            SourceLog.i(TAG, " Change to public Channel ");
            this.mCurrentPlayer = this.mYimPlayer;
            ((YimBridge)this.mCurrentPlayer.getBridge()).notifySinkChange(this.onSinkChangeListener);
            this.startChangeTime = System.currentTimeMillis();
        } else {
            SourceLog.i(TAG, " Change to local Channel ");
            this.startResetEncoder();
        }
        if (LelinkSdkManager.getInstance().mOuterMirrorChangeListener != null) {
            LelinkSdkManager.getInstance().mOuterMirrorChangeListener.onMirrorChange(n3, n2);
        }
    }

    private void onNetChangeReconnectDevice(final int n2) {
        SourceLog.i(TAG, "====onNetChangeReconnectDevice====" + n2);
        ConnectManager.getInstance().groupReconnect(n2, this.mPlayInfo.serviceInfo, new IConnectListener(){

            @Override
            public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n22) {
                SourceLog.i(GroupPlayer.TAG, "====onNetChangeReconnectDevice  onConnect=====" + n2 + " time " + (System.currentTimeMillis() - GroupPlayer.this.startChangeTime));
                if (n2 == 1) {
                    AbsBridge absBridge = GroupPlayer.this.mCurrentPlayer.getBridge();
                    if (absBridge != null) {
                        absBridge.frozen(true);
                    }
                    GroupPlayer.this.restartLocalPlayer();
                }
                GroupPlayer.this.mCurrentPlayer.getBridge().setExternalMirrorData();
            }

            @Override
            public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n22, int n3) {
                SourceLog.i(GroupPlayer.TAG, "===onNetChangeReconnectDevice===onDisconnect===");
                GroupPlayer.this.stop(GroupPlayer.this.mPlayInfo.getKey());
            }
        });
    }

    public void onWifiConnected() {
        if (this.isStopped) {
            SourceLog.w(TAG, "onWifiConnected ignore");
            ConnectManager.getInstance().groupReconnect();
            return;
        }
        long l2 = 1000L;
        this.startChangeTime = System.currentTimeMillis();
        try {
            ModuleLinker.getInstance().callMethod("3E2654D2CC32696C3DDAC9238339F4F6", new Object[0]);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean bl = GroupPlayer.this.mCurrentPlayer == GroupPlayer.this.mYimPlayer;
                SourceLog.i(GroupPlayer.TAG, "onWifiConnected isYimPlayer   :" + bl);
                if (bl) {
                    GroupPlayer.this.mHandler.removeMessages(2);
                    if (GroupPlayer.this.mDeviceWLANCheckTask != null) {
                        GroupPlayer.this.mDeviceWLANCheckTask.cancel(true);
                    }
                    GroupPlayer.this.mDeviceWLANCheckTask = new DeviceWLANCheckTask(GroupPlayer.this);
                    GroupPlayer.this.mDeviceWLANCheckTask.executeOnExecutor(Executors.newCachedThreadPool(), new LelinkServiceInfo[]{((GroupPlayer)GroupPlayer.this).mPlayInfo.serviceInfo});
                }
            }
        }, l2);
    }

    private void findLocalMirrorDevice() {
        SourceLog.i(TAG, "findLocalMirrorDevice ");
        ParamsMap paramsMap = ParamsMap.create();
        if (this.mPlayInfo != null) {
            paramsMap.putParam("sink_name", this.mPlayInfo.serviceInfo.getName());
            paramsMap.putParam("ip", this.mPlayInfo.serviceInfo.getIp());
            paramsMap.putParam("uid", this.mPlayInfo.serviceInfo.getUid());
        }
        ModuleLinker.getInstance().callMethod("52D2A158F93972986496FB8AC7EE672C", 1, paramsMap, this.mBrowseListener);
    }

    private void startResetEncoder() {
        try {
            a a2;
            int n2 = 1;
            if (this.mCurrentPlayer == this.mYimPlayer) {
                n2 = 4;
                SourceLog.i(TAG, "current is yim ");
            }
            if ((a2 = (a)this.mMirrorInfos.get(n2)) == null) {
                SourceLog.i(TAG, "mirror info is null ");
                this.stop(this.mPlayInfo.getKey());
                return;
            }
            CaptureBridge.getInstance().resetCaptureEncoder(n2, a2.a, a2.b, a2.c, a2.d, a2.e);
            ConnectManager.getInstance().switchGroupConnection(n2);
            SourceLog.i(TAG, "setExternalMirrorData by startResetEncoder");
            this.isPauseSend = false;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setDataSource(OutParameter outParameter) {
        this.mPlayInfo = outParameter;
        this.mCurrentPlayer.setDataSource(outParameter);
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        return this.mCurrentPlayer.switchExpansionScreen(bl);
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        this.mCurrentPlayer.setSecondMirrorView(secondMirrorView);
    }

    @Override
    public boolean start(String string) {
        SourceLog.i(TAG, "start isCallPlay:" + this.isCallPlay);
        this.mHandler.sendEmptyMessageDelayed(2, 5000L);
        if (this.isCallPlay) {
            return this.mCurrentPlayer.start(string);
        }
        this.isCallPlay = true;
        if (this.mLelinkPlayer != null && this.mYimPlayer != null) {
            this.mLelinkPlayer.start(string);
            this.mYimPlayer.start(string);
        } else if (this.mLelinkPlayer != null) {
            this.mLelinkPlayer.start(string);
        } else if (this.mYimPlayer != null) {
            this.mYimPlayer.start(string);
        }
        return true;
    }

    @Override
    public boolean pause(String string) {
        return this.mCurrentPlayer.pause(string);
    }

    @Override
    public boolean playDrama(String string, String string2) {
        return false;
    }

    @Override
    public boolean playNextDrama(String string) {
        return false;
    }

    @Override
    public boolean playPreDrama(String string) {
        return false;
    }

    @Override
    public boolean appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        return false;
    }

    @Override
    public boolean clearPlayList(String string) {
        return false;
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
    }

    @Override
    public boolean resume(String string) {
        return this.mCurrentPlayer.resume(string);
    }

    @Override
    public boolean seekTo(String string, int n2) {
        return this.mCurrentPlayer.seekTo(string, n2);
    }

    @Override
    public void addVolume() {
        this.mCurrentPlayer.addVolume();
    }

    @Override
    public void subVolume() {
        this.mCurrentPlayer.subVolume();
    }

    @Override
    public void setVolume(int n2) {
        this.mCurrentPlayer.setVolume(n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        this.mCurrentPlayer.selectAudiotrack(n2);
    }

    @Override
    public void stop(String string) {
        SourceLog.i(TAG, "group play call stop ");
        this.isStopped = true;
        if (this.mLelinkPlayer != null) {
            this.mLelinkPlayer.stop(string);
        }
        if (this.mYimPlayer != null) {
            this.mYimPlayer.stop(string);
        }
        this.mHandler.removeMessages(1);
        this.mQualityReportEnable = false;
    }

    @Override
    public void onAppPause() {
        this.mCurrentPlayer.onAppPause();
    }

    @Override
    public void onAppResume() {
        this.mCurrentPlayer.onAppResume();
    }

    @Override
    public void setOnLoadingListener(OnLoadingListener onLoadingListener) {
        this.mLoadingListener = onLoadingListener;
    }

    @Override
    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.mPreparedListener = onPreparedListener;
    }

    @Override
    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mStateChangeListener = onStateChangeListener;
    }

    @Override
    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mInfoListener = onInfoListener;
    }

    @Override
    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mErrorListener = onErrorListener;
    }

    @Override
    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        this.mCompletionListener = onCompletionListener;
    }

    @Override
    public void setOnStopListener(OnStopListener onStopListener) {
        this.mStopListener = onStopListener;
    }

    public void reportQuality() {
        IScreenCapture iScreenCapture = CaptureBridge.getInstance().getScreenCapture();
        if (iScreenCapture == null) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("bid", this.mQualityCount++);
            jSONObject.put("cts", System.currentTimeMillis());
            jSONObject.put("cr", (Object)String.valueOf(iScreenCapture.getBitrate()));
            jSONObject.put("fr", (Object)String.valueOf(iScreenCapture.getFps()));
            jSONObject.put("mode", (Object)iScreenCapture.getMirrorMode());
            jSONObject.put("ct", (Object)"arm");
            jSONObject.put("rr", (Object)iScreenCapture.getResolution());
            if (this.mCurrentPlayer == this.mYimPlayer) {
                jSONObject.put("nct", (Object)"5");
            } else {
                jSONObject.put("nct", (Object)"1");
            }
            jSONObject.put("cq", (Object)"1");
            jSONObject.put("sta", (Object)"1");
            jSONObject.put("mt", 102);
            jSONArray.put((Object)jSONObject);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceDataReport.getInstance().onQuality(this.mPlayInfo, jSONArray);
    }

    public void getChangeReport(int n2, int n3) {
        JSONArray jSONArray = new JSONArray();
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("bid", this.mChangeCount++);
            jSONObject.put("cts", System.currentTimeMillis());
            if (this.mCurrentPlayer == this.mYimPlayer) {
                jSONObject.put("csb", (Object)"1");
                jSONObject.put("csa", (Object)"5");
            } else {
                jSONObject.put("csb", (Object)"5");
                jSONObject.put("csa", (Object)"1");
            }
            jSONObject.put("sta", (Object)String.valueOf(n2));
            jSONObject.put("du", (Object)String.valueOf(n3));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceDataReport.getInstance().onMirrorChange(this.mPlayInfo, jSONArray);
    }

    @Override
    public void release(String string) {
        SourceLog.i(TAG, "release");
        if (this.mLelinkPlayer != null) {
            this.mLelinkPlayer.release(string);
        }
        this.mLelinkPlayer = null;
        if (this.mYimPlayer != null) {
            this.mYimPlayer.release(string);
        }
        this.mYimPlayer = null;
        CaptureBridge.getInstance().setICaptureDispatcher(null);
        this.mCaptureDispatcher = null;
    }

    @SuppressLint(value={"StaticFieldLeak"})
    final class DeviceWLANCheckTask
    extends AsyncTask<LelinkServiceInfo, Void, Boolean> {
        WeakReference<GroupPlayer> reference;

        DeviceWLANCheckTask(GroupPlayer groupPlayer2) {
            this.reference = new WeakReference<GroupPlayer>(groupPlayer2);
        }

        protected Boolean doInBackground(LelinkServiceInfo ... lelinkServiceInfoArray) {
            try {
                LelinkServiceInfo lelinkServiceInfo = lelinkServiceInfoArray[0];
                BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
                if (browserInfo == null) {
                    return false;
                }
                return KeepAliveUtitls.tcpCheckTvState(lelinkServiceInfo.getName(), browserInfo.getIp(), Integer.parseInt(browserInfo.getExtras().get("lelinkport")), 2000);
            }
            catch (Exception exception) {
                SourceLog.w(GroupPlayer.TAG, " check wlan is failed ... ");
                return false;
            }
        }

        protected void onPostExecute(Boolean bl) {
            super.onPostExecute((Object)bl);
            if (!this.isCancelled()) {
                try {
                    if (bl.booleanValue()) {
                        SourceLog.i(GroupPlayer.TAG, "device is Online ");
                        ((GroupPlayer)this.reference.get()).onNetChangeReconnectDevice(1);
                    } else {
                        ((GroupPlayer)this.reference.get()).onNetChangeReconnectDevice(4);
                        SourceLog.i(GroupPlayer.TAG, "device is offline ");
                        ((GroupPlayer)this.reference.get()).findLocalMirrorDevice();
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(GroupPlayer.TAG, exception);
                }
            }
            GroupPlayer.this.mDeviceWLANCheckTask = null;
        }
    }
}

