/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass.sinktouch;

import android.text.TextUtils;
import com.hpplay.sdk.source.bean.SinkTouchEvent;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.sinktouch.ISinkTouchEventCallback;
import com.hpplay.sdk.source.utils.ByteUtils;
import java.util.Arrays;

public class SinkTouchEventIMChannel {
    private static final String TAG = "SinkTouchEventIMChannel";
    private ISinkTouchEventCallback mCallback;
    private static SinkTouchEventIMChannel sInstance;

    private SinkTouchEventIMChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SinkTouchEventIMChannel getInstance() {
        if (sInstance != null) return sInstance;
        Class<SinkTouchEventIMChannel> clazz = SinkTouchEventIMChannel.class;
        synchronized (SinkTouchEventIMChannel.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SinkTouchEventIMChannel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setCallback(ISinkTouchEventCallback iSinkTouchEventCallback) {
        this.mCallback = iSinkTouchEventCallback;
    }

    public void onReceiveIMTouchEvent(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.e(TAG, "onReceiveIMTouchEvent msg is null");
            return;
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        SourceLog.i(TAG, "onReceiveIMTouchEvent eventBytes : " + string + " / " + Arrays.toString(byArray));
        if (this.mCallback != null) {
            this.mCallback.onEventReceived(SinkTouchEvent.parseProtocolData(byArray));
        }
    }
}

