/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import java.util.Iterator;

public class Update
extends Message {
    private Name origin;
    private int dclass;

    public Update(Name name, int n2) {
        if (name.isAbsolute()) {
            DClass.check(n2);
            this.getHeader().setOpcode(5);
            Record record = Record.newRecord(name, 6, 1);
            this.addRecord(record, 0);
            this.origin = name;
            this.dclass = n2;
            return;
        }
    }

    public Update(Name name) {
        this(name, 1);
    }

    private void newUpdate(Record record) {
        this.addRecord(record, 2);
    }

    public void add(Name name, int n2, long l2, String string) {
        this.newUpdate(Record.fromString(name, n2, this.dclass, l2, string, this.origin));
    }

    public void add(Name name, int n2, long l2, Tokenizer tokenizer) {
        this.newUpdate(Record.fromString(name, n2, this.dclass, l2, tokenizer, this.origin));
    }

    public void add(Record record) {
        this.newUpdate(record);
    }

    public void add(Record[] recordArray) {
        for (int i2 = 0; i2 < recordArray.length; ++i2) {
            this.add(recordArray[i2]);
        }
    }

    public void add(RRset rRset) {
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            this.add((Record)iterator.next());
        }
    }

    public void delete(Name name, int n2) {
        this.newUpdate(Record.newRecord(name, n2, 255, 0L));
    }

    public void replace(Record record) {
        this.delete(record.getName(), record.getType());
        this.add(record);
    }
}

