/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.Constants;
import com.hpplay.sdk.source.mdns.MulticastDNSMulticastOnlyQuerier;
import com.hpplay.sdk.source.mdns.Querier;
import com.hpplay.sdk.source.mdns.Resolution;
import com.hpplay.sdk.source.mdns.xbill.dns.ExtendedResolver;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Resolver;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIG;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MulticastDNSQuerier
implements Querier {
    private ResolverListener mResolverListener;
    protected boolean mIpv4 = false;
    protected boolean mIpv6 = false;
    protected ArrayList<Querier> multicastResponders = new ArrayList();
    protected Resolver[] mUnicastResolvers;
    private boolean mdnsVerbose;
    protected ResolverListener resolverDispatch = new ResolverListener(){

        @Override
        public void handleException(Object object, Exception exception) {
            if (MulticastDNSQuerier.this.mResolverListener != null) {
                MulticastDNSQuerier.this.mResolverListener.handleException(object, exception);
            }
        }

        @Override
        public void receiveMessage(Object object, Message message) {
            if (MulticastDNSQuerier.this.mResolverListener != null) {
                MulticastDNSQuerier.this.mResolverListener.receiveMessage(object, message);
            }
        }
    };
    private Querier ipv4Responder = null;
    private Querier ipv6Responder = null;

    public static boolean isMulticastDomain(Name name) {
        for (Name name2 : Constants.IPv4_MULTICAST_DOMAINS) {
            if (!name.equals(name2) && !name.subdomain(name2)) continue;
            return true;
        }
        for (Name name2 : Constants.IPv6_MULTICAST_DOMAINS) {
            if (!name.equals(name2) && !name.subdomain(name2)) continue;
            return true;
        }
        return false;
    }

    public MulticastDNSQuerier() {
        this(true, false, new Resolver[]{new ExtendedResolver()});
    }

    public MulticastDNSQuerier(boolean bl, boolean bl2) {
        this(bl, bl2, (Resolver[])null);
        Log.i((String)"checklistnen", (String)"MulticastDNSQuerier");
    }

    public MulticastDNSQuerier(boolean bl, boolean bl2, Resolver resolver) {
        this(bl, bl2, new Resolver[]{resolver});
    }

    public MulticastDNSQuerier(boolean bl, boolean bl2, Resolver[] resolverArray) {
        this.mIpv4 = bl;
        this.mIpv6 = bl2;
        this.mUnicastResolvers = resolverArray;
    }

    private boolean getNetWorkInfos(boolean bl, boolean bl2, Resolver[] resolverArray) {
        this.mdnsVerbose = Options.check("mdns_verbose");
        this.mUnicastResolvers = resolverArray == null || resolverArray.length == 0 ? new Resolver[]{new ExtendedResolver()} : resolverArray;
        Exception exception = null;
        IOException iOException = null;
        if (bl) {
            try {
                Log.i((String)"DNSQuerier", (String)"create DNSQuerier-------");
                this.ipv4Responder = new MulticastDNSMulticastOnlyQuerier(false);
                this.mIpv4 = true;
            }
            catch (Exception exception2) {
                this.ipv4Responder = null;
                exception = exception2;
            }
        }
        if (bl2) {
            try {
                this.ipv6Responder = new MulticastDNSMulticastOnlyQuerier(true);
                this.mIpv6 = true;
            }
            catch (IOException iOException2) {
                this.ipv6Responder = null;
                iOException = iOException2;
            }
        }
        if (this.ipv4Responder != null && this.ipv6Responder != null) {
            this.multicastResponders.add(this.ipv4Responder);
            this.multicastResponders.add(this.ipv6Responder);
            this.ipv4Responder.registerListener(this.resolverDispatch);
            this.ipv6Responder.registerListener(this.resolverDispatch);
            return true;
        }
        if (this.ipv4Responder != null) {
            this.multicastResponders.add(this.ipv4Responder);
            this.ipv4Responder.registerListener(this.resolverDispatch);
            return true;
        }
        if (this.ipv6Responder != null) {
            this.multicastResponders.add(this.ipv6Responder);
            this.ipv6Responder.registerListener(this.resolverDispatch);
            return true;
        }
        if (exception != null) {
            throw exception;
        }
        if (iOException != null) {
            throw iOException;
        }
        return false;
    }

    @Override
    public void broadcast(Message message, boolean bl) {
        boolean bl2 = false;
        IOException iOException = null;
        for (Querier querier : this.multicastResponders) {
            try {
                querier.broadcast(message, bl);
                bl2 = true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.sendAsync(message, new ResolverListener(){

                @Override
                public void handleException(Object object, Exception exception) {
                    if (MulticastDNSQuerier.this.mResolverListener != null) {
                        MulticastDNSQuerier.this.mResolverListener.handleException(object, exception);
                    }
                }

                @Override
                public void receiveMessage(Object object, Message message) {
                    if (MulticastDNSQuerier.this.mResolverListener != null) {
                        MulticastDNSQuerier.this.mResolverListener.receiveMessage(object, message);
                    }
                }
            });
        }
        if (!bl2 && iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void close() {
        try {
            for (Querier querier : this.multicastResponders) {
                querier.close();
            }
            this.multicastResponders.clear();
        }
        catch (Exception exception) {
            Log.w((String)"mdns", (Throwable)exception);
        }
        this.ipv4Responder = null;
        this.ipv6Responder = null;
    }

    @Override
    public Name[] getMulticastDomains() {
        if (this.mIpv4 && this.mIpv6) {
            return Constants.ALL_MULTICAST_DNS_DOMAINS;
        }
        if (this.mIpv4) {
            return Constants.IPv4_MULTICAST_DOMAINS;
        }
        if (this.mIpv6) {
            return Constants.IPv6_MULTICAST_DOMAINS;
        }
        return new Name[0];
    }

    public Resolver[] getmUnicastResolvers() {
        return this.mUnicastResolvers;
    }

    @Override
    public boolean isIPv4() {
        return this.mIpv4;
    }

    @Override
    public boolean isIPv6() {
        return this.mIpv6;
    }

    @Override
    public boolean isOperational() {
        for (Querier querier : this.multicastResponders) {
            if (querier.isOperational()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResolverListener registerListener(ResolverListener resolverListener) {
        for (Querier querier : this.multicastResponders) {
            this.mResolverListener = querier.registerListener(resolverListener);
        }
        return resolverListener;
    }

    @Override
    public Message send(Message message) {
        Resolution resolution = new Resolution(this, message, null);
        resolution.start();
        return resolution.getResponse(6000);
    }

    @Override
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Resolution resolution = new Resolution(this, message, resolverListener);
        resolution.start();
        return resolution;
    }

    @Override
    public void setEDNS(int n2) {
        for (Querier querier : this.multicastResponders) {
            querier.setEDNS(n2);
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setEDNS(n2);
        }
    }

    @Override
    public void setEDNS(int n2, int n3, int n4, List list) {
        for (Querier querier : this.multicastResponders) {
            querier.setEDNS(n2, n3, n4, list);
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setEDNS(n2, n3, n4, list);
        }
    }

    @Override
    public void setIgnoreTruncation(boolean bl) {
        for (Querier querier : this.multicastResponders) {
            querier.setIgnoreTruncation(bl);
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setIgnoreTruncation(bl);
        }
    }

    @Override
    public void setPort(int n2) {
        for (Querier querier : this.multicastResponders) {
            querier.setPort(n2);
        }
    }

    @Override
    public void setRetryWaitTime(int n2) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(n2);
        }
    }

    @Override
    public void setRetryWaitTime(int n2, int n3) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(n2, n3);
        }
    }

    @Override
    public void setTCP(boolean bl) {
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setTCP(bl);
        }
    }

    @Override
    public void setTimeout(int n2) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(n2);
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setTimeout(n2);
        }
    }

    @Override
    public void setTimeout(int n2, int n3) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(n2, n3);
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setTimeout(n2, n3);
        }
    }

    @Override
    public void setTSIGKey(TSIG tSIG) {
        for (Querier querier : this.multicastResponders) {
            querier.setTSIGKey(tSIG);
        }
        for (Resolver resolver : this.mUnicastResolvers) {
            resolver.setTSIGKey(tSIG);
        }
    }

    @Override
    public boolean unregisterListener(ResolverListener resolverListener) {
        for (Querier querier : this.multicastResponders) {
            querier.unregisterListener(resolverListener);
        }
        return true;
    }

    @Override
    public boolean initNetWorkState() {
        return this.getNetWorkInfos(this.mIpv4, this.mIpv6, this.mUnicastResolvers);
    }
}

