/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.Constants;
import com.hpplay.sdk.source.mdns.MulticastDNSQuerier;
import com.hpplay.sdk.source.mdns.Querier;
import com.hpplay.sdk.source.mdns.ServiceInstance;
import com.hpplay.sdk.source.mdns.ServiceName;
import com.hpplay.sdk.source.mdns.ServiceRecodSorter;
import com.hpplay.sdk.source.mdns.xbill.dns.AAAARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.ARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.PTRRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverConfig;
import com.hpplay.sdk.source.mdns.xbill.dns.SRVRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.TXTRecord;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public abstract class MulticastDNSLookupBase
implements Constants,
Closeable {
    private String TAG = "MulticastDNSLookupBase";
    protected Querier defaultQuerier;
    protected Name[] defaultSearchPath;
    protected Name[] names;
    protected Querier querier;
    protected Name[] searchPath;
    protected int type = 255;
    protected Object browseID;
    protected int dclass = 255;
    protected Message[] queries;

    public MulticastDNSLookupBase(Name ... nameArray) {
        this(nameArray, 255, 255);
    }

    public MulticastDNSLookupBase(Name[] nameArray, int n2) {
        this(nameArray, n2, 255);
    }

    public MulticastDNSLookupBase(Name[] nameArray, int n2, int n3) {
        this();
        this.names = nameArray;
        this.type = n2;
        this.dclass = n3;
        this.buildQueries();
    }

    public MulticastDNSLookupBase(String ... stringArray) {
        this(stringArray, 255, 255);
    }

    public MulticastDNSLookupBase(String string, int n2) {
        this(new String[]{string}, n2, 255);
    }

    public MulticastDNSLookupBase(String string, int n2, int n3) {
        this(new String[]{string}, n2, n3);
    }

    public MulticastDNSLookupBase(String[] stringArray, int n2) {
        this(stringArray, n2, 255);
    }

    public MulticastDNSLookupBase(String[] stringArray, int n2, int n3) {
        this();
        ArrayList<Name> arrayList;
        if (stringArray != null && stringArray.length > 0) {
            arrayList = new ArrayList<Name>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].endsWith(".")) {
                    try {
                        arrayList.add(new Name(stringArray[i2]));
                    }
                    catch (Exception exception) {
                        Log.w((String)this.TAG, (Throwable)exception);
                    }
                    continue;
                }
                for (int i3 = 0; i3 < this.searchPath.length; ++i3) {
                    try {
                        arrayList.add(new Name(stringArray[i2] + "." + this.searchPath[i3]));
                        continue;
                    }
                    catch (Exception exception) {
                        Log.w((String)this.TAG, (Throwable)exception);
                    }
                }
            }
        } else {
            throw new UnknownHostException("Invalid Name(s) specified!");
        }
        this.names = arrayList.toArray(new Name[arrayList.size()]);
        this.type = n2;
        this.dclass = n3;
        this.buildQueries();
    }

    protected MulticastDNSLookupBase() {
        Log.i((String)"checklistnen", (String)"----------- MulticastDNSLookupBase");
        this.querier = this.getDefaultQuerier();
        this.searchPath = this.getDefaultSearchPath();
    }

    protected MulticastDNSLookupBase(Message message) {
        this();
        Record[] recordArray;
        this.queries = new Message[]{(Message)message.clone()};
        int n2 = -1;
        int n3 = -1;
        ArrayList<Name> arrayList = new ArrayList<Name>();
        for (Record record : recordArray = MulticastDNSUtils.extractRecords(message, 0)) {
            if (!arrayList.contains(record)) {
                arrayList.add(record.getName());
            }
            n2 = n2 < 0 ? record.getType() : 255;
            n3 = n3 < 0 ? record.getDClass() : 255;
        }
        if (arrayList.size() > 0) {
            this.type = n2;
            this.dclass = n3;
            try {
                this.names = (Name[])arrayList.toArray(new Record[arrayList.size()]);
            }
            catch (Exception exception) {
                Log.w((String)this.TAG, (Throwable)exception);
            }
        }
    }

    public void addNames(Name[] nameArray) {
        if (nameArray != null && nameArray.length > 0) {
            Name[] nameArray2 = this.names;
            Name[] nameArray3 = new Name[nameArray2.length + nameArray.length];
            System.arraycopy(nameArray2, 0, nameArray3, 0, nameArray2.length);
            System.arraycopy(nameArray2, nameArray2.length, nameArray3, nameArray2.length, nameArray.length);
            this.names = nameArray3;
            this.buildQueries();
        }
    }

    public void addNames(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            Name[] nameArray = new Name[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
            }
            this.addNames(nameArray);
        }
    }

    public void addSearchPath(Name[] nameArray) {
        if (nameArray != null && nameArray.length > 0) {
            Name[] nameArray2 = this.searchPath;
            Name[] nameArray3 = new Name[nameArray2.length + nameArray.length];
            System.arraycopy(nameArray2, 0, nameArray3, 0, nameArray2.length);
            System.arraycopy(nameArray2, nameArray2.length, nameArray3, nameArray2.length, this.names.length);
            this.searchPath = nameArray3;
            this.buildQueries();
        }
    }

    public void addSearchPath(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            Name[] nameArray = new Name[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
            }
            this.addSearchPath(nameArray);
        }
    }

    public Name[] getNames() {
        return this.names;
    }

    public synchronized Querier getQuerier() {
        return this.querier;
    }

    public Name[] getSearchPath() {
        return this.searchPath;
    }

    public void setNames(Name[] nameArray) {
        this.names = nameArray;
        this.buildQueries();
    }

    public void setNames(String[] stringArray) {
        if (stringArray == null) {
            this.names = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
        }
        this.setNames(nameArray);
    }

    public synchronized void setQuerier(Querier querier) {
        this.querier = querier;
    }

    public void setSearchPath(Name[] nameArray) {
        this.searchPath = nameArray;
        this.buildQueries();
    }

    public void setSearchPath(String[] stringArray) {
        if (stringArray == null) {
            this.searchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
        }
        this.setSearchPath(nameArray);
    }

    protected void buildQueries() {
        if (this.names != null && this.searchPath != null) {
            ArrayList<Name> arrayList = new ArrayList<Name>();
            ArrayList<Message> arrayList2 = new ArrayList<Message>();
            Message message = null;
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                Name name = this.names[i2];
                if (name.isAbsolute()) {
                    if (MulticastDNSQuerier.isMulticastDomain(name)) {
                        if (message == null) {
                            message = Message.newQuery(Record.newRecord(name, this.type, this.dclass));
                        } else {
                            message.addRecord(Record.newRecord(name, this.type, this.dclass), 0);
                        }
                    } else {
                        arrayList2.add(Message.newQuery(Record.newRecord(name, this.type, this.dclass)));
                    }
                    arrayList.add(name);
                    continue;
                }
                for (int i3 = 0; i3 < this.searchPath.length; ++i3) {
                    try {
                        Name name2 = Name.concatenate(name, this.searchPath[i3]);
                        if (MulticastDNSQuerier.isMulticastDomain(this.searchPath[i3])) {
                            if (message == null) {
                                message = Message.newQuery(Record.newRecord(name2, this.type, this.dclass));
                            } else {
                                message.addRecord(Record.newRecord(name2, this.type, this.dclass), 0);
                            }
                        } else {
                            arrayList2.add(Message.newQuery(Record.newRecord(name2, this.type, this.dclass)));
                        }
                        arrayList.add(name2);
                        continue;
                    }
                    catch (Exception exception) {
                        Log.w((String)this.TAG, (Throwable)exception);
                    }
                }
            }
            if (message != null) {
                arrayList2.add(message);
            }
            this.names = arrayList.toArray(new Name[arrayList.size()]);
            this.queries = arrayList2.toArray(new Message[arrayList2.size()]);
        }
    }

    public synchronized Querier getDefaultQuerier() {
        if (this.defaultQuerier == null) {
            try {
                this.defaultQuerier = new MulticastDNSQuerier(true, false);
            }
            catch (IOException iOException) {
                Log.w((String)this.TAG, (Throwable)iOException);
            }
        }
        return this.defaultQuerier;
    }

    public synchronized Name[] getDefaultSearchPath() {
        if (this.defaultSearchPath == null) {
            Name[] nameArray = ResolverConfig.getCurrentConfig().searchPath();
            this.defaultSearchPath = new Name[(nameArray != null ? nameArray.length : 0) + this.defaultQuerier.getMulticastDomains().length];
            int n2 = 0;
            if (nameArray != null) {
                this.defaultSearchPath = new Name[nameArray.length + this.defaultQuerier.getMulticastDomains().length];
                System.arraycopy(nameArray, 0, this.defaultSearchPath, n2, nameArray.length);
                n2 = nameArray.length;
            } else {
                this.defaultSearchPath = new Name[this.defaultQuerier.getMulticastDomains().length];
            }
            System.arraycopy(this.defaultQuerier.getMulticastDomains(), 0, this.defaultSearchPath, n2, this.defaultQuerier.getMulticastDomains().length);
        }
        return this.defaultSearchPath;
    }

    public synchronized void setDefaultQuerier(Querier querier) {
        this.defaultQuerier = querier;
    }

    public synchronized void setDefaultSearchPath(Name[] nameArray) {
        this.defaultSearchPath = nameArray;
    }

    public synchronized void setDefaultSearchPath(String[] stringArray) {
        if (stringArray == null) {
            this.defaultSearchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
        }
        this.defaultSearchPath = nameArray;
    }

    protected ServiceInstance[] extractServiceInstances(Record[] recordArray) {
        HashMap<ServiceName, ServiceInstance> hashMap = new HashMap<ServiceName, ServiceInstance>();
        Arrays.sort(recordArray, new ServiceRecodSorter());
        block9: for (Record record : recordArray) {
            switch (record.getType()) {
                case 33: {
                    ServiceInstance serviceInstance;
                    try {
                        serviceInstance = new ServiceInstance((SRVRecord)record);
                        hashMap.put(serviceInstance.getName(), serviceInstance);
                    }
                    catch (Exception exception) {
                        Log.w((String)this.TAG, (Throwable)exception);
                    }
                    continue block9;
                }
                case 12: {
                    PTRRecord pTRRecord = (PTRRecord)record;
                    ServiceInstance serviceInstance = (ServiceInstance)hashMap.get(pTRRecord.getTarget());
                    if (serviceInstance == null) continue block9;
                    if (pTRRecord.getTTL() > 0L) {
                        serviceInstance.addPointer(pTRRecord.getName());
                        continue block9;
                    }
                    serviceInstance.removePointer(pTRRecord.getName());
                    continue block9;
                }
                case 16: {
                    TXTRecord tXTRecord = (TXTRecord)record;
                    ServiceInstance serviceInstance = (ServiceInstance)hashMap.get(tXTRecord.getName());
                    if (serviceInstance == null) continue block9;
                    if (tXTRecord.getTTL() > 0L) {
                        serviceInstance.addTextRecords(tXTRecord);
                        continue block9;
                    }
                    serviceInstance.removeTextRecords(tXTRecord);
                    continue block9;
                }
                case 1: {
                    ServiceInstance serviceInstance;
                    ARecord aRecord = (ARecord)record;
                    for (Iterator<Object> iterator : hashMap.values()) {
                        serviceInstance = (ServiceInstance)((Object)iterator);
                        if (!aRecord.getName().equals(serviceInstance.getHost())) continue;
                        if (aRecord.getTTL() > 0L) {
                            serviceInstance.addAddress(aRecord.getAddress());
                            continue;
                        }
                        serviceInstance.removeAddress(aRecord.getAddress());
                    }
                    continue block9;
                }
                case 28: {
                    Iterator<Object> iterator;
                    ServiceInstance serviceInstance;
                    AAAARecord aAAARecord = (AAAARecord)record;
                    iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        Object v2 = iterator.next();
                        serviceInstance = (ServiceInstance)v2;
                        if (!aAAARecord.getName().equals(serviceInstance.getHost())) continue;
                        if (aAAARecord.getTTL() > 0L) {
                            serviceInstance.addAddress(aAAARecord.getAddress());
                            continue;
                        }
                        serviceInstance.removeAddress(aAAARecord.getAddress());
                    }
                    continue block9;
                }
            }
        }
        return hashMap.values().toArray(new ServiceInstance[hashMap.size()]);
    }

    public void closed() {
        try {
            this.querier.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

