/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import com.hpplay.sdk.source.mdns.xbill.dns.Cache;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ElementHelper {
    private WeakReference<Cache> cache = null;
    private WeakReference<Object> element = null;
    private Class clazz = null;
    private Method expired = null;
    private Method compareCredibility = null;
    private Method getType = null;
    private Method getTTL = null;
    private Field expireField = null;
    private Field credibilityField = null;

    public ElementHelper(Cache cache, Object object) {
        this.cache = new WeakReference<Cache>(cache);
        this.element = new WeakReference<Object>(object);
        this.clazz = object.getClass();
        this.expireField = ElementHelper.findField(this.clazz, "expire");
        this.credibilityField = ElementHelper.findField(this.clazz, "credibility");
        this.expired = ElementHelper.findMethod(this.clazz, "expired", new Class[0]);
        this.compareCredibility = ElementHelper.findMethod(this.clazz, "compareCredibility", new Class[]{Integer.TYPE});
        this.getType = ElementHelper.findMethod(this.clazz, "getType", new Class[0]);
        this.getTTL = ElementHelper.findMethod(this.clazz, "getTTL", new Class[0]);
        AccessibleObject.setAccessible(new AccessibleObject[]{this.expireField, this.credibilityField}, true);
        AccessibleObject.setAccessible(new AccessibleObject[]{this.expired, this.compareCredibility, this.getType, this.getTTL, this.expireField, this.credibilityField}, true);
    }

    public int getCredibility() {
        return this.credibilityField.getInt(this.element);
    }

    public int getExpiresIn() {
        return this.getExpire() - (int)(System.currentTimeMillis() / 1000L);
    }

    public long getTTL() {
        if (this.getTTL != null) {
            Long l2 = (Long)this.getTTL.invoke(this.element, new Object[0]);
            return l2 == null ? 0L : l2;
        }
        return 0L;
    }

    public void resetExpire() {
        if (this.cache.get() != null) {
            this.expireField.setInt(this.element, ElementHelper.limitExpire(this.getTTL(), ((Cache)this.cache.get()).getMaxCache()));
        }
    }

    protected int compareCredibility(int n2) {
        return (Integer)this.compareCredibility.invoke(this.element, n2);
    }

    protected boolean expired() {
        return (Boolean)this.expired.invoke(this.element, new Object[0]);
    }

    protected Object getElement() {
        return this.element;
    }

    protected int getExpire() {
        return this.expireField.getInt(this.element);
    }

    protected int getType() {
        return (Integer)this.getType.invoke(this.element, new Object[0]);
    }

    public static Field findField(Class clazz, String string) {
        Field field = null;
        for (Class clazz2 = clazz; clazz2 != null && field == null; clazz2 = clazz2.getSuperclass()) {
            try {
                field = clazz2.getDeclaredField(string);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field == null) continue;
            return field;
        }
        throw new NoSuchFieldException("Field \"" + string + "\" does not exist in class \"" + clazz.getName() + "\".");
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        for (Class clazz2 = clazz; clazz2 != null && method == null; clazz2 = clazz2.getSuperclass()) {
            try {
                method = clazz2.getDeclaredMethod(string, classArray);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) continue;
            return method;
        }
        throw new NoSuchMethodException("Method \"" + string + "\" does not exist in class \"" + clazz.getName() + "\".");
    }

    public static int limitExpire(long l2, long l3) {
        long l4;
        if (l3 >= 0L && l3 < l2) {
            l2 = l3;
        }
        if ((l4 = System.currentTimeMillis() / 1000L + l2) < 0L || l4 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l4;
    }
}

