/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.MulticastDNSMulticastOnlyQuerier;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Opcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Rcode;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.lang.ref.WeakReference;

public class Cacher
implements ResolverListener {
    private static final String TAG = "Cacher";
    WeakReference<MulticastDNSMulticastOnlyQuerier> weakReference;

    public Cacher(MulticastDNSMulticastOnlyQuerier multicastDNSMulticastOnlyQuerier) {
        this.weakReference = new WeakReference<MulticastDNSMulticastOnlyQuerier>(multicastDNSMulticastOnlyQuerier);
    }

    @Override
    public void handleException(Object object, Exception exception) {
    }

    @Override
    public void receiveMessage(Object object, Message message) {
        if (this.weakReference.get() == null) {
            return;
        }
        Header header = message.getHeader();
        int n2 = message.getRcode();
        int n3 = header.getOpcode();
        if (((MulticastDNSMulticastOnlyQuerier)this.weakReference.get()).ignoreTruncation && header.getFlag(6)) {
            Log.i((String)TAG, (String)("receiveMessage Truncated Message Ignored : RCode: " + Rcode.string(n2) + "; Opcode: " + Opcode.string(n3)));
            return;
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                if (header.getFlag(0) || header.getFlag(5)) {
                    ((MulticastDNSMulticastOnlyQuerier)this.weakReference.get()).updateCache(MulticastDNSUtils.extractRecords(message, 1, 2, 3), 3);
                    break;
                }
                return;
            }
            case 5: {
                Log.i((String)TAG, (String)"receiveMessage Updates from the nw are not allowed!");
                return;
            }
        }
        if (((MulticastDNSMulticastOnlyQuerier)this.weakReference.get()).mdnsVerbose) {
            Log.i((String)TAG, (String)("receiveMessage RCode: " + Rcode.string(n2)));
            Log.i((String)TAG, (String)("receiveMessage Opcode: " + Opcode.string(n3)));
        }
    }
}

