/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business.cloud;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.datareport.DataReport;
import com.hpplay.common.datareport.ReportBean;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.component.common.utils.DeviceProperties;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.da.e;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.LeboUtil;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class SourceDataReport {
    private static final String TAG = "SourceDataReport";
    public static final String CLIENT_ID = "2004";
    public static final String KEY_ERREPORT_DESC = "desc";
    public static final String KEY_ERREPORT_LOCATION = "location";
    public static final String KEY_ERREPORT_EVENTID = "event_id";
    public static final String KEY_ERREPORT_ERMSG = "er_msg";
    public static final String KEY_ERREPORT_ERCODE = "er_code";
    private static SourceDataReport sInstance;
    private Context mContext;
    private Session mSession;
    private Map<String, String> mConnectHeader = new HashMap<String, String>();
    public String authSessionId = "";

    public static void initDataReport(Context context) {
        SourceLog.i(TAG, "initDataReport");
        DataReport.initDataReport(context.getApplicationContext(), "ygp73gbu");
        SourceDataReport.initLocalInstance(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initLocalInstance(Context context) {
        Class<SourceDataReport> clazz = SourceDataReport.class;
        synchronized (SourceDataReport.class) {
            if (sInstance == null) {
                sInstance = new SourceDataReport(context);
                SourceDataReport.sInstance.authSessionId = String.valueOf(System.currentTimeMillis());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private SourceDataReport(Context context) {
        this.mContext = context;
        this.mSession = Session.getInstance();
        this.mConnectHeader.put("Connection", "close");
    }

    public static SourceDataReport getInstance() {
        if (sInstance == null) {
            SourceDataReport.initDataReport((Context)HapplayUtils.getApplication());
        }
        return sInstance;
    }

    public void login(String string) {
        String string2 = "&st=5&sn=1";
        String string3 = "&imdc=" + LeboUtil.anonymizeByMD5("") + "&imds=" + LeboUtil.anonymizeBySHA256("") + "&j=" + DeviceProperties.getModel() + "&cut=1&pk=" + this.mContext.getPackageName() + "&fn=" + DeviceProperties.getManufacturer();
        String string4 = "&csv=4.12.01&l=" + Locale.getDefault().getLanguage() + "&sv=" + Build.VERSION.RELEASE + "&n=" + NetworkUtil.getNetType(this.mContext);
        try {
            if ("com.hpplay.sdk.source.test".equalsIgnoreCase(this.mContext.getPackageName())) {
                string4 = string4 + "&cav=" + string;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        String string5 = this.getPreParameter() + string2 + string3 + string4;
        ReportBean reportBean = new ReportBean();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportLogIn, string5);
        this.addTask(reportBean);
    }

    public void logout() {
        AsyncHttpParameter asyncHttpParameter;
        String string = "&st=5&sn=3";
        ReportBean reportBean = new ReportBean();
        reportBean.httpParameter = asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sReportLogOut, this.getPreParameter() + string);
        this.addTask(reportBean);
    }

    public void onYimInit(int n2, OutParameter outParameter, boolean bl, String string, String string2) {
        String string3 = outParameter.connectSession;
        String string4 = null;
        String string5 = null;
        LelinkServiceInfo lelinkServiceInfo = outParameter.serviceInfo;
        if (lelinkServiceInfo != null) {
            string4 = lelinkServiceInfo.getIp();
            string5 = lelinkServiceInfo.getUid();
        }
        SourceLog.i(TAG, "onYoumeConnect sessionId = " + string3 + "  serviceNumber =" + n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(7).append("&").append("sn=").append(n2).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(string3).append("&").append("p=").append(7).append("&").append("sta=").append(bl ? 1 : 0);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append("&").append("rli=").append(string4);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            stringBuilder.append("&").append("ru=").append(string5);
        }
        stringBuilder.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        if (!bl) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                stringBuilder.append("&").append("et=").append(string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                stringBuilder.append("&").append("ec=").append(string2);
            }
        }
        String string6 = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "params = " + string6);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sReportConn, string6);
        ReportBean reportBean = new ReportBean();
        reportBean.httpParameter = asyncHttpParameter;
        this.addTask(reportBean);
    }

    public void onQRScanStart(String string) {
        this.onConnect(10, 1001, string, 0, null, 0L, 0, null);
    }

    public void onQRScanEnd(LelinkServiceInfo lelinkServiceInfo, String string, int n2, long l2) {
        this.onConnect(10, 1002, string, 0, lelinkServiceInfo, l2, n2, null);
    }

    public void onPinCodeStart(String string) {
        this.onConnect(11, 1001, string, 0, null, 0L, 0, null);
    }

    public void onPinCodeEnd(LelinkServiceInfo lelinkServiceInfo, String string, int n2, long l2) {
        this.onConnect(11, 1002, string, 0, lelinkServiceInfo, l2, n2, null);
    }

    public void onAuthFailed(String string) {
        this.onConnect(5, 500, "", 0, null, 0L, 0, string);
    }

    public void onLocalConnect(String string, int n2, LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "onLocalConnect " + string + " / " + n2);
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, n2);
        if (browserInfo == null) {
            this.onConnectSuccess(3, 1, string, n2, lelinkServiceInfo);
            return;
        }
        int n3 = browserInfo.getCreateType();
        switch (n3) {
            case 2: {
                this.onConnectSuccess(10, 1, string, n2, lelinkServiceInfo);
                break;
            }
            case 5: {
                this.onConnectSuccess(11, 1, string, n2, lelinkServiceInfo);
                break;
            }
            default: {
                this.onConnectSuccess(3, 1, string, n2, lelinkServiceInfo);
            }
        }
    }

    public void onLocalConnectSuccess(String string, int n2, LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "onLocalConnectSuccess " + string + " / " + n2);
        this.onConnectSuccess(3, 6, string, n2, lelinkServiceInfo);
    }

    public void onLocalConnectFailed(String string, int n2, LelinkServiceInfo lelinkServiceInfo, String string2) {
        SourceLog.i(TAG, "onLocalConnectFailed " + string + " / " + n2 + " / " + string2);
        this.onConnect(3, 6, string, n2, lelinkServiceInfo, 0L, 0, string2);
    }

    public void onLocalDisconnect(String string, int n2, LelinkServiceInfo lelinkServiceInfo, int n3) {
        SourceLog.i(TAG, "onLocalDisconnect " + string + " / " + n2);
        this.onConnect(3, 10, string, n2, lelinkServiceInfo, 0L, 1, "", n3, 0);
    }

    public void onCloudConnect(String string, int n2, LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "onCloudConnect " + string + " / " + n2);
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, n2);
        if (browserInfo == null) {
            this.onConnectSuccess(4, 401, string, n2, lelinkServiceInfo);
            return;
        }
        int n3 = browserInfo.getCreateType();
        switch (n3) {
            case 2: {
                this.onConnectSuccess(10, 401, string, n2, lelinkServiceInfo);
                break;
            }
            case 5: {
                this.onConnectSuccess(11, 401, string, n2, lelinkServiceInfo);
                break;
            }
            default: {
                this.onConnectSuccess(4, 401, string, n2, lelinkServiceInfo);
            }
        }
    }

    public void onCloudConnectSuccess(String string, int n2, LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "onCloudConnectSuccess " + string + " / " + n2);
        this.onConnectSuccess(4, 408, string, n2, lelinkServiceInfo);
    }

    public void onCloudConnectFailed(String string, int n2, LelinkServiceInfo lelinkServiceInfo, String string2) {
        SourceLog.i(TAG, "onCloudConnectFailed " + string + " / " + n2 + " / " + string2);
        this.onConnect(4, 408, string, n2, lelinkServiceInfo, 0L, 0, string2);
    }

    public void onCloudDisconnect(String string, int n2, LelinkServiceInfo lelinkServiceInfo, int n3) {
        SourceLog.i(TAG, "onCloudDisconnect " + string + " / " + n2);
        this.onConnect(4, 410, string, n2, lelinkServiceInfo, 0L, 1, "", n3, 0);
    }

    public void onYimConnect(String string, int n2, LelinkServiceInfo lelinkServiceInfo) {
        this.onConnectSuccess(7, 701, string, n2, lelinkServiceInfo);
    }

    public void onGetRoomSuccess(OutParameter outParameter, String string) {
        this.onGetRoom(outParameter, true, string, null, null);
    }

    public void onGetRoomFailed(OutParameter outParameter, String string) {
        this.onGetRoom(outParameter, false, null, null, string);
    }

    private void onGetRoom(OutParameter outParameter, boolean bl, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(7).append("&").append("sn=").append(702).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("uri=").append(outParameter.urlID).append("&").append("p=").append(7).append("&").append("lnb=").append(string).append("&").append("sta=").append(bl ? 1 : 0);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append("&").append("et=").append(string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append("&").append("ec=").append(string3);
        }
        stringBuilder.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        ReportBean reportBean = new ReportBean();
        String string4 = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "params = " + string4);
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportConn, string4);
        this.addTask(reportBean);
    }

    private void onConnectSuccess(int n2, int n3, String string, int n4, LelinkServiceInfo lelinkServiceInfo) {
        this.onConnect(n2, n3, string, n4, lelinkServiceInfo, 0L, 1, "");
    }

    private void onConnect(int n2, int n3, String string, int n4, LelinkServiceInfo lelinkServiceInfo, long l2, int n5, String string2) {
        this.onConnect(n2, n3, string, n4, lelinkServiceInfo, l2, n5, string2, 0, 0);
    }

    private void onConnect(int n2, int n3, String string, int n4, LelinkServiceInfo lelinkServiceInfo, long l2, int n5, String string2, int n6, int n7) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("st=").append(n2).append("&").append("sn=").append(n3).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("lt=").append(l2).append("&").append("cs=").append(string).append("&").append("p=").append(n4).append("&").append("sta=").append(n5);
        if (lelinkServiceInfo != null && !TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getIp())) {
            stringBuffer.append("&").append("rli=").append(lelinkServiceInfo.getIp());
        }
        if (lelinkServiceInfo != null && !TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getUid())) {
            stringBuffer.append("&").append("ru=").append(lelinkServiceInfo.getUid());
        }
        stringBuffer.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        if (n5 != 1 && !TextUtils.isEmpty((CharSequence)string2)) {
            stringBuffer.append("&").append("et=").append(string2);
        }
        if (n3 == 10 || n3 == 410) {
            stringBuffer.append("&").append("etp=").append(n6);
            stringBuffer.append("&").append("etc=").append(n7);
        }
        String string3 = this.getPreParameter() + stringBuffer.toString();
        SourceLog.debug(TAG, "onConnect params :" + string3);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sReportConn, string3);
        ReportBean reportBean = new ReportBean();
        reportBean.httpParameter = asyncHttpParameter;
        this.addTask(reportBean);
    }

    public void onReceiveCloudMirrorConnectRequest(String string, String string2, String string3, String string4) {
        Object object;
        SourceLog.i(TAG, "onReceiveCloudMirrorConnectRequest : " + string + "  uri :" + string3 + "  roomId :" + string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(2).append("&").append("sn=").append(3).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(string).append("&").append("s=").append(string2).append("&").append("uri=").append(string3).append("&").append("p=").append(7).append("&").append("mt=").append(102).append("&").append("dt=").append(100).append("&").append("lnb=").append(string4).append("&").append("lbid=").append(Preference.getInstance().get("key_uuid")).append("&").append("mci=").append(string3).append("&").append("sta=").append(1);
        if (NetworkUtil.isWiFiOpen(this.mContext)) {
            object = NetworkUtil.getWifiBSSIDNoneColon(this.mContext);
            stringBuilder.append("&").append("bssdc=").append(LeboUtil.anonymizeByMD5((String)object));
            stringBuilder.append("&").append("bssds=").append(LeboUtil.anonymizeBySHA256((String)object));
        }
        stringBuilder.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        object = new ReportBean();
        String string5 = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "params = " + string5);
        ((ReportBean)object).httpParameter = new AsyncHttpParameter(CloudAPI.sReportMirror, string5);
        this.addTask((ReportBean)object);
    }

    public void relation(long l2, long l3, String string, String string2, String string3, String string4) {
        this.relation(l2, l3, string, string2, string3, string4, null);
    }

    public void relation(long l2, long l3, String string, String string2, String string3, String string4, String string5) {
        String string6;
        if (Feature.isNubiaChannel()) {
            return;
        }
        SourceLog.i(TAG, "relation");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("hid", Session.getInstance().getHID());
        hashMap.put("cu", String.valueOf(LeboUtil.getCUid(this.mContext)));
        hashMap.put("suc", Session.getInstance().getUID());
        if (!TextUtils.isEmpty((CharSequence)string)) {
            hashMap.put("dlst", string);
        }
        try {
            string6 = "";
            hashMap.put("imdc", LeboUtil.anonymizeByMD5(string6));
            hashMap.put("imds", LeboUtil.anonymizeBySHA256(string6));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        string6 = DeviceUtil.getIPAddress(this.mContext);
        hashMap.put("lip", string6);
        hashMap.put("cut", "1");
        hashMap.put("sc", Session.getInstance().appKey);
        if (!TextUtils.isEmpty((CharSequence)Session.getInstance().mTUID)) {
            hashMap.put("tuid", Session.getInstance().mTUID);
        }
        hashMap.put("n", String.valueOf(SourceDataReport.getNetType(this.mContext)));
        int n2 = NetworkUtil.getNetType(this.mContext);
        if (n2 == 1 || n2 == 2) {
            hashMap.put("bssdc", LeboUtil.anonymizeByMD5(NetworkUtil.getWifiBSSIDNoneColon(this.mContext)));
            hashMap.put("bssds", LeboUtil.anonymizeBySHA256(NetworkUtil.getWifiBSSIDNoneColon(this.mContext)));
            SourceLog.i(TAG, "-----> " + NetworkUtil.getWifiBSSIDNoneColon(this.mContext) + "  ff " + NetworkUtil.getWifiSSID(this.mContext));
            hashMap.put("bsswidc", LeboUtil.anonymizeByMD5(NetworkUtil.getWifiSSID(this.mContext)));
            hashMap.put("bsswids", LeboUtil.anonymizeBySHA256(NetworkUtil.getWifiSSID(this.mContext)));
        }
        hashMap.put("v", "2.1");
        hashMap.put("ltp", l2 + "");
        hashMap.put("lte", l3 + "");
        String string7 = DeviceUtil.getOAID(this.mContext);
        hashMap.put("oidc", LeboUtil.anonymizeByMD5(string7));
        hashMap.put("oids", LeboUtil.anonymizeBySHA256(string7));
        hashMap.put("sv", Build.VERSION.SDK_INT + "");
        hashMap.put("aidc", LeboUtil.anonymizeByMD5(LeboUtil.getAID(this.mContext)));
        hashMap.put("aids", LeboUtil.anonymizeBySHA256(LeboUtil.getAID(this.mContext)));
        hashMap.put("rb", string2);
        hashMap.put("wb", string3);
        hashMap.put("rav", HapplayUtils.getAppVersion(this.mContext) + "");
        hashMap.put("rpl", string4);
        hashMap.put("sdid", EncryptUtil.encryptMD5ToString(System.currentTimeMillis() + "" + new Random().nextInt(10000000) + "" + string6));
        hashMap.put("rsv", "4.12.01");
        hashMap.put("lrst", string5);
        String string8 = HapplayUtils.getMapParams(hashMap);
        ReportBean reportBean = new ReportBean();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportRelation, string8);
        reportBean.httpParameter.in.requestMethod = 1;
        this.addTask(reportBean);
    }

    public void onReceiverLive(String string, String string2) {
        SourceLog.i(TAG, "onReceiverLive");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("cs=").append(string).append("&").append("a=").append(CLIENT_ID).append("&").append("cu=").append(LeboUtil.getCUid(this.mContext)).append("&").append("sc=").append(Session.getInstance().appKey).append("&").append("hid=").append(Session.getInstance().getHID()).append("&").append("suc=").append(Session.getInstance().getUID()).append("&").append("rsv=").append("4.12.01").append("&").append("dll=").append(string2);
        ReportBean reportBean = new ReportBean();
        String string3 = this.getPreParameter() + stringBuffer.toString();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportConnLive, string3);
        this.addTask(reportBean);
    }

    public void onCastStart(OutParameter outParameter, int n2) {
        switch (outParameter.castType) {
            case 1: {
                this.onPushStart(outParameter, n2);
                break;
            }
            case 2: {
                this.onMirrorStart(outParameter, n2);
            }
        }
    }

    public void onCastSuccess(OutParameter outParameter, boolean bl, String string) {
        switch (outParameter.castType) {
            case 1: {
                this.onPushSuccess(outParameter, bl, string);
                break;
            }
            case 2: {
                this.onMirrorSuccess(outParameter);
            }
        }
    }

    public void onCastFailed(OutParameter outParameter, String string, String string2, boolean bl, String string3) {
        switch (outParameter.castType) {
            case 1: {
                this.onPushFailed(outParameter, string, string2, bl, string3);
                break;
            }
            case 2: {
                this.onMirrorFailed(outParameter, string, string2);
            }
        }
    }

    public void onCastRender(OutParameter outParameter) {
        switch (outParameter.castType) {
            case 1: {
                this.onPushRender(outParameter);
                break;
            }
            case 2: {
                this.onMirrorRender(outParameter);
            }
        }
    }

    public void onCastStop(OutParameter outParameter, int n2) {
        switch (outParameter.castType) {
            case 1: {
                this.onPushStop(outParameter, n2);
                break;
            }
            case 2: {
                this.onMirrorStop(outParameter, n2);
            }
        }
    }

    public void onPushButtonClick(String string, String string2) {
        if (Feature.isNubiaChannel()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("st=").append(608);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("&").append("st=").append(608).append("&").append("sn=").append(1).append("&").append("s=").append(string).append("&").append("akv=").append(string2);
        ReportBean reportBean = new ReportBean();
        String string3 = this.getPreParameter() + stringBuffer.toString();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportUserBehavior, string3);
        this.addTask(reportBean);
        SourceLog.i(TAG, CloudAPI.sReportUserBehavior + string3);
    }

    private void onPushStart(OutParameter outParameter, int n2) {
        SourceLog.i(TAG, "onPushStart");
        this.onPush(1, outParameter, 0, n2);
    }

    private void onPushStop(OutParameter outParameter, int n2) {
        SourceLog.i(TAG, "onPushStop " + n2);
        this.onPush(110, outParameter, n2, -1);
    }

    private void onPushSuccess(OutParameter outParameter, boolean bl, String string) {
        SourceLog.i(TAG, "onPushSuccess");
        this.onPushSend(outParameter, true, "", "", bl, string);
    }

    private void onPushFailed(OutParameter outParameter, String string, String string2, boolean bl, String string3) {
        SourceLog.i(TAG, "onPushFailed");
        this.onPushSend(outParameter, false, string, string2, bl, string3);
    }

    private void onPushRender(OutParameter outParameter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(1).append("&").append("sn=").append(108).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("p=").append(this.getProtocol(outParameter)).append("&").append("sta=").append(1).append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext)).append("&").append("ez=").append(outParameter.pushType);
        if (outParameter.urls != null) {
            stringBuilder.append("&").append("ipl=").append(1);
            stringBuilder.append("&").append("plid=").append(outParameter.dramaID);
        }
        if (outParameter.pushType == 2) {
            stringBuilder.append("&").append("iez=").append(e.d().a(outParameter.session));
        }
        ReportBean reportBean = new ReportBean();
        String string = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "onPushRender params " + outParameter.urlID);
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportPush, string);
        reportBean.httpParameter.in.requestMethod = 1;
        this.addTask(reportBean);
    }

    private void onPushSend(OutParameter outParameter, boolean bl, String string, String string2, boolean bl2, String string3) {
        Object object;
        StringBuilder stringBuilder;
        String string4 = outParameter.session;
        String string5 = outParameter.connectSession;
        String string6 = outParameter.urlID;
        String string7 = string2;
        String string8 = string;
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                stringBuilder = new JSONObject(string3);
                string4 = stringBuilder.optString("sessionId");
                string5 = stringBuilder.optString("connectSessionId");
                string6 = stringBuilder.optString("uri");
                if (!bl) {
                    string8 = string7 = stringBuilder.optString("errCode");
                    String string9 = stringBuilder.optString("errMsg");
                    String string10 = stringBuilder.optString("location_uri");
                    String string11 = stringBuilder.optString(KEY_ERREPORT_DESC);
                    object = new HashMap<String, String>();
                    object.put(KEY_ERREPORT_DESC, string11);
                    object.put(KEY_ERREPORT_LOCATION, string10);
                    object.put(KEY_ERREPORT_EVENTID, string6);
                    object.put(KEY_ERREPORT_ERMSG, string9);
                    object.put(KEY_ERREPORT_ERCODE, string7 + "");
                    this.uploadPushErrorDetails((Map<String, String>)object);
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(1).append("&").append("sn=").append(2).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(string5).append("&").append("s=").append(string4).append("&").append("uri=").append(string6).append("&").append("p=").append(this.getProtocol(outParameter)).append("&").append("sta=").append(bl ? 1 : 2).append("&").append("et=").append(string8).append("&").append("ec=").append(string7).append("&").append("ryf=").append(bl2 ? 1 : 0).append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext)).append("&").append("ez=").append(outParameter.pushType);
        if (outParameter.urls != null) {
            stringBuilder.append("&").append("ipl=").append(1);
            stringBuilder.append("&").append("plid=").append(outParameter.dramaID);
        }
        if (outParameter.pushType == 2) {
            stringBuilder.append("&").append("iez=").append(e.d().a(outParameter.session));
        }
        object = new ReportBean();
        String string12 = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "onPushSend " + outParameter.urlID);
        ((ReportBean)object).httpParameter = new AsyncHttpParameter(CloudAPI.sReportPush, string12);
        ((ReportBean)object).httpParameter.in.requestMethod = 1;
        this.addTask((ReportBean)object);
    }

    public void uploadPushErrorDetails(Map<String, String> map) {
        SourceDataReport.getInstance().crashDataUpload(map);
    }

    private void onPush(int n2, OutParameter outParameter, int n3, int n4) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(1).append("&").append("sn=").append(n2).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("p=").append(this.getProtocol(outParameter)).append("&").append("clip=").append(DeviceUtil.getIPAddress(this.mContext)).append("&").append("sta=").append(1).append("&").append("ez=").append(outParameter.pushType);
        if (n2 == 1) {
            try {
                if (!TextUtils.isEmpty((CharSequence)outParameter.getPlayUrl())) {
                    stringBuilder.append("&").append("i=").append(URLEncoder.encode(outParameter.getPlayUrl(), "utf-8"));
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            stringBuilder.append("&").append("cdi=").append(n4);
        } else if (n2 == 110) {
            stringBuilder.append("&").append("etp=").append(n3).append("&").append("etc=").append(0);
        }
        if (outParameter.urls != null && (n2 == 1 || n2 == 110)) {
            stringBuilder.append("&").append("ipl=").append(1);
            stringBuilder.append("&").append("plid=").append(outParameter.dramaID);
        }
        if (outParameter.protocol == 1) {
            try {
                object2 = "";
                stringBuilder.append("&").append("cm=").append(LeboUtil.anonymizeByMD5((String)object2));
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (outParameter.protocol == 3 && (object2 = CastUtil.getBrowserInfo(outParameter.serviceInfo, 3)) != null && (object = ((BrowserInfo)object2).getExtras()) != null && object.size() > 0) {
            String string;
            String string2;
            String string3 = object.get("dlna_mode_desc");
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                stringBuilder.append("&").append("mdd=").append(string3);
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = object.get("dlna_mode_name")))) {
                stringBuilder.append("&").append("mdn=").append(string2);
            }
            if (!TextUtils.isEmpty((CharSequence)(string = object.get("manufacturer")))) {
                stringBuilder.append("&").append("rem=").append(string);
            }
        }
        if (outParameter.pushType == 2) {
            stringBuilder.append("&").append("iez=").append(e.d().a(outParameter.session));
        }
        stringBuilder.append("&").append("reu=").append(outParameter.serviceInfo.getUid());
        stringBuilder.append("&").append("mt=").append(outParameter.mimeType).append("&").append("dt=").append(100);
        if (NetworkUtil.isWiFiOpen(this.mContext)) {
            object2 = NetworkUtil.getWifiBSSIDNoneColon(this.mContext);
            stringBuilder.append("&").append("bssdc=").append(LeboUtil.anonymizeByMD5((String)object2));
            stringBuilder.append("&").append("bssds=").append(LeboUtil.anonymizeByMD5((String)object2));
        }
        stringBuilder.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        object2 = new ReportBean();
        object = this.getPreParameter() + stringBuilder.toString();
        SourceLog.debug(TAG, "onPush params :" + (String)object);
        ((ReportBean)object2).httpParameter = new AsyncHttpParameter(CloudAPI.sReportPush, (String)object);
        ((ReportBean)object2).httpParameter.in.requestMethod = 1;
        this.addTask((ReportBean)object2);
    }

    public int getProtocol(OutParameter outParameter) {
        if (outParameter == null) {
            return 0;
        }
        if (outParameter.protocol == 1 && CastUtil.isSupportLelinkV2(outParameter.serviceInfo)) {
            return 5;
        }
        return outParameter.protocol;
    }

    private void onMirrorStart(OutParameter outParameter, int n2) {
        SourceLog.i(TAG, "onMirrorStart");
        this.onMirror(1, outParameter, 0, n2);
    }

    private void onMirrorStop(OutParameter outParameter, int n2) {
        SourceLog.i(TAG, "onMirrorStop " + n2);
        this.onMirror(110, outParameter, n2, -1);
    }

    private void onMirrorSuccess(OutParameter outParameter) {
        SourceLog.i(TAG, "onMirrorSuccess");
        this.onMirrorSend(outParameter, true, "", "");
    }

    private void onMirrorFailed(OutParameter outParameter, String string, String string2) {
        SourceLog.i(TAG, "onMirrorFailed");
        this.onMirrorSend(outParameter, false, string, string2);
    }

    private void onMirrorRender(OutParameter outParameter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(2).append("&").append("sn=").append(108).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("sta=").append(1).append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        if (outParameter.protocol == 4) {
            stringBuilder.append("&").append("p=").append(7).append("&").append("lnb=").append(outParameter.roomID).append("&").append("lbid=").append(Preference.getInstance().get("key_uuid")).append("&").append("mci=").append(outParameter.urlID);
        } else {
            stringBuilder.append("&").append("p=").append(this.getProtocol(outParameter));
        }
        ReportBean reportBean = new ReportBean();
        String string = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "onMirrorSend params :" + string);
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportMirror, string);
        this.addTask(reportBean);
    }

    private void onMirrorSend(OutParameter outParameter, boolean bl, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(2).append("&").append("sn=").append(2).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("sta=").append(bl ? 1 : 2).append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        if (outParameter.protocol == 4) {
            stringBuilder.append("&").append("p=").append(7).append("&").append("lnb=").append(outParameter.roomID).append("&").append("lbid=").append(Preference.getInstance().get("key_uuid")).append("&").append("mci=").append(outParameter.urlID);
        } else {
            stringBuilder.append("&").append("p=").append(this.getProtocol(outParameter));
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("&").append("et=").append(string);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append("&").append("ec=").append(string2);
        }
        ReportBean reportBean = new ReportBean();
        String string3 = this.getPreParameter() + stringBuilder.toString();
        SourceLog.debug(TAG, "onMirrorSend params :" + string3);
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportMirror, string3);
        this.addTask(reportBean);
    }

    private void onMirror(int n2, OutParameter outParameter, int n3, int n4) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(2).append("&").append("sn=").append(n2).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("sta=").append(1).append("&").append("mt=").append(outParameter.mimeType).append("&").append("dt=").append(100).append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        try {
            object = "";
            stringBuilder.append("&").append("cm=").append(LeboUtil.anonymizeByMD5((String)object));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (n2 == 1) {
            stringBuilder.append("&").append("cdi=").append(n4);
        } else if (n2 == 110) {
            stringBuilder.append("&").append("ept=").append(n3).append("&").append("epc=").append(0);
        }
        if (outParameter.protocol == 4) {
            stringBuilder.append("&").append("p=").append(7).append("&").append("lnb=").append(outParameter.roomID).append("&").append("lbid=").append(Preference.getInstance().get("key_uuid")).append("&").append("mci=").append(outParameter.urlID);
        } else {
            stringBuilder.append("&").append("p=").append(this.getProtocol(outParameter));
        }
        if (NetworkUtil.isWiFiOpen(this.mContext)) {
            object = NetworkUtil.getWifiBSSIDNoneColon(this.mContext);
            stringBuilder.append("&").append("bssdc=").append(LeboUtil.anonymizeByMD5((String)object));
            stringBuilder.append("&").append("bssds=").append(LeboUtil.anonymizeByMD5((String)object));
        }
        object = new ReportBean();
        String string = this.getPreParameter() + stringBuilder.toString();
        SourceLog.debug(TAG, "onMirror params :" + string);
        ((ReportBean)object).httpParameter = new AsyncHttpParameter(CloudAPI.sReportMirror, string);
        this.addTask((ReportBean)object);
    }

    public void onStartPullYoumeStream(OutParameter outParameter) {
        Object object;
        SourceLog.i(TAG, "onStartPullYoumeStream");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(2).append("&").append("sn=").append(100).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("p=").append(7).append("&").append("mt=").append(102).append("&").append("dt=").append(100).append("&").append("lnb=").append(outParameter.roomID).append("&").append("lbid=").append(Preference.getInstance().get("key_uuid")).append("&").append("mci=").append(outParameter.urlID).append("&").append("sta=").append(1);
        if (NetworkUtil.isWiFiOpen(this.mContext)) {
            object = NetworkUtil.getWifiBSSIDNoneColon(this.mContext);
            stringBuilder.append("&").append("bssdc=").append(LeboUtil.anonymizeByMD5((String)object));
            stringBuilder.append("&").append("bssds=").append(LeboUtil.anonymizeByMD5((String)object));
        }
        stringBuilder.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        object = new ReportBean();
        String string = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "params = " + string);
        ((ReportBean)object).httpParameter = new AsyncHttpParameter(CloudAPI.sReportMirror, string);
        this.addTask((ReportBean)object);
    }

    public void onStopPullYoumeStream(OutParameter outParameter) {
        if (outParameter == null) {
            SourceLog.i(TAG, "onStopPullYoumeStream ignore");
            return;
        }
        SourceLog.i(TAG, "onStopPullYoumeStream ");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&").append("st=").append(2).append("&").append("sn=").append(102).append("&").append("ls=").append(System.currentTimeMillis()).append("&").append("cs=").append(outParameter.connectSession).append("&").append("s=").append(outParameter.session).append("&").append("uri=").append(outParameter.urlID).append("&").append("p=").append(7).append("&").append("lnb=").append(outParameter.roomID).append("&").append("lbid=").append(Preference.getInstance().get("key_uuid")).append("&").append("mci=").append(outParameter.urlID).append("&").append("sta=").append(1);
        stringBuilder.append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext));
        ReportBean reportBean = new ReportBean();
        String string = this.getPreParameter() + stringBuilder.toString();
        SourceLog.i(TAG, "params = " + string);
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportMirror, string);
        this.addTask(reportBean);
    }

    public void onQuality(OutParameter outParameter, JSONArray jSONArray) {
        if (outParameter == null) {
            return;
        }
        this.onQuality(jSONArray, outParameter.urlID, true);
    }

    public void onMirrorChange(OutParameter outParameter, JSONArray jSONArray) {
        if (outParameter == null) {
            return;
        }
        this.onQuality(jSONArray, outParameter.urlID, false);
    }

    private void onQuality(JSONArray jSONArray, String string, boolean bl) {
        try {
            Session session = Session.getInstance();
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("st", 100);
            jSONObject.put("sn", 1);
            jSONObject.put("suc", (Object)session.getUID());
            jSONObject.put("sc", (Object)session.appKey);
            jSONObject.put("hid", (Object)session.getHID());
            jSONObject.put("rsv", (Object)CastUtil.getVersion());
            jSONObject.put("rav", HapplayUtils.getAppVersion(this.mContext));
            jSONObject.put("v", (Object)"2.1");
            jSONObject.put("uri_id", (Object)string);
            if (bl) {
                jSONObject.put("cqj", (Object)jSONArray);
            } else {
                jSONObject.put("ncs", (Object)jSONArray);
            }
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sReportConnLive, jSONArray.toString());
            asyncHttpParameter.in.requestMethod = 1;
            ReportBean reportBean = new ReportBean();
            reportBean.httpParameter = asyncHttpParameter;
            this.addTask(reportBean);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void onBlePublish(int n2, String string) {
        SourceLog.i(TAG, "onBlePublish:" + n2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("st=").append(11502).append("&").append("sn=").append(101).append("&").append("status=").append(n2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuffer.append("&").append("errorcode=").append(string);
        }
        ReportBean reportBean = new ReportBean();
        String string2 = this.getPreParameter() + stringBuffer.toString();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportUserBehavior, string2);
        this.addTask(reportBean);
    }

    public void onSonicScan(int n2, String string) {
        SourceLog.i(TAG, "onSonicScan:" + n2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("st=").append(11502).append("&").append("sn=").append(102).append("&").append("status=").append(n2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuffer.append("&").append("errorcode=").append(string);
        }
        ReportBean reportBean = new ReportBean();
        String string2 = this.getPreParameter() + stringBuffer.toString();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportUserBehavior, string2);
        this.addTask(reportBean);
    }

    public void onSinkTouchBuild(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("st=").append(11503).append("&").append("sn=").append(101).append("&").append("status=").append(n2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuffer.append("&").append("errorcode=").append(string);
        }
        ReportBean reportBean = new ReportBean();
        String string2 = this.getPreParameter() + stringBuffer.toString();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportUserBehavior, string2);
        this.addTask(reportBean);
    }

    public void onSinkTouchCloudBuild(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("&").append("st=").append(11503).append("&").append("sn=").append(102).append("&").append("status=").append(n2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuffer.append("&").append("errorcode=").append(string);
        }
        ReportBean reportBean = new ReportBean();
        String string2 = this.getPreParameter() + stringBuffer.toString();
        reportBean.httpParameter = new AsyncHttpParameter(CloudAPI.sReportUserBehavior, string2);
        this.addTask(reportBean);
    }

    public void crashDataUpload(Map<String, String> map) {
        Object object;
        String string = this.getPreParameter();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            object = string.split("&");
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                String[] stringArray;
                String string2 = object[i2];
                if (TextUtils.isEmpty((CharSequence)string2) || !string2.contains("=") || (stringArray = string2.split("=")).length != 2) continue;
                map.put(stringArray[0], stringArray[1]);
            }
        }
        object = new AsyncHttpParameter(CloudAPI.sReportError, HapplayUtils.getJsonParams(map));
        object.in.connectTimeout = 5000;
        object.in.readTimeout = 5000;
        object.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                SourceLog.debug(SourceDataReport.TAG, "crash onRequestResult = " + asyncHttpParameter.out.result);
            }
        };
        AsyncManager.getInstance().exeHttpTask((AsyncHttpParameter)object, asyncHttpRequestListener);
    }

    private static int getNetType(Context context) {
        int n2 = 0;
        NetworkUtil.NetworkType networkType = NetworkUtil.getNetworkType(context);
        switch (networkType) {
            case NETWORK_WIFI: {
                return NetworkUtil.getWifiType(context) == 0 ? 1 : 2;
            }
            case NETWORK_2G: 
            case NETWORK_3G: 
            case NETWORK_4G: {
                n2 = 5;
            }
        }
        return n2;
    }

    public String getPreParameter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tid").append("=").append(this.mSession.tid).append("&").append("cu").append("=").append(LeboUtil.getCUid(this.mContext)).append("&").append("suc").append("=").append(Session.getInstance().getUID()).append("&").append("v").append("=").append("2.1").append("&").append("a").append("=").append(CLIENT_ID).append("&").append("as").append("=").append(this.authSessionId).append("&").append("sc").append("=").append(this.mSession.appKey).append("&").append("hid").append("=").append(Session.getInstance().getHID()).append("&").append("rav=").append(HapplayUtils.getAppVersion(this.mContext)).append("&").append("rsv").append("=").append("4.12.01").append("&").append("j").append("=").append(DeviceProperties.getModel()).append("&").append("br").append("=").append(DeviceProperties.getBrand());
        String string = DeviceUtil.getOAID(this.mContext);
        String string2 = LeboUtil.getAID(this.mContext);
        stringBuilder.append("&").append("sv=").append(Build.VERSION.SDK_INT).append("&").append("oidc=").append(LeboUtil.anonymizeByMD5(string)).append("&").append("oids=").append(LeboUtil.anonymizeBySHA256(string)).append("&").append("aidc=").append(LeboUtil.anonymizeByMD5(string2)).append("&").append("aids=").append(LeboUtil.anonymizeBySHA256(string2));
        return stringBuilder.toString();
    }

    public void addTask(ReportBean reportBean) {
        if (reportBean.httpParameter.in.requestHeaders != null) {
            reportBean.httpParameter.in.requestHeaders.put("Connection", "close");
        } else {
            reportBean.httpParameter.in.requestHeaders = this.mConnectHeader;
        }
        SourceLog.debug(TAG, "source addTask -----> " + reportBean.httpParameter.in.params);
        reportBean.encryptVersion = "2.1";
        DataReport.onDataReport(reportBean, true);
    }
}

