/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business.cloud;

import com.hpplay.common.utils.Encode;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class AuthSDKBean {
    private static final String TAG = "AuthSDKBean";
    public int status;
    public DataEntity data;

    public AuthSDKBean(JSONObject jSONObject) {
        this.decode(jSONObject);
    }

    public void decode(JSONObject jSONObject) {
        this.status = jSONObject.optInt("status");
        JSONObject jSONObject2 = jSONObject.optJSONObject("data");
        if (null != jSONObject2) {
            this.data = new DataEntity();
            this.data.decode(jSONObject2);
        }
    }

    public static class DataEntity {
        public long server_time;
        public String dmr_name;
        public int tid;
        public String token;
        public String prot_ver;
        public int scan_time;
        public int expire_time;
        public String uid;
        public String hid;
        public long reg_time;
        public ServListEntity serv_list;
        public SwitchEntity switch_conf;

        public void decode(JSONObject jSONObject) {
            String string;
            JSONObject jSONObject2;
            if (jSONObject == null) {
                SourceLog.i(AuthSDKBean.TAG, "decode DataEntity is emtpy");
                return;
            }
            this.server_time = jSONObject.optLong("server_time");
            this.dmr_name = jSONObject.optString("dmr_name");
            this.tid = jSONObject.optInt("tid");
            this.token = jSONObject.optString("token");
            this.prot_ver = jSONObject.optString("prot_ver");
            this.scan_time = jSONObject.optInt("scan_time");
            this.expire_time = jSONObject.optInt("expire_time");
            this.uid = jSONObject.optString("uid");
            this.hid = jSONObject.optString("hid");
            this.reg_time = jSONObject.optLong("reg_time");
            JSONObject jSONObject3 = jSONObject.optJSONObject("serv_list");
            if (null != jSONObject3 && jSONObject3.length() > 0) {
                this.serv_list = new ServListEntity();
                this.serv_list.ver = jSONObject3.optInt("ver");
                jSONObject2 = jSONObject3.optJSONArray("url_list");
                if (null != jSONObject2 && jSONObject2.length() > 0) {
                    this.serv_list.url_list = new ArrayList<ServListEntity.UrlListEntity>();
                    int n2 = jSONObject2.length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ServListEntity.UrlListEntity urlListEntity = new ServListEntity.UrlListEntity(jSONObject2.optJSONObject(i2));
                        string = jSONObject2.optJSONObject(i2);
                        urlListEntity.decode((JSONObject)string);
                        this.serv_list.url_list.add(urlListEntity);
                    }
                }
            }
            if (null != (jSONObject2 = jSONObject.optJSONObject("switch"))) {
                this.switch_conf = new SwitchEntity();
                this.switch_conf.ver = jSONObject2.optInt("ver");
                string = jSONObject2.optString("sw_list");
                if (string != null && string.length() > 0) {
                    this.switch_conf.switchBean = new SwitchEntity.SwitchBean(string);
                }
            }
        }

        public static class SwitchEntity {
            public int ver;
            public SwitchBean switchBean;

            public static class SwitchBean {
                int sl;

                public SwitchBean(String string) {
                    this.decode(string);
                }

                private void decode(String string) {
                    try {
                        String string2 = Encode.decode(string, Session.getInstance().appSecret);
                        SourceLog.i(AuthSDKBean.TAG, "decode SwitchEntity:" + string2);
                        JSONObject jSONObject = new JSONObject(string2);
                        if (jSONObject.has("sl")) {
                            this.sl = jSONObject.optInt("sl");
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.w(AuthSDKBean.TAG, exception);
                    }
                }
            }
        }

        public static class ServListEntity {
            public int ver;
            public List<UrlListEntity> url_list;

            public static class UrlListEntity {
                public String name;
                public String url;

                public UrlListEntity(JSONObject jSONObject) {
                    this.decode(jSONObject);
                }

                public void decode(JSONObject jSONObject) {
                    if (jSONObject == null) {
                        SourceLog.i(AuthSDKBean.TAG, "decode UrlListEntity is emtpy");
                        return;
                    }
                    this.name = jSONObject.optString("name");
                    this.url = jSONObject.optString("url");
                }
            }
        }
    }
}

