/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business;

import android.os.AsyncTask;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.concurrent.ConcurrentLinkedQueue;

public class IMQueue {
    private static final String TAG = "IMQueue";
    private static IMQueue sInstance;
    private ConcurrentLinkedQueue<Bean> mTaskQueue = new ConcurrentLinkedQueue();
    private AsyncTask mAsyncTask = null;

    public static synchronized IMQueue getInstance() {
        if (sInstance == null) {
            sInstance = new IMQueue();
        }
        return sInstance;
    }

    private IMQueue() {
    }

    public Bean addTask(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener) {
        Bean bean = new Bean();
        bean.parameter = asyncHttpParameter;
        bean.listener = asyncHttpRequestListener;
        this.mTaskQueue.offer(bean);
        this.trigTask();
        return bean;
    }

    public void removeTask(Bean bean) {
        this.mTaskQueue.remove(bean);
    }

    public void clearTask() {
        this.mTaskQueue.clear();
        try {
            if (this.mAsyncTask != null) {
                this.mAsyncTask.cancel(true);
                this.mAsyncTask = null;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void trigTask() {
        if (this.mAsyncTask != null) {
            return;
        }
        final Bean bean = this.mTaskQueue.poll();
        if (bean == null) {
            return;
        }
        this.mAsyncTask = AsyncManager.getInstance().exeHttpTask(bean.parameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (bean != null && bean.listener != null) {
                    bean.listener.onRequestResult(asyncHttpParameter);
                }
                IMQueue.this.mAsyncTask = null;
                IMQueue.this.trigTask();
            }
        });
    }

    public static class Bean {
        public AsyncHttpParameter parameter;
        public AsyncHttpRequestListener listener;
    }
}

