/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.hpplay.sdk.source.log.SourceLog;
import java.net.URLEncoder;
import org.json.JSONObject;

public class MediaAssetBean
implements Parcelable {
    private static final String TAG = "MediaAssetBean";
    private String manifestVer;
    private String uri;
    private String id;
    private String mediaType;
    private String name;
    private String director;
    private String actor;
    private String album;
    private String albumArtURI;
    private long duration;
    private long size;
    private String resolution;
    private boolean isEmpty = true;
    private String metaData;
    public static final Parcelable.Creator<MediaAssetBean> CREATOR = new Parcelable.Creator<MediaAssetBean>(){

        public MediaAssetBean createFromParcel(Parcel parcel) {
            return new MediaAssetBean(parcel);
        }

        public MediaAssetBean[] newArray(int n2) {
            return new MediaAssetBean[n2];
        }
    };

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public String getManifestVer() {
        return this.manifestVer;
    }

    public void setManifestVer(String string) {
        this.manifestVer = string;
        this.isEmpty = false;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
        this.isEmpty = false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        this.isEmpty = false;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String string) {
        this.mediaType = string;
        this.isEmpty = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        try {
            this.name = URLEncoder.encode(string, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.isEmpty = false;
    }

    public String getDirector() {
        return this.director;
    }

    public void setDirector(String string) {
        try {
            this.director = URLEncoder.encode(string, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.isEmpty = false;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String string) {
        try {
            this.album = URLEncoder.encode(string, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.isEmpty = false;
    }

    public String getAlbumArtURI() {
        return this.albumArtURI;
    }

    public void setAlbumArtURI(String string) {
        this.albumArtURI = string;
        this.isEmpty = false;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String string) {
        try {
            this.actor = URLEncoder.encode(string, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.isEmpty = false;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l2) {
        this.duration = l2;
        this.isEmpty = false;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l2) {
        this.size = l2;
        this.isEmpty = false;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String string) {
        this.resolution = string;
        this.isEmpty = false;
    }

    public JSONObject encode() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", (Object)this.manifestVer);
            jSONObject.put("uri", (Object)this.uri);
            jSONObject.put("id", (Object)this.id);
            jSONObject.put("mediaType", (Object)this.mediaType);
            jSONObject.put("name", (Object)this.name);
            jSONObject.put("director", (Object)this.director);
            jSONObject.put("actor", (Object)this.actor);
            jSONObject.put("album", (Object)this.album);
            jSONObject.put("albumArtURI", (Object)this.albumArtURI);
            jSONObject.put("duration", this.duration);
            jSONObject.put("size", this.size);
            jSONObject.put("resolution", (Object)this.resolution);
            jSONObject.put("metaData", (Object)this.metaData);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String string) {
        try {
            this.metaData = URLEncoder.encode(string, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.manifestVer);
        parcel.writeString(this.uri);
        parcel.writeString(this.id);
        parcel.writeString(this.mediaType);
        parcel.writeString(this.name);
        parcel.writeString(this.director);
        parcel.writeString(this.actor);
        parcel.writeString(this.album);
        parcel.writeString(this.albumArtURI);
        parcel.writeLong(this.duration);
        parcel.writeLong(this.size);
        parcel.writeString(this.resolution);
        parcel.writeInt(this.isEmpty ? 1 : 0);
        parcel.writeString(this.metaData);
    }

    public MediaAssetBean() {
    }

    protected MediaAssetBean(Parcel parcel) {
        this.manifestVer = parcel.readString();
        this.uri = parcel.readString();
        this.id = parcel.readString();
        this.mediaType = parcel.readString();
        this.name = parcel.readString();
        this.director = parcel.readString();
        this.actor = parcel.readString();
        this.album = parcel.readString();
        this.albumArtURI = parcel.readString();
        this.duration = parcel.readLong();
        this.size = parcel.readLong();
        this.resolution = parcel.readString();
        this.isEmpty = parcel.readInt() == 1;
        this.metaData = parcel.readString();
    }
}

