/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.util;

import com.hpplay.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

public class ExceptionCatchingInputStream
extends InputStream {
    private static final Queue<ExceptionCatchingInputStream> QUEUE = Util.createQueue(0);
    private InputStream wrapped;
    private IOException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExceptionCatchingInputStream obtain(InputStream inputStream) {
        ExceptionCatchingInputStream exceptionCatchingInputStream;
        Queue<ExceptionCatchingInputStream> queue = QUEUE;
        synchronized (queue) {
            exceptionCatchingInputStream = QUEUE.poll();
        }
        if (exceptionCatchingInputStream == null) {
            exceptionCatchingInputStream = new ExceptionCatchingInputStream();
        }
        exceptionCatchingInputStream.setInputStream(inputStream);
        return exceptionCatchingInputStream;
    }

    static void clearQueue() {
        while (!QUEUE.isEmpty()) {
            QUEUE.remove();
        }
    }

    ExceptionCatchingInputStream() {
    }

    void setInputStream(InputStream inputStream) {
        this.wrapped = inputStream;
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    public void mark(int n2) {
        this.wrapped.mark(n2);
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    @Override
    public int read(byte[] byArray) {
        int n2;
        try {
            n2 = this.wrapped.read(byArray);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        try {
            n4 = this.wrapped.read(byArray, n2, n3);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            n4 = -1;
        }
        return n4;
    }

    @Override
    public synchronized void reset() {
        this.wrapped.reset();
    }

    @Override
    public long skip(long l2) {
        long l3;
        try {
            l3 = this.wrapped.skip(l2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            l3 = 0L;
        }
        return l3;
    }

    @Override
    public int read() {
        int n2;
        try {
            n2 = this.wrapped.read();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            n2 = -1;
        }
        return n2;
    }

    public IOException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.exception = null;
        this.wrapped = null;
        Queue<ExceptionCatchingInputStream> queue = QUEUE;
        synchronized (queue) {
            QUEUE.offer(this);
        }
    }
}

