/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import com.hpplay.glide.util.LruCache;
import com.hpplay.glide.util.Util;
import java.util.Queue;

public class ModelCache<A, B> {
    private static final int DEFAULT_SIZE = 250;
    private final LruCache<ModelKey<A>, B> cache;

    public ModelCache() {
        this(250);
    }

    public ModelCache(int n2) {
        this.cache = new LruCache<ModelKey<A>, B>(n2){

            @Override
            protected void onItemEvicted(ModelKey<A> modelKey, B b2) {
                modelKey.release();
            }
        };
    }

    public B get(A a2, int n2, int n3) {
        ModelKey<A> modelKey = ModelKey.get(a2, n2, n3);
        B b2 = this.cache.get(modelKey);
        modelKey.release();
        return b2;
    }

    public void put(A a2, int n2, int n3, B b2) {
        ModelKey<A> modelKey = ModelKey.get(a2, n2, n3);
        this.cache.put(modelKey, b2);
    }

    static final class ModelKey<A> {
        private static final Queue<ModelKey<?>> KEY_QUEUE = Util.createQueue(0);
        private int height;
        private int width;
        private A model;

        static <A> ModelKey<A> get(A a2, int n2, int n3) {
            ModelKey<Object> modelKey = KEY_QUEUE.poll();
            if (modelKey == null) {
                modelKey = new ModelKey<A>();
            }
            super.init(a2, n2, n3);
            return modelKey;
        }

        private ModelKey() {
        }

        private void init(A a2, int n2, int n3) {
            this.model = a2;
            this.width = n2;
            this.height = n3;
        }

        public void release() {
            KEY_QUEUE.offer(this);
        }

        public boolean equals(Object object) {
            if (object instanceof ModelKey) {
                ModelKey modelKey = (ModelKey)object;
                return this.width == modelKey.width && this.height == modelKey.height && this.model.equals(modelKey.model);
            }
            return false;
        }

        public int hashCode() {
            int n2 = this.height;
            n2 = 31 * n2 + this.width;
            n2 = 31 * n2 + this.model.hashCode();
            return n2;
        }
    }
}

