/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.model;

import android.content.Context;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.model.ModelLoaderFactory;
import java.util.HashMap;
import java.util.Map;

public class GenericLoaderFactory {
    private final Map<Class, Map<Class, ModelLoaderFactory>> modelClassToResourceFactories = new HashMap<Class, Map<Class, ModelLoaderFactory>>();
    private final Map<Class, Map<Class, ModelLoader>> cachedModelLoaders = new HashMap<Class, Map<Class, ModelLoader>>();
    private static final ModelLoader NULL_MODEL_LOADER = new ModelLoader(){

        public DataFetcher getResourceFetcher(Object object, int n2, int n3) {
            throw new NoSuchMethodError("This should never be called!");
        }

        public String toString() {
            return "NULL_MODEL_LOADER";
        }
    };
    private final Context context;

    public GenericLoaderFactory(Context context) {
        this.context = context.getApplicationContext();
    }

    public synchronized <T, Y> ModelLoaderFactory<T, Y> unregister(Class<T> clazz, Class<Y> clazz2) {
        this.cachedModelLoaders.clear();
        ModelLoaderFactory modelLoaderFactory = null;
        Map<Class, ModelLoaderFactory> map = this.modelClassToResourceFactories.get(clazz);
        if (map != null) {
            modelLoaderFactory = map.remove(clazz2);
        }
        return modelLoaderFactory;
    }

    public synchronized <T, Y> ModelLoaderFactory<T, Y> register(Class<T> clazz, Class<Y> clazz2, ModelLoaderFactory<T, Y> modelLoaderFactory) {
        ModelLoaderFactory<T, Y> modelLoaderFactory2;
        this.cachedModelLoaders.clear();
        Map<Class, ModelLoaderFactory> map = this.modelClassToResourceFactories.get(clazz);
        if (map == null) {
            map = new HashMap<Class, ModelLoaderFactory>();
            this.modelClassToResourceFactories.put(clazz, map);
        }
        if ((modelLoaderFactory2 = map.put(clazz2, modelLoaderFactory)) != null) {
            for (Map<Class, ModelLoaderFactory> map2 : this.modelClassToResourceFactories.values()) {
                if (!map2.containsValue(modelLoaderFactory2)) continue;
                modelLoaderFactory2 = null;
                break;
            }
        }
        return modelLoaderFactory2;
    }

    @Deprecated
    public synchronized <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> clazz, Class<Y> clazz2, Context context) {
        return this.buildModelLoader(clazz, clazz2);
    }

    public synchronized <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> clazz, Class<Y> clazz2) {
        ModelLoader<T, Y> modelLoader = this.getCachedLoader(clazz, clazz2);
        if (modelLoader != null) {
            if (NULL_MODEL_LOADER.equals(modelLoader)) {
                return null;
            }
            return modelLoader;
        }
        ModelLoaderFactory<T, Y> modelLoaderFactory = this.getFactory(clazz, clazz2);
        if (modelLoaderFactory != null) {
            modelLoader = modelLoaderFactory.build(this.context, this);
            this.cacheModelLoader(clazz, clazz2, modelLoader);
        } else {
            this.cacheNullLoader(clazz, clazz2);
        }
        return modelLoader;
    }

    private <T, Y> void cacheNullLoader(Class<T> clazz, Class<Y> clazz2) {
        this.cacheModelLoader(clazz, clazz2, NULL_MODEL_LOADER);
    }

    private <T, Y> void cacheModelLoader(Class<T> clazz, Class<Y> clazz2, ModelLoader<T, Y> modelLoader) {
        Map<Class, ModelLoader> map = this.cachedModelLoaders.get(clazz);
        if (map == null) {
            map = new HashMap<Class, ModelLoader>();
            this.cachedModelLoaders.put(clazz, map);
        }
        map.put(clazz2, modelLoader);
    }

    private <T, Y> ModelLoader<T, Y> getCachedLoader(Class<T> clazz, Class<Y> clazz2) {
        Map<Class, ModelLoader> map = this.cachedModelLoaders.get(clazz);
        ModelLoader modelLoader = null;
        if (map != null) {
            modelLoader = map.get(clazz2);
        }
        return modelLoader;
    }

    private <T, Y> ModelLoaderFactory<T, Y> getFactory(Class<T> clazz, Class<Y> clazz2) {
        ModelLoaderFactory modelLoaderFactory;
        block2: {
            Map<Class, ModelLoaderFactory> map = this.modelClassToResourceFactories.get(clazz);
            modelLoaderFactory = null;
            if (map != null) {
                modelLoaderFactory = map.get(clazz2);
            }
            if (modelLoaderFactory != null) break block2;
            for (Class clazz3 : this.modelClassToResourceFactories.keySet()) {
                Map<Class, ModelLoaderFactory> map2;
                if (clazz3.isAssignableFrom(clazz) && (map2 = this.modelClassToResourceFactories.get(clazz3)) != null && (modelLoaderFactory = map2.get(clazz2)) != null) break;
            }
        }
        return modelLoaderFactory;
    }
}

