/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.bitmap_recycle;

import com.hpplay.glide.load.engine.bitmap_recycle.Poolable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GroupedLinkedMap<K extends Poolable, V> {
    private final LinkedEntry<K, V> head = new LinkedEntry();
    private final Map<K, LinkedEntry<K, V>> keyToEntry = new HashMap<K, LinkedEntry<K, V>>();

    GroupedLinkedMap() {
    }

    public void put(K k2, V v2) {
        LinkedEntry<K, V> linkedEntry = this.keyToEntry.get(k2);
        if (linkedEntry == null) {
            linkedEntry = new LinkedEntry(k2);
            this.makeTail(linkedEntry);
            this.keyToEntry.put(k2, linkedEntry);
        } else {
            k2.offer();
        }
        linkedEntry.add(v2);
    }

    public V get(K k2) {
        LinkedEntry<K, V> linkedEntry = this.keyToEntry.get(k2);
        if (linkedEntry == null) {
            linkedEntry = new LinkedEntry(k2);
            this.keyToEntry.put(k2, linkedEntry);
        } else {
            k2.offer();
        }
        this.makeHead(linkedEntry);
        return linkedEntry.removeLast();
    }

    public V removeLast() {
        LinkedEntry linkedEntry = this.head.prev;
        while (!linkedEntry.equals(this.head)) {
            Object v2 = linkedEntry.removeLast();
            if (v2 != null) {
                return v2;
            }
            GroupedLinkedMap.removeEntry(linkedEntry);
            this.keyToEntry.remove(linkedEntry.key);
            ((Poolable)linkedEntry.key).offer();
            linkedEntry = linkedEntry.prev;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GroupedLinkedMap( ");
        LinkedEntry linkedEntry = this.head.next;
        boolean bl = false;
        while (!linkedEntry.equals(this.head)) {
            bl = true;
            stringBuilder.append('{').append(linkedEntry.key).append(':').append(linkedEntry.size()).append("}, ");
            linkedEntry = linkedEntry.next;
        }
        if (bl) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.append(" )").toString();
    }

    private void makeHead(LinkedEntry<K, V> linkedEntry) {
        GroupedLinkedMap.removeEntry(linkedEntry);
        linkedEntry.prev = this.head;
        linkedEntry.next = this.head.next;
        GroupedLinkedMap.updateEntry(linkedEntry);
    }

    private void makeTail(LinkedEntry<K, V> linkedEntry) {
        GroupedLinkedMap.removeEntry(linkedEntry);
        linkedEntry.prev = this.head.prev;
        linkedEntry.next = this.head;
        GroupedLinkedMap.updateEntry(linkedEntry);
    }

    private static <K, V> void updateEntry(LinkedEntry<K, V> linkedEntry) {
        linkedEntry.next.prev = linkedEntry;
        linkedEntry.prev.next = linkedEntry;
    }

    private static <K, V> void removeEntry(LinkedEntry<K, V> linkedEntry) {
        linkedEntry.prev.next = linkedEntry.next;
        linkedEntry.next.prev = linkedEntry.prev;
    }

    private static class LinkedEntry<K, V> {
        private final K key;
        private List<V> values;
        LinkedEntry<K, V> next;
        LinkedEntry<K, V> prev;

        public LinkedEntry() {
            this(null);
        }

        public LinkedEntry(K k2) {
            this.next = this.prev = this;
            this.key = k2;
        }

        public V removeLast() {
            int n2 = this.size();
            return n2 > 0 ? (V)this.values.remove(n2 - 1) : null;
        }

        public int size() {
            return this.values != null ? this.values.size() : 0;
        }

        public void add(V v2) {
            if (this.values == null) {
                this.values = new ArrayList<V>();
            }
            this.values.add(v2);
        }
    }
}

