/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.hpplay.glide.BitmapOptions;
import com.hpplay.glide.DrawableOptions;
import com.hpplay.glide.GenericRequestBuilder;
import com.hpplay.glide.Glide;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.Encoder;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.ResourceDecoder;
import com.hpplay.glide.load.ResourceEncoder;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.engine.DiskCacheStrategy;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import com.hpplay.glide.load.resource.bitmap.BitmapTransformation;
import com.hpplay.glide.load.resource.drawable.GlideDrawable;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.hpplay.glide.load.resource.gifbitmap.GifBitmapWrapperTransformation;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.manager.Lifecycle;
import com.hpplay.glide.manager.RequestTracker;
import com.hpplay.glide.provider.LoadProvider;
import com.hpplay.glide.request.RequestListener;
import com.hpplay.glide.request.animation.DrawableCrossFadeFactory;
import com.hpplay.glide.request.animation.ViewPropertyAnimation;
import com.hpplay.glide.request.target.Target;
import java.io.File;

public class DrawableRequestBuilder<ModelType>
extends GenericRequestBuilder<ModelType, ImageVideoWrapper, GifBitmapWrapper, GlideDrawable>
implements BitmapOptions,
DrawableOptions {
    DrawableRequestBuilder(Context context, Class<ModelType> clazz, LoadProvider<ModelType, ImageVideoWrapper, GifBitmapWrapper, GlideDrawable> loadProvider, Glide glide, RequestTracker requestTracker, Lifecycle lifecycle) {
        super(context, clazz, loadProvider, GlideDrawable.class, glide, requestTracker, lifecycle);
        this.crossFade();
    }

    public DrawableRequestBuilder<ModelType> thumbnail(DrawableRequestBuilder<?> drawableRequestBuilder) {
        super.thumbnail(drawableRequestBuilder);
        return this;
    }

    public DrawableRequestBuilder<ModelType> thumbnail(GenericRequestBuilder<?, ?, ?, GlideDrawable> genericRequestBuilder) {
        super.thumbnail(genericRequestBuilder);
        return this;
    }

    public DrawableRequestBuilder<ModelType> thumbnail(float f2) {
        super.thumbnail(f2);
        return this;
    }

    public DrawableRequestBuilder<ModelType> sizeMultiplier(float f2) {
        super.sizeMultiplier(f2);
        return this;
    }

    public DrawableRequestBuilder<ModelType> decoder(ResourceDecoder<ImageVideoWrapper, GifBitmapWrapper> resourceDecoder) {
        super.decoder(resourceDecoder);
        return this;
    }

    public DrawableRequestBuilder<ModelType> cacheDecoder(ResourceDecoder<File, GifBitmapWrapper> resourceDecoder) {
        super.cacheDecoder(resourceDecoder);
        return this;
    }

    public DrawableRequestBuilder<ModelType> encoder(ResourceEncoder<GifBitmapWrapper> resourceEncoder) {
        super.encoder(resourceEncoder);
        return this;
    }

    public DrawableRequestBuilder<ModelType> priority(Priority priority) {
        super.priority(priority);
        return this;
    }

    public DrawableRequestBuilder<ModelType> transform(BitmapTransformation ... bitmapTransformationArray) {
        return this.bitmapTransform(bitmapTransformationArray);
    }

    public DrawableRequestBuilder<ModelType> centerCrop() {
        return this.transform(new Transformation[]{this.glide.getDrawableCenterCrop()});
    }

    public DrawableRequestBuilder<ModelType> fitCenter() {
        return this.transform(new Transformation[]{this.glide.getDrawableFitCenter()});
    }

    public DrawableRequestBuilder<ModelType> bitmapTransform(Transformation<Bitmap> ... transformationArray) {
        Transformation[] transformationArray2 = new GifBitmapWrapperTransformation[transformationArray.length];
        for (int i2 = 0; i2 < transformationArray.length; ++i2) {
            transformationArray2[i2] = new GifBitmapWrapperTransformation(this.glide.getBitmapPool(), transformationArray[i2]);
        }
        return this.transform(transformationArray2);
    }

    public DrawableRequestBuilder<ModelType> transform(Transformation<GifBitmapWrapper> ... transformationArray) {
        super.transform(transformationArray);
        return this;
    }

    public DrawableRequestBuilder<ModelType> transcoder(ResourceTranscoder<GifBitmapWrapper, GlideDrawable> resourceTranscoder) {
        super.transcoder(resourceTranscoder);
        return this;
    }

    public final DrawableRequestBuilder<ModelType> crossFade() {
        super.animate(new DrawableCrossFadeFactory());
        return this;
    }

    public DrawableRequestBuilder<ModelType> crossFade(int n2) {
        super.animate(new DrawableCrossFadeFactory(n2));
        return this;
    }

    @Deprecated
    public DrawableRequestBuilder<ModelType> crossFade(Animation animation, int n2) {
        super.animate(new DrawableCrossFadeFactory(animation, n2));
        return this;
    }

    public DrawableRequestBuilder<ModelType> crossFade(int n2, int n3) {
        super.animate(new DrawableCrossFadeFactory(this.context, n2, n3));
        return this;
    }

    public DrawableRequestBuilder<ModelType> dontAnimate() {
        super.dontAnimate();
        return this;
    }

    public DrawableRequestBuilder<ModelType> animate(ViewPropertyAnimation.Animator animator) {
        super.animate(animator);
        return this;
    }

    public DrawableRequestBuilder<ModelType> animate(int n2) {
        super.animate(n2);
        return this;
    }

    @Deprecated
    public DrawableRequestBuilder<ModelType> animate(Animation animation) {
        super.animate(animation);
        return this;
    }

    public DrawableRequestBuilder<ModelType> placeholder(int n2) {
        super.placeholder(n2);
        return this;
    }

    public DrawableRequestBuilder<ModelType> placeholder(Drawable drawable) {
        super.placeholder(drawable);
        return this;
    }

    public DrawableRequestBuilder<ModelType> fallback(Drawable drawable) {
        super.fallback(drawable);
        return this;
    }

    public DrawableRequestBuilder<ModelType> fallback(int n2) {
        super.fallback(n2);
        return this;
    }

    public DrawableRequestBuilder<ModelType> error(int n2) {
        super.error(n2);
        return this;
    }

    public DrawableRequestBuilder<ModelType> error(Drawable drawable) {
        super.error(drawable);
        return this;
    }

    public DrawableRequestBuilder<ModelType> listener(RequestListener<? super ModelType, GlideDrawable> requestListener) {
        super.listener(requestListener);
        return this;
    }

    public DrawableRequestBuilder<ModelType> diskCacheStrategy(DiskCacheStrategy diskCacheStrategy) {
        super.diskCacheStrategy(diskCacheStrategy);
        return this;
    }

    public DrawableRequestBuilder<ModelType> skipMemoryCache(boolean bl) {
        super.skipMemoryCache(bl);
        return this;
    }

    public DrawableRequestBuilder<ModelType> override(int n2, int n3) {
        super.override(n2, n3);
        return this;
    }

    public DrawableRequestBuilder<ModelType> sourceEncoder(Encoder<ImageVideoWrapper> encoder) {
        super.sourceEncoder(encoder);
        return this;
    }

    public DrawableRequestBuilder<ModelType> dontTransform() {
        super.dontTransform();
        return this;
    }

    public DrawableRequestBuilder<ModelType> signature(Key key) {
        super.signature(key);
        return this;
    }

    public DrawableRequestBuilder<ModelType> load(ModelType ModelType) {
        super.load(ModelType);
        return this;
    }

    @Override
    public DrawableRequestBuilder<ModelType> clone() {
        return (DrawableRequestBuilder)super.clone();
    }

    @Override
    public Target<GlideDrawable> into(ImageView imageView) {
        return super.into(imageView);
    }

    @Override
    void applyFitCenter() {
        this.fitCenter();
    }

    @Override
    void applyCenterCrop() {
        this.centerCrop();
    }
}

