/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.soap;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.soap.SOAP;
import com.hpplay.cybergarage.xml.Node;

public class SOAPResponse
extends HTTPResponse {
    private static final String TAG = "Cyber-SOAPResponse";
    private Node rootNode;

    public SOAPResponse() {
        this.setRootNode(SOAP.createEnvelopeBodyNode());
        this.setContentType("text/xml; charset=\"utf-8\"");
    }

    public SOAPResponse(HTTPResponse hTTPResponse) {
        super(hTTPResponse);
        this.setRootNode(SOAP.createEnvelopeBodyNode());
        this.setContentType("text/xml; charset=\"utf-8\"");
    }

    public SOAPResponse(SOAPResponse sOAPResponse) {
        super(sOAPResponse);
        this.setEnvelopeNode(sOAPResponse.getEnvelopeNode());
        this.setContentType("text/xml; charset=\"utf-8\"");
    }

    private void setRootNode(Node node) {
        this.rootNode = node;
    }

    private Node getRootNode() {
        return this.rootNode;
    }

    public void setEnvelopeNode(Node node) {
        this.setRootNode(node);
    }

    public Node getEnvelopeNode() {
        return this.getRootNode();
    }

    public Node getBodyNode() {
        Node node = this.getEnvelopeNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("Body");
    }

    public Node getMethodResponseNode(String string) {
        Node node = this.getBodyNode();
        if (node == null) {
            return null;
        }
        String string2 = string + "Response";
        return node.getNodeEndsWith(string2);
    }

    public Node getFaultNode() {
        Node node = this.getBodyNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("Fault");
    }

    public Node getFaultCodeNode() {
        Node node = this.getFaultNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("faultcode");
    }

    public Node getFaultStringNode() {
        Node node = this.getFaultNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("faultstring");
    }

    public Node getFaultActorNode() {
        Node node = this.getFaultNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("faultactor");
    }

    public Node getFaultDetailNode() {
        Node node = this.getFaultNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("detail");
    }

    public String getFaultCode() {
        Node node = this.getFaultCodeNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public String getFaultString() {
        Node node = this.getFaultStringNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public String getFaultActor() {
        Node node = this.getFaultActorNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public void setContent(Node node) {
        String string = "";
        string = string + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string = string + "\n";
        string = string + node.toString();
        this.setContent(string);
    }

    @Override
    public void print() {
        CLog.d(TAG, this.toString());
        if (this.hasContent()) {
            return;
        }
        Node node = this.getRootNode();
        if (node == null) {
            return;
        }
        CLog.d(TAG, node.toString());
    }
}

