/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.push;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.protocol.ProtocolBuilder;
import com.hpplay.component.protocol.push.IPushHandler;
import java.net.URLDecoder;
import org.json.JSONException;
import org.json.JSONObject;

public class DLNAPushHandler
extends IPushHandler {
    private static final String TAG = "DLNAPushHandler";
    private static final String CMD_TAG = "LLL@BBB";

    public DLNAPushHandler(ParamsMap paramsMap) {
        super(paramsMap);
    }

    @Override
    String buildPush(String string, ParamsMap paramsMap) {
        String string2 = (String)paramsMap.get("mediatype");
        String string3 = paramsMap.getStringParam("dlna_meta_data");
        if (paramsMap.containsKey("start_postion")) {
            this.mStartPosition = Integer.parseInt(paramsMap.get("start_postion").toString());
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = this.getMetaData(string, string2);
        }
        return "PlayLLL@BBB" + string + CMD_TAG + string3 + CMD_TAG + this.mStartPosition;
    }

    @Override
    String buildGetPlayInfo() {
        return "GetPositionInfo";
    }

    @Override
    String buildGetStateInfo() {
        return "GetTransportInfo";
    }

    @Override
    String buildPause() {
        return "Pause";
    }

    @Override
    String buildResume() {
        return "Resume";
    }

    @Override
    String buildSeekTo(int n2) {
        return "SeekLLL@BBB" + n2;
    }

    @Override
    String buildIncreaseVolume() {
        return "incvloume";
    }

    @Override
    String buildDecreaseVolume() {
        return "decvolume";
    }

    @Override
    String buildStopPlay() {
        return "Stop";
    }

    @Override
    public boolean parsePlayBackInfo(int n2, String string, ProtocolListener protocolListener) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            protocolListener.onResult(n2, jSONObject.optString("duration"), jSONObject.optString("position"), jSONObject.optString("url"));
            return true;
        }
        catch (JSONException jSONException) {
            CLog.w(TAG, jSONException);
            return false;
        }
    }

    @Override
    String setVolume(int n2) {
        return "SetVolumeLLL@BBB" + n2;
    }

    private String getMetaData(String string, String string2) {
        String string3 = "0";
        if (string.endsWith("&")) {
            string = string.substring(0, string.length() - 1);
        }
        String string4 = "DLNA-Video";
        if (!TextUtils.isEmpty((CharSequence)this.mediaAssetName)) {
            string4 = this.mediaAssetName;
        }
        try {
            string = URLDecoder.decode(string, "utf-8");
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        try {
            string = (String)ModuleLinker.getInstance().callMethod("E8432C8292C9896773592902EFD20CAD", string);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (string2.equals("102")) {
            string3 = new ProtocolBuilder().setDlnaContentUri(this.mPushUri).setId(TextUtils.isEmpty((CharSequence)this.dlnaID) ? "0" : this.dlnaID).setDcTitle(string4).setArtist(this.dlnaArtist).setCreator(this.dlnaCreator).setSize(this.dlnaSize).setDuration(this.dlnaDuration).setResolution(this.dlnaResolution).setDlnaSessionId(this.mSessionId).setParentid("0").setRestricted("0").setUPNPclass("object.item.videoItem").setProtocolInfo("\"http-get:*:video/mp4:DLNA.ORG_PN=MP3;DLNA.ORG_OP=01;DLNA.ORG_FLAGS=01500000000000000000000000000000\" ").setPath(string).getVideoMetaData().getString(false);
        } else if (string2.equals("103")) {
            int n2 = 0;
            string3 = new ProtocolBuilder().setDlnaContentUri(this.mPushUri).setDlnaSessionId(this.mSessionId).setPath(string).setSize(n2).getImageMetaData().getString(false);
        } else if (string2.equals("101")) {
            string4 = !TextUtils.isEmpty((CharSequence)this.mediaAssetName) ? this.mediaAssetName : "DLNA-Music";
            String string5 = null;
            if (!TextUtils.isEmpty((CharSequence)this.dlnaAlbumUrl)) {
                try {
                    string5 = URLDecoder.decode(this.dlnaAlbumUrl, "utf-8");
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
                try {
                    string5 = (String)ModuleLinker.getInstance().callMethod("E8432C8292C9896773592902EFD20CAD", string5);
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
            }
            string3 = new ProtocolBuilder().setDlnaContentUri(this.mPushUri).setId(TextUtils.isEmpty((CharSequence)this.dlnaID) ? "0" : this.dlnaID).setDcTitle(string4).setAlbum(this.dlnaAlbum).setAlbumUrl(string5).setArtist(this.dlnaArtist).setCreator(this.dlnaCreator).setSize(this.dlnaSize).setDuration(this.dlnaDuration).setParentid("0").setDlnaSessionId(this.mSessionId).setParentid("0").setRestricted("0").setUPNPclass("object.item.audioItem.musicTrack").setProtocolInfo("\"http-get:*:audio/mpeg:DLNA.ORG_OP=01\" ").setPath(string).getAudioMetaData().getString(false);
        }
        CLog.i(TAG, "metaData---> " + string3);
        return string3;
    }

    public void retryHttp(boolean bl) {
        try {
            ModuleLinker.getInstance().callMethod("556D87A111521457C3401E369BD227B6", bl);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }
}

