/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import android.text.TextUtils;
import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.protocol.ProtocolCore;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.server.IRequstManager;
import com.hpplay.component.protocol.server.RequestHandler;
import com.hpplay.component.protocol.server.RequestManagerImp;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Random;

public class MirrorEventReceiver
extends ProtocolCore
implements Runnable {
    private static final String TAG = "MirrorEventReceiver";
    private IRequstManager mRequstManager;
    private String mIp;
    private int mPort;
    private IMirrorStateListener mMirrorStateListener;
    private MirrorServStartListener mStartListener;
    private boolean isStart;
    private Thread serverThread;
    private boolean isSpacialChannel;
    private byte[] local = new byte[]{49, 50, 55, 46, 48, 46, 48, 46, 49};
    public int mSpacailPort = 51119;
    private int mEventPort = 10356;

    public MirrorEventReceiver(IMirrorStateListener iMirrorStateListener, boolean bl) {
        this.mMirrorStateListener = iMirrorStateListener;
        this.mRequstManager = new RequestManagerImp();
        this.isSpacialChannel = bl;
    }

    public void setMirrorServStartListener(MirrorServStartListener mirrorServStartListener) {
        this.mStartListener = mirrorServStartListener;
    }

    public String getMirrorEnventIP() {
        String string;
        if (ProtocolUtils.isNetworkConnected(ModuleLinker.getInstance().getContext())) {
            string = ProtocolUtils.getWifiIp();
            CLog.i(TAG, "wifi   ip  " + string.replace(".", "") + "    LoaclIp  ");
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = ProtocolUtils.getLoaclIp();
            }
        } else {
            CLog.i(TAG, "use moble host ip  ");
            string = ProtocolUtils.getLoaclIp();
        }
        CLog.i(TAG, "use realIp " + string);
        return string;
    }

    public void startServer() {
        this.serverThread = new Thread(this);
        this.serverThread.setDaemon(true);
        this.serverThread.setName("EventServer");
        this.serverThread.start();
    }

    String getIP() {
        if (TextUtils.isEmpty((CharSequence)this.mIp)) {
            this.mIp = new String(this.local);
        }
        return this.mIp;
    }

    @Override
    public void run() {
        this.isStart = this.createMirrorEventServer(null, this.genMirrorEventPort());
        if (!this.isStart) {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.isStart = this.createMirrorEventServer(null, this.mEventPort += new Random().nextInt(10000));
                if (this.isStart) break;
            }
        }
        CLog.i(TAG, "start state  " + this.isStart + " " + this.mEventPort);
        if (this.mStartListener != null) {
            this.mStartListener.onStart(this);
        }
        while (this.isStart) {
            try {
                Socket socket = this.mMirrorEventServer.accept();
                InputStream inputStream = socket.getInputStream();
                CLog.i(TAG, "new connection");
                if (this.isSpacialChannel) {
                    this.mRequstManager.closeAll();
                    continue;
                }
                this.mRequstManager.exec(new RequestHandler(this.mRequstManager, this.mMirrorStateListener, inputStream, socket));
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
                break;
            }
        }
        CLog.i(TAG, "mirror event server stopped ...");
    }

    public int genMirrorEventPort() {
        boolean bl = ProtocolUtils.checkLoaclPort(this.mEventPort);
        if (bl) {
            this.mEventPort += new Random().nextInt(100);
        }
        return this.mEventPort;
    }

    public IMirrorStateListener genMirrorStateListener() {
        return this.mMirrorStateListener;
    }

    public int getMirrorEventPort() {
        return this.mEventPort;
    }

    public void closeAllChannel() {
        if (this.mRequstManager != null) {
            this.mRequstManager.closeAll();
        }
    }

    public void stopServer() {
        CLog.i(TAG, "stop mirror event server ...");
        if (this.mRequstManager != null) {
            this.mRequstManager.closeAll();
        }
        if (this.mMirrorEventServer != null) {
            try {
                this.mMirrorEventServer.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
        }
        this.mMirrorStateListener = null;
        this.isStart = false;
        if (this.mRequstManager != null) {
            this.mRequstManager.closeAll();
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
    }

    public static interface MirrorServStartListener {
        public void onStart(MirrorEventReceiver var1);
    }
}

