/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IConnector;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.connection.ConnectTask;

public class ConnectorImp
extends IConnector {
    private static final String TAG = "ConnectorImp";
    private Thread mConnectThread;
    private ConnectTask mConnectTask;

    @Override
    public void connect(ParamsMap paramsMap, ProtocolListener protocolListener) {
        CLog.i(TAG, "connect ~~~~");
        this.mConnectTask = new ConnectTask();
        this.mConnectTask.connect(paramsMap, protocolListener);
        this.mConnectThread = new Thread(this.mConnectTask);
        this.mConnectThread.start();
    }

    @Override
    public void checkConnection(ProtocolListener protocolListener) {
        CLog.i(TAG, "checkConnection ~~~~");
        if (this.mConnectTask != null) {
            this.mConnectTask.checkConnection(protocolListener);
        }
    }

    @Override
    public String getConnectSessionId() {
        if (this.mConnectTask != null) {
            return this.mConnectTask.getConnectSessionId();
        }
        return "";
    }

    @Override
    public void onAppResume() {
        if (this.mConnectTask != null) {
            this.mConnectTask.onAppResume();
        }
    }

    @Override
    public void onAppPause() {
        if (this.mConnectTask != null) {
            this.mConnectTask.onAppPause();
        }
    }

    @Override
    public boolean sendPassthroughData(int n2, String string, String string2, ProtocolListener protocolListener) {
        if (this.mConnectTask == null) {
            return false;
        }
        return this.mConnectTask.sendPassthroughData(n2, string, string2, protocolListener);
    }

    @Override
    public void disConnect() {
        CLog.i(TAG, "disConnect");
        if (this.mConnectTask != null) {
            this.mConnectTask.setProtocolListener(null);
            this.mConnectTask.disConnect();
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.interrupt();
            this.mConnectThread = null;
        }
    }
}

