/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol;

import android.annotation.TargetApi;
import android.content.Context;
import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.encrypt.ED25519Encrypt;
import com.hpplay.component.utils.EncryptUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;

public class ProtocolUtils {
    public static final String TAG = "ProtocolUtils";
    public static final String CONTENT_LENGTH = "Content-Length:";
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static boolean getProtocolDivide(ArrayList<Byte> arrayList) {
        return arrayList.size() > 11 && arrayList.get(arrayList.size() - 1) == 10 && arrayList.get(arrayList.size() - 2) == 13 && arrayList.get(arrayList.size() - 3) == 10 && arrayList.get(arrayList.size() - 4) == 13;
    }

    public static byte[] getBody(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != 13 || byArray[i2 + 1] != 10 || byArray[i2 + 2] != 13 || byArray[i2 + 3] != 10) continue;
            byte[] byArray2 = new byte[byArray.length - (i2 + 4)];
            System.arraycopy(byArray, i2 + 4, byArray2, 0, byArray2.length);
            CLog.d(TAG, "body totalLength" + (byArray.length - (i2 + 3)));
            return byArray2;
        }
        return null;
    }

    public static int bytesToInt(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 5];
        int n2 = 0;
        for (byte by : byArray) {
            cArray[n2++] = 48;
            cArray[n2++] = 120;
            cArray[n2++] = HEX_CHAR[by >>> 4 & 0xF];
            cArray[n2++] = HEX_CHAR[by & 0xF];
            cArray[n2++] = 44;
        }
        return new String(cArray);
    }

    public static byte[] intToBytes(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        return byArray;
    }

    public static int getContentLength(String string) {
        String[] stringArray = string.split("\r\n");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].contains(CONTENT_LENGTH)) continue;
            try {
                String string2 = stringArray[i2];
                int n2 = Integer.valueOf(string2.split(":")[1].toString().trim());
                CLog.d(TAG, "contentLength" + n2 + "");
                return n2;
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
                return 0;
            }
        }
        return 0;
    }

    public static byte[] removeHeader(byte[] byArray) {
        int n2 = byArray.length;
        String string = new String(byArray);
        int n3 = string.indexOf("\r\n\r\n");
        int n4 = n2 - n3 - 4;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3 + 4, byArray2, 0, n4);
        String string2 = new String(byArray2, 0, byArray2.length);
        if (string2.startsWith("\n")) {
            int n5 = string.indexOf("\r\n\r\n\n");
            int n6 = n2 - n5 - 6;
            byte[] byArray3 = new byte[n6];
            System.arraycopy(byArray, n5 + 6, byArray3, 0, n6);
            return byArray3;
        }
        return byArray2;
    }

    public static boolean checkLoaclPort(int n2) {
        boolean bl = true;
        try {
            bl = ProtocolUtils.isPortUsing("127.0.0.1", n2);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortUsing(String string, int n2) {
        boolean bl = false;
        InetAddress inetAddress = InetAddress.getByName(string);
        Socket socket = null;
        try {
            socket = new Socket(inetAddress, n2);
            bl = true;
        }
        catch (IOException iOException) {
            CLog.w(TAG, iOException);
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    CLog.w(TAG, iOException);
                }
            }
        }
        return bl;
    }

    public static String getLoaclIp() {
        String string = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            InetAddress inetAddress = null;
            block2: while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    String string2;
                    inetAddress = enumeration2.nextElement();
                    if (inetAddress instanceof Inet6Address || "127.0.0.1".equals(string2 = inetAddress.getHostAddress())) continue;
                    string = inetAddress.getHostAddress();
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return string;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo.getType() == 1;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return false;
        }
    }

    public static String getWifiIp() {
        String string;
        block4: {
            string = null;
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    if (!networkInterface.getDisplayName().contains("wlan0")) continue;
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        string = inetAddress.getHostAddress();
                        break block4;
                    }
                    break;
                }
            }
            catch (SocketException socketException) {
                CLog.w(TAG, socketException);
            }
        }
        return string;
    }

    @TargetApi(value=24)
    public static String getDateTime(long l2) {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"GMT+8"));
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(1);
        int n3 = calendar.get(2) + 1;
        String string = null;
        string = String.valueOf(n3).length() == 1 ? "0" + n3 : String.valueOf(n3);
        int n4 = calendar.get(5);
        String string2 = String.valueOf(n4).length() == 1 ? "0" + n4 : String.valueOf(n4);
        int n5 = calendar.get(11);
        String string3 = String.valueOf(n5).length() == 1 ? "0" + n5 : String.valueOf(n5);
        int n6 = calendar.get(12);
        String string4 = String.valueOf(n6).length() == 1 ? "0" + n6 : String.valueOf(n6);
        int n7 = calendar.get(13);
        String string5 = String.valueOf(n7).length() == 1 ? "0" + n7 : String.valueOf(n7);
        return n2 + "-" + string + "-" + string2 + " " + string3 + ":" + string4 + ":" + string5;
    }

    public static String strEncrpyt(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            CLog.w(TAG, unsupportedEncodingException);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return "";
            }
            byArray = string.getBytes();
        }
        String string2 = null;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] byArray2 = new byte[16];
            ED25519Encrypt eD25519Encrypt = new ED25519Encrypt();
            eD25519Encrypt.strcrypt(byArray, byArray.length, byArray2);
            char[] cArray2 = new char[32];
            int n2 = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                byte by = byArray2[i2];
                cArray2[n2++] = cArray[by >>> 4 & 0xF];
                cArray2[n2++] = cArray[by & 0xF];
            }
            string2 = new String(cArray2);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return string2;
    }

    public static byte[] Encrypt(String string) {
        byte[] byArray = new byte[16];
        try {
            ED25519Encrypt eD25519Encrypt = new ED25519Encrypt();
            byte[] byArray2 = string.getBytes("UTF-8");
            eD25519Encrypt.strcrypt(byArray2, byArray2.length, byArray);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
        int n2 = 0;
        while (n2 < 16) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] ^ 0x78);
        }
        return byArray;
    }

    public static byte[] strToMdHash(String string) {
        byte[] byArray = new byte[16];
        try {
            ED25519Encrypt eD25519Encrypt = new ED25519Encrypt();
            byte[] byArray2 = string.getBytes("UTF-8");
            eD25519Encrypt.mdInit();
            eD25519Encrypt.mdUpdate(byArray2, byArray2.length);
            eD25519Encrypt.mdDoFinal(byArray);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
        return byArray;
    }

    public static String getHeader(byte[] byArray) {
        int n2 = byArray.length;
        String string = new String(byArray);
        int n3 = string.indexOf("\r\n\r\n");
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        String string2 = new String(byArray2, 0, byArray2.length);
        return string2;
    }

    public static String drEncrypt(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        try {
            byte[] byArray = new byte[16];
            ED25519Encrypt eD25519Encrypt = new ED25519Encrypt();
            byte[] byArray2 = string.getBytes("UTF-8");
            eD25519Encrypt.strcrypt(byArray2, byArray2.length, byArray);
            String string2 = "";
            for (byte by : byArray) {
                String string3 = Integer.toHexString(by & 0xFF);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                string2 = string2 + string3;
            }
            return string2;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return "";
        }
    }

    public static String getStreaEncrypt(InputStream inputStream) {
        String string = "";
        try {
            int n2;
            if (inputStream == null) {
                return "";
            }
            byte[] byArray = new byte[8192];
            ED25519Encrypt eD25519Encrypt = new ED25519Encrypt();
            eD25519Encrypt.mdInit();
            while ((n2 = inputStream.read(byArray)) != -1) {
                eD25519Encrypt.mdUpdate(byArray, n2);
            }
            inputStream.close();
            byte[] byArray2 = new byte[16];
            eD25519Encrypt.mdDoFinal(byArray2);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            string = bigInteger.toString(16);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileEncrypt(String string) {
        String string2 = "";
        FileInputStream fileInputStream = null;
        try {
            int n2;
            byte[] byArray = new byte[8192];
            ED25519Encrypt eD25519Encrypt = new ED25519Encrypt();
            eD25519Encrypt.mdInit();
            File file = new File(string);
            fileInputStream = new FileInputStream(file);
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                eD25519Encrypt.mdUpdate(byArray, n2);
            }
            fileInputStream.close();
            byte[] byArray2 = new byte[16];
            eD25519Encrypt.mdDoFinal(byArray2);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            string2 = bigInteger.toString(16);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string2;
    }

    public static String createSessionId(String string) {
        String string2 = (string + String.valueOf(System.currentTimeMillis())).toUpperCase();
        String string3 = EncryptUtil.md5EncryData(string2).toUpperCase();
        return string3;
    }
}

