/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.hpplay.component.modulelinker.LinkerDataManager;
import com.hpplay.component.modulelinker.ModuleLoadUtils;
import com.hpplay.component.modulelinker.api.IModuleLinker;
import com.hpplay.component.modulelinker.patch.PatchParser;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONArray;

@TargetApi(value=19)
public class ModuleLinkerImp
implements IModuleLinker {
    public static final String TAG = "ModuleLinkerImp";
    public static final String DEFAULT_PATH = "com.hpplay.component.common.utils";
    private String mInstanceId = "";
    private LinkedList<String> mModuleIdsPackages = new LinkedList();

    public ModuleLinkerImp(boolean bl) {
        if (bl) {
            this.mInstanceId = String.valueOf(System.currentTimeMillis());
        }
    }

    @Override
    public synchronized void init(Context context, String ... stringArray) {
        this.init(context, (ClassLoader)null, (String)null, (String[])null, stringArray);
    }

    @Override
    public void init(Context context, String[] stringArray, String ... stringArray2) {
        this.init(context, (ClassLoader)null, (String)null, stringArray, stringArray2);
    }

    @Override
    public void init(Context context, ClassLoader classLoader, String[] stringArray, String ... stringArray2) {
        this.init(context, classLoader, (String)null, stringArray, stringArray2);
    }

    @Override
    public void init(Context context, ClassLoader classLoader, String string, String[] stringArray, String ... stringArray2) {
        if (stringArray2 != null && stringArray2.length > 0) {
            this.mModuleIdsPackages.addAll(Arrays.asList(stringArray2));
        }
        if (!this.mModuleIdsPackages.contains(DEFAULT_PATH)) {
            Log.i((String)TAG, (String)" =====>set DEFAULT_PATH ");
            this.mModuleIdsPackages.add(DEFAULT_PATH);
        } else {
            Log.i((String)TAG, (String)" =====>default path :  com.hpplay.component.common.utils");
        }
        if (LinkerDataManager.getInstance().getCacheMap() == null || LinkerDataManager.getInstance().getCacheMap().size() == 0) {
            long l2 = System.currentTimeMillis();
            ClassLoader classLoader2 = new PatchParser().getPatchLoader(context.getApplicationContext(), stringArray);
            if (classLoader2 != null) {
                ModuleLoadUtils.setPatchClassLoader(classLoader2);
            }
            if (classLoader != null) {
                ModuleLoadUtils.setExternalClassLoader(classLoader);
            }
            LinkerDataManager.getInstance().init(context.getApplicationContext(), string, this.mModuleIdsPackages, 0);
            Log.i((String)TAG, (String)(" init time  " + (System.currentTimeMillis() - l2)));
            Log.i((String)TAG, (String)(" =====> " + this.getLinkInfoMap().size()));
        } else {
            Log.i((String)TAG, (String)" =====> is already init ");
        }
    }

    private void putCache(String string, Object object) {
        LinkerDataManager.getInstance().putCache(this.mInstanceId + string, object);
    }

    private Object getCache(String string) {
        return LinkerDataManager.getInstance().getCache(this.mInstanceId + string);
    }

    private Object removeCache(String string) {
        return LinkerDataManager.getInstance().removeCache(this.mInstanceId + string);
    }

    private Map<String, String> getLinkInfoMap() {
        return LinkerDataManager.getInstance().getLinkInfoMap();
    }

    private JSONArray getClazzs() {
        return LinkerDataManager.getInstance().getClazzs();
    }

    private JSONArray getMethods() {
        return LinkerDataManager.getInstance().getMethods();
    }

    private JSONArray getFields() {
        return LinkerDataManager.getInstance().getFields();
    }

    @Override
    public void putLinkInfo(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        LinkerDataManager.getInstance().putLinkInfo(string, string2);
    }

    @Override
    public String getClassName(String string) {
        return LinkerDataManager.getInstance().getClassName(string);
    }

    @Override
    public Context getContext() {
        return LinkerDataManager.getInstance().getContext();
    }

    @Override
    public synchronized Object loadModule(String string) {
        Object var2_2 = null;
        return this.loadModule(string, var2_2);
    }

    @Override
    public Object getModule(String string) {
        return LinkerDataManager.getInstance().getCacheMap().get((Object)string);
    }

    @Override
    public synchronized Object loadModule(String string, Object ... objectArray) {
        Object object;
        if (this.getLinkInfoMap().size() == 0) {
            if (ModuleLoadUtils.getApplication() != null) {
                Log.i((String)TAG, (String)"reload module linker ... ");
                this.init((Context)ModuleLoadUtils.getApplication(), new String[0]);
            } else {
                Log.i((String)TAG, (String)"getApplication failed");
            }
            if (this.getLinkInfoMap().size() == 0) {
                throw new Exception(" Modulelinker init failed !!!");
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.getLinkInfoMap().get(string))) {
            throw new Exception("This module is not loaded !!!");
        }
        Class[] classArray = null;
        Object[] objectArray2 = null;
        if (objectArray != null && objectArray.length > 1) {
            classArray = new Class[objectArray.length / 2];
            objectArray2 = new Object[objectArray.length / 2];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (i2 % 2 == 0) {
                    if (i2 == 0) {
                        objectArray2[0] = objectArray[0];
                        continue;
                    }
                    objectArray2[i2] = objectArray[i2 - 1];
                    continue;
                }
                if (i2 == 1) {
                    classArray[0] = (Class)objectArray[i2];
                    continue;
                }
                classArray[i2] = (Class)objectArray[i2 - 2];
            }
        }
        if ((object = this.getCache(string)) == null) {
            String string2 = "";
            for (int i3 = 0; i3 < this.getClazzs().length(); ++i3) {
                JSONArray jSONArray = new JSONArray(this.getClazzs().get(i3).toString());
                if (!jSONArray.optString(0).equals(string)) continue;
                string2 = jSONArray.optString(1);
            }
            Object object2 = !string2.equals("new") ? ModuleLoadUtils.getSingleInstance(this.getLinkInfoMap().get(string), string2, classArray, objectArray2) : ModuleLoadUtils.getNewInstance(this.getLinkInfoMap().get(string), classArray, objectArray2);
            if (object2 == null) {
                throw new Exception(" the class does not exist !!!");
            }
            this.putCache(string, object2);
        }
        return this.getCache(string);
    }

    @Override
    public synchronized Object callMethod(String string, Object ... objectArray) {
        Object object;
        String string2 = null;
        String string3 = null;
        if (this.getClazzs().length() == 0 || TextUtils.isEmpty((CharSequence)string)) {
            throw new Exception(" no marked functions !!!");
        }
        String string4 = null;
        for (int i2 = 0; i2 < this.getMethods().length(); ++i2) {
            object = new JSONArray(this.getMethods().get(i2).toString());
            if (!object.optString(0).equals(string)) continue;
            string3 = object.optString(1);
            string2 = object.optString(2);
            string4 = object.optString(3);
            break;
        }
        if (TextUtils.isEmpty(string4)) {
            throw new Exception(" the function does not exist  !!!");
        }
        if (!TextUtils.isEmpty(string2) && string2.equals("static")) {
            return ModuleLoadUtils.exeMethod(this.getLinkInfoMap().get(string4), string3, objectArray);
        }
        Object object2 = this.loadModule(string4);
        if (object2 == null) {
            throw new Exception("failed to get module interface");
        }
        object = ModuleLoadUtils.exeMethod(object2, string3, objectArray);
        return object;
    }

    @Override
    public boolean setParameter(String string, Object object) {
        String[] stringArray = this.getFieldInfos(string);
        if (stringArray[0] == null || stringArray[1] == null) {
            return false;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string2.equals("static")) {
            ModuleLoadUtils.setField(this.getLinkInfoMap().get(string4), string3, object);
            return true;
        }
        Object object2 = this.loadModule(string4);
        if (object2 == null) {
            throw new Exception("failed to get module interface");
        }
        ModuleLoadUtils.setField(object2, string3, object);
        return true;
    }

    private String[] getFieldInfos(String string) {
        String string2 = null;
        String string3 = null;
        if (this.getClazzs().length() == 0 || TextUtils.isEmpty((CharSequence)string)) {
            throw new Exception(" no marked functions !!!");
        }
        String string4 = null;
        for (int i2 = 0; i2 < this.getFields().length(); ++i2) {
            JSONArray jSONArray = new JSONArray(this.getFields().get(i2).toString());
            if (!jSONArray.optString(0).equals(string)) continue;
            string3 = jSONArray.optString(1);
            string2 = jSONArray.optString(2);
            string4 = jSONArray.optString(3);
            break;
        }
        if (TextUtils.isEmpty(string4)) {
            throw new Exception(" the function does not exist  !!!");
        }
        return new String[]{string2, string3, string4};
    }

    @Override
    public Object getParameter(String string) {
        String[] stringArray = this.getFieldInfos(string);
        if (stringArray[0] == null || stringArray[1] == null) {
            return false;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string2.equals("static")) {
            return ModuleLoadUtils.getStaticField(this.getLinkInfoMap().get(string4), string3);
        }
        Object object = this.loadModule(string4);
        if (object == null) {
            throw new Exception("failed to get module interface");
        }
        return ModuleLoadUtils.getField(object, string3);
    }

    @Override
    public boolean hotFix(String string) {
        return false;
    }

    @Override
    public boolean hotFix(String string, String string2) {
        return false;
    }

    @Override
    public void removeObjOfMemory(String string) {
        Object object = this.removeCache(string);
        if (object != null) {
            // empty if block
        }
    }
}

