/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.dlna;

import android.text.TextUtils;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.device.DeviceChangeListener;
import com.hpplay.cybergarage.xml.Node;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DLNABrowseController {
    private static final String TAG = "DLNABrowseController";
    private static final String LELINK_NODE_KEY = "LELINKFT";
    private static final String LELINK_SERVICE_TYPE = "urn:upnp-org:serviceId:RenderingControl";
    private static final String MEDIA_RENDER = "urn:schemas-upnp-org:device:MediaRenderer:1";
    private ControlPoint mControlPoint;
    private IBrowseResultListener mBrowseListener;
    private String mSsdp;
    DeviceChangeListener deviceChangeListener = new DeviceChangeListener(){

        @Override
        public void deviceAdded(int n2, Device device) {
            CLog.i(DLNABrowseController.TAG, "error code " + n2);
        }

        @Override
        public void deviceAdded(Device device) {
            if (!DLNABrowseController.isMediaRenderDevice(device)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)device.getLocation())) {
                Node node;
                DLNABrowseController.this.resolveDevice(device);
                Service service = device.getService(DLNABrowseController.LELINK_SERVICE_TYPE);
                if (service != null && (node = service.getServiceNode()) != null) {
                    Node node2 = node.getNode(DLNABrowseController.LELINK_NODE_KEY);
                    String string = null;
                    if (node2 != null) {
                        string = node2.getValue();
                    }
                    try {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = DLNABrowseController.this.parseLelinkInfo(device);
                            if (DLNABrowseController.this.mBrowseListener != null && !TextUtils.isEmpty((CharSequence)string)) {
                                DLNABrowseController.this.mBrowseListener.onBrowseResultCallback(2, string);
                            }
                        }
                    }
                    catch (Exception exception) {
                        CLog.w(DLNABrowseController.TAG, exception);
                    }
                }
            }
        }

        @Override
        public void deviceRemoved(Device device) {
        }
    };

    public void startBrowse() {
        CLog.i(TAG, "start browse");
        if (this.mControlPoint != null) {
            this.stopBrowse();
        }
        this.mControlPoint = new ControlPoint("");
        this.mControlPoint.addDeviceChangeListener(this.deviceChangeListener);
        if (this.mControlPoint != null) {
            this.mControlPoint.start();
        }
    }

    public void search() {
        CLog.i(TAG, "start search " + (this.mControlPoint == null));
        if (this.mControlPoint != null) {
            this.mControlPoint.search();
        }
    }

    public void setBrowseListener(IBrowseResultListener iBrowseResultListener) {
        CLog.i(TAG, "setBrowseListener " + (iBrowseResultListener == null));
        this.mBrowseListener = iBrowseResultListener;
    }

    public String getErrorMsg() {
        this.getSsdp();
        return this.mSsdp;
    }

    public void stopBrowse() {
        CLog.i(TAG, "stop browse");
        if (this.mControlPoint != null) {
            this.mControlPoint.stopSearch();
            this.mControlPoint.stop();
            this.getSsdp();
            this.mControlPoint = null;
        }
    }

    private synchronized void getSsdp() {
        try {
            HashSet<String> hashSet;
            if (this.mControlPoint != null && (hashSet = this.mControlPoint.getSsdps()).size() > 0) {
                for (String string : hashSet) {
                    this.mSsdp = this.mSsdp + string;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private String parseLelinkInfo(Device device) {
        String string = device.getURLBase();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            String string2 = string + "/dlna/Render/dmr_extra.xml";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string2);
            NodeList nodeList = document.getElementsByTagName(LELINK_NODE_KEY);
            org.w3c.dom.Node node = nodeList.item(0);
            return node.getTextContent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void resolveDevice(Device device) {
        JSONObject jSONObject = new JSONObject();
        String string = device.getUid();
        try {
            String string2 = device.getLocation();
            jSONObject.put("u", (Object)string);
            jSONObject.put("devicename", (Object)device.getFriendlyName());
            jSONObject.put("deviceip", (Object)HTTP.getHost(string2));
            jSONObject.put("port", HTTP.getPort(string2));
            jSONObject.put("dlna_mode_desc", (Object)string2);
            jSONObject.put("dlna_manufacturer", (Object)device.getManufacture());
            jSONObject.put("dlna_manufacturer_url", (Object)device.getManufactureURL());
            jSONObject.put("dlna_model_name", (Object)device.getModelName());
            jSONObject.put("dlna_model_url", (Object)device.getModelURL());
            jSONObject.put("dlna_model_description", (Object)device.getModelDescription());
            jSONObject.put("dlna_model_uuid", (Object)device.getUUID());
            jSONObject.put("udn_uuid", (Object)device.getUDN());
            if (device.getDrainage() != null) {
                jSONObject.put("drainage", (Object)device.getDrainage());
            }
            if (device.getSSDPPacket() != null && device.getSSDPPacket().getData() != null) {
                jSONObject.put("ssdp_packet_data", (Object)new String(device.getSSDPPacket().getData()));
            }
            if (this.mBrowseListener != null) {
                this.mBrowseListener.onBrowseResultCallback(1, jSONObject);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private static boolean isMediaRenderDevice(Device device) {
        return device != null && MEDIA_RENDER.equalsIgnoreCase(device.getDeviceType());
    }
}

