/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.browse;

import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.sdk.source.mdns.Browse;
import com.hpplay.sdk.source.mdns.DNSSDListener;
import com.hpplay.sdk.source.mdns.ServiceInstance;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.json.JSONObject;

public class MDNSBrowse {
    public static final String TAG = "MDNSBrowse";
    private static final String LELINK_DNS_TYPE = "_leboremote._tcp.local.";
    private IBrowseResultListener mListener;
    private Browse mBrowse;

    public void startBrowse(IBrowseResultListener iBrowseResultListener) {
        try {
            this.mListener = iBrowseResultListener;
            if (this.mBrowse == null) {
                CLog.i(TAG, "create new mdns service");
                this.mBrowse = new Browse(LELINK_DNS_TYPE);
            } else {
                CLog.i(TAG, "use old mdns service");
            }
            this.mBrowse.start(new MDNSListener(this.mListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void release() {
        this.mdnsClose();
        if (null != this.mListener) {
            this.mListener = null;
        }
    }

    private void mdnsClose() {
        try {
            if (this.mBrowse != null) {
                this.mBrowse.close();
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        this.mBrowse = null;
    }

    public String getErrorMsg() {
        if (this.mBrowse != null) {
            return this.mBrowse.getErrorMsg();
        }
        return null;
    }

    private class MDNSListener
    implements DNSSDListener {
        private IBrowseResultListener mListener;

        private MDNSListener(IBrowseResultListener iBrowseResultListener) {
            this.mListener = iBrowseResultListener;
        }

        @Override
        public void handleException(Object object, Exception exception) {
            if (!(exception instanceof IOException) || !"no route to host".equalsIgnoreCase(exception.getMessage())) {
                CLog.w(MDNSBrowse.TAG, exception);
                MDNSBrowse.this.release();
            }
        }

        @Override
        public void receiveMessage(Object object, Message message) {
        }

        @Override
        public void serviceDiscovered(Object object, ServiceInstance serviceInstance) {
            Map map = serviceInstance.getTextAttributes();
            if (map == null) {
                return;
            }
            if (this.mListener != null) {
                try {
                    JSONObject jSONObject = new JSONObject(map);
                    jSONObject.put("devicename", (Object)serviceInstance.getName().getInstance());
                    InetAddress[] inetAddressArray = serviceInstance.getAddresses();
                    jSONObject.put("deviceip", (Object)inetAddressArray[0].getHostAddress());
                    CLog.i(MDNSBrowse.TAG, serviceInstance.getName().getInstance());
                    this.mListener.onBrowseResultCallback(2, jSONObject);
                }
                catch (Exception exception) {
                    CLog.w(MDNSBrowse.TAG, exception);
                }
            }
        }

        @Override
        public void serviceRemoved(Object object, ServiceInstance serviceInstance) {
            CLog.d(MDNSBrowse.TAG, "Service Removed - " + serviceInstance);
        }
    }
}

