/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.browse;

import com.hpplay.component.common.utils.CLog;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.json.JSONException;
import org.json.JSONObject;

public class LelinkBrowseCore {
    private static final String TAG = "LelinkBrowseCore";
    public DatagramSocket mBrowseBroadCast;
    public DatagramSocket mBrowseServSocket;
    private static final int DATA_PACKET_LENGTH = 256;
    private static byte[] data = new byte[256];
    private static final int[] BROWSE_PORTS = new int[]{15353, 25353, 35353, 45353, 55353};
    public static final int BROWSE_PORT = 25353;
    private static final int RECEIVE_DATA_PACKET_LENGTH = 2048;
    private static byte[] rcData = new byte[2048];
    private DatagramPacket mBrowsePacket = new DatagramPacket(data, 256);
    public DatagramPacket mReceiverPacket = new DatagramPacket(rcData, 2048);
    private String BROWSE_MAGIC_NUM_KEY = "magic-number:";
    private String BROWSE_XOR_KEY = "xor-key:";
    public String mBrowseProtocol = "";
    public static final String CRLF = "\r\n";
    public static final String BROADCAST_IP_NAME = "255.255.255.255";

    public boolean createUDPServer() {
        try {
            this.mBrowseServSocket = new DatagramSocket(null);
            this.mBrowseServSocket.setReuseAddress(true);
            this.mBrowseServSocket.bind(new InetSocketAddress(25353));
            return true;
        }
        catch (SocketException socketException) {
            CLog.w(TAG, socketException);
            return false;
        }
    }

    public void sendBrowseData(int n2) {
        try {
            if (this.mBrowseBroadCast == null) {
                this.createBroadCast();
            }
            this.mBrowseProtocol = "";
            this.setBrowseMgcNum("PTBL");
            this.setBrowseXorkey("0000");
            this.setBrowseInfo("search", String.valueOf(31899), "", "");
            CLog.i(TAG, this.mBrowseProtocol);
            byte[] byArray = this.mBrowseProtocol.getBytes();
            this.mBrowsePacket.setPort(n2);
            this.mBrowsePacket.setAddress(InetAddress.getByName(BROADCAST_IP_NAME));
            this.mBrowsePacket.setData(byArray);
            this.mBrowsePacket.setLength(byArray.length);
            this.mBrowseBroadCast.send(this.mBrowsePacket);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void setBrowseMgcNum(String string) {
        this.mBrowseProtocol = this.mBrowseProtocol + this.BROWSE_MAGIC_NUM_KEY + string + CRLF;
    }

    public void setBrowseXorkey(String string) {
        this.mBrowseProtocol = this.mBrowseProtocol + this.BROWSE_XOR_KEY + string + CRLF;
    }

    public void setBrowseInfo(String string, String string2, String string3, String string4) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)string);
            jSONObject.put("ver", (Object)string2);
            jSONObject.put("sign", (Object)string3);
            jSONObject.put("md5", (Object)string4);
            this.mBrowseProtocol = this.mBrowseProtocol + jSONObject.toString();
        }
        catch (JSONException jSONException) {
            CLog.w("setBrowseInfo", jSONException);
        }
    }

    public void closeBrowseBroadCast() {
        if (this.mBrowseBroadCast != null) {
            this.mBrowseBroadCast.close();
        }
    }

    public boolean createBroadCast() {
        try {
            this.mBrowseBroadCast = new DatagramSocket(null);
            this.mBrowseBroadCast.setBroadcast(true);
            return true;
        }
        catch (SocketException socketException) {
            CLog.w(TAG, socketException);
            return false;
        }
    }
}

