/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.tony.bluetoothunityapi.BluetoothDeviceAddress;
import com.tony.bluetoothunityapi.BluetoothEventListener;
import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.ScanResultBluetoothDevice;
import com.tony.bluetoothunityapi.ble.BluetoothHelperCharacteristic;
import com.tony.bluetoothunityapi.ble.BluetoothHelperService;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;
import com.tony.bluetoothunityapi.transceiver.SocketTransceiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

@SuppressLint(value={"MissingPermission"})
public class ClassicBluetoothHelper
extends BluetoothHelper {
    private final UUID PORT_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothSocket socket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private boolean initializedIntent;
    private SocketTransceiver transceiver;
    private final List<BluetoothDeviceAddress> tempList;
    private final BroadcastReceiver stateChanged = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (device == null || ClassicBluetoothHelper.this.bt_device == null || !device.getAddress().equals(ClassicBluetoothHelper.this.bt_device.getAddress())) {
                return;
            }
            Log.d((String)"BluetoothAPI", (String)("State Changed! " + action));
            if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                Log.d((String)"BluetoothAPI", (String)"DISCONNECTED");
            }
            ClassicBluetoothHelper.this.invokeOnConnectionFailed();
            ClassicBluetoothHelper.this.connected = false;
        }
    };
    private final BroadcastReceiver bReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.d((String)"BluetoothAPI", (String)("action [" + action + "]"));
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (device != null) {
                    short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)Short.MIN_VALUE);
                    BluetoothDeviceAddress dev = new BluetoothDeviceAddress(device.getName(), device.getAddress(), rssi);
                    ClassicBluetoothHelper.this.tempList.add(dev);
                    Log.d((String)"BluetoothAPI", (String)("Found device [" + dev.getDeviceName() + "]"));
                } else {
                    Log.w((String)"BluetoothAPI", (String)"no device found");
                }
            }
        }
    };

    ClassicBluetoothHelper(Context context, String deviceName) {
        super(context, deviceName);
        this.tempList = new LinkedList<BluetoothDeviceAddress>();
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    @Override
    public void setOnDataReceivedListener(BluetoothEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    protected void BTinit() throws BluetoothHelper.BluetoothHelperException {
        super.BTinit();
        this.initializedIntent = false;
        this.transceiver = new SocketTransceiver(this);
        this.searchForDevice();
    }

    @Override
    protected void searchForDevice() {
        this.devicePaired = false;
        this.device = null;
        if (this.deviceName == null && this.deviceAddress == null) {
            return;
        }
        if (this.bluetoothAdapter == null) {
            return;
        }
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        Log.d((String)"BluetoothAPI", (String)("Bonded devices [" + bondedDevices.size() + "]"));
        for (BluetoothDevice iterator : bondedDevices) {
            Log.d((String)"BluetoothAPI", (String)("Checking device [" + iterator.getName() + "] against [" + this.deviceName + "] [" + this.deviceAddress + "]"));
            if (this.deviceName != null) {
                if (!iterator.getName().equals(this.deviceName)) continue;
                this.bt_device = new ScanResultBluetoothDevice(iterator, 0);
                this.devicePaired = true;
                break;
            }
            if (!iterator.getAddress().equals(this.deviceAddress)) continue;
            this.bt_device = new ScanResultBluetoothDevice(iterator, 0);
            this.devicePaired = true;
            break;
        }
        Log.d((String)"BluetoothAPI", (String)("Device paired [" + this.devicePaired + "]"));
        if (this.devicePaired) {
            this.device = new BluetoothDeviceAddress(this.bt_device.getName(), this.bt_device.getAddress(), this.bt_device.getRssi());
        }
    }

    @Override
    public List<BluetoothDeviceAddress> getPairedDevicesList() {
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        ArrayList<BluetoothDeviceAddress> pairedDevices = new ArrayList<BluetoothDeviceAddress>();
        for (BluetoothDevice iterator : bondedDevices) {
            pairedDevices.add(new BluetoothDeviceAddress(iterator.getName(), iterator.getAddress(), 0));
        }
        return pairedDevices;
    }

    @Override
    public void setMtu(int mtu) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void subscribe(BluetoothHelperService service) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void subscribe(BluetoothHelperCharacteristic characteristic) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void unsubscribe(BluetoothHelperService service) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void unsubscribe(BluetoothHelperCharacteristic characteristic) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void writeCharacteristic(BluetoothHelperCharacteristic characteristic, byte[] value) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void readCharacteristic(BluetoothHelperCharacteristic characteristic) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void setTxCharacteristic(BluetoothHelperCharacteristic characteristic) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void setRxCharacteristic(BluetoothHelperCharacteristic characteristic) {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public List<BluetoothHelperService> getGattServices() {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public boolean scanNearbyDevices(int scanningTime) {
        Log.d((String)"BluetoothAPI", (String)"Scan to be started");
        if (isScanning) {
            return false;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            throw new BluetoothHelper.BlueToothNotEnabledException();
        }
        IntentFilter filter = new IntentFilter();
        this.tempList.clear();
        filter.addAction("android.bluetooth.device.action.FOUND");
        this.context.registerReceiver(this.bReceiver, filter);
        if (!this.bluetoothAdapter.startDiscovery()) {
            return false;
        }
        isScanning = true;
        Handler stopHandler = new Handler();
        stopHandler.postDelayed(() -> {
            Log.d((String)"BluetoothAPI", (String)("Scan completed [" + this.tempList.size() + "]"));
            this.bluetoothAdapter.cancelDiscovery();
            this.context.unregisterReceiver(this.bReceiver);
            isScanning = false;
            nearbyDevices.clear();
            nearbyDevices.addAll(this.tempList);
            this.invokeOnScanEnded();
        }, (long)scanningTime * 1000L);
        Log.d((String)"BluetoothAPI", (String)"Scan started");
        return true;
    }

    @Override
    public boolean scanNearbyDevices() {
        return this.scanNearbyDevices(8);
    }

    @Override
    public void connect() {
        if (this.isConnecting || this.connected) {
            return;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            throw new BluetoothHelper.BlueToothNotEnabledException();
        }
        if (!this.devicePaired) {
            throw new BluetoothHelper.BlueToothNotReadyException();
        }
        if (!this.initializedIntent) {
            this.initializedIntent = true;
            this.context.registerReceiver(this.stateChanged, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        }
        this.connected = false;
        this.isConnecting = true;
        Thread thread = new Thread(() -> {
            try {
                this.socket = this.bt_device.getBluetoothDevice().createRfcommSocketToServiceRecord(this.PORT_UUID);
                this.socket.connect();
                this.outputStream = this.socket.getOutputStream();
                this.inputStream = this.socket.getInputStream();
                this.invokeOnConnected();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothAPI", (String)e.getMessage());
                e.printStackTrace();
                try {
                    Class<?> clazz = this.bt_device.getBluetoothDevice().getClass();
                    Class[] paramTypes = new Class[]{Integer.TYPE};
                    Method m = clazz.getMethod("createRfcommSocket", paramTypes);
                    Object[] params = new Object[]{1};
                    this.socket = (BluetoothSocket)m.invoke((Object)this.bt_device.getBluetoothDevice(), params);
                    if (this.socket == null) {
                        this.invokeOnConnectionFailed();
                    } else {
                        this.socket.connect();
                        this.outputStream = this.socket.getOutputStream();
                        this.inputStream = this.socket.getInputStream();
                        this.invokeOnConnected();
                    }
                }
                catch (Exception ex) {
                    Log.e((String)"BluetoothAPI", (String)"Error", (Throwable)ex);
                    ex.printStackTrace();
                    this.invokeOnConnectionFailed();
                }
            }
            this.isConnecting = false;
        });
        thread.start();
    }

    @Override
    public void disconnect() {
        this.connected = false;
        try {
            if (this.streamManager != null) {
                this.streamManager.setStopThread(true);
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    public static void EnablePermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
                ((Activity)context).requestPermissions(new String[]{"android.permission.BLUETOOTH"}, 1);
            }
            if (context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
                ((Activity)context).requestPermissions(new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, 1);
            }
            if (context.checkSelfPermission("android.permission.BLUETOOTH_ADMIN") != 0) {
                ((Activity)context).requestPermissions(new String[]{"android.permission.BLUETOOTH_ADMIN"}, 1);
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public ITransceiver getTransceiver() {
        return this.transceiver;
    }

    @Override
    public void OnDeviceChosen(BluetoothDevice device) {
        Log.d((String)"BluetoothAPI", (String)"No implementation here");
    }

    @Override
    public boolean isBLE() {
        return false;
    }
}

