/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6.cli;

import android.annotation.TargetApi;
import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.ClientEvidenceRoutine;
import com.hpplay.component.protocol.srp6.SRP6ClientEvidenceContext;
import com.hpplay.component.protocol.srp6.SRP6ClientSession;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class ClientEvidenceRoutineImpl
implements ClientEvidenceRoutine {
    private final SRP6ClientSession srp6ClientSession;

    public ClientEvidenceRoutineImpl(SRP6ClientSession sRP6ClientSession) {
        this.srp6ClientSession = sRP6ClientSession;
    }

    @Override
    @TargetApi(value=19)
    public BigInteger computeClientEvidence(SRP6CryptoParams sRP6CryptoParams, SRP6ClientEvidenceContext sRP6ClientEvidenceContext) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(sRP6CryptoParams.H);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Could not locate requested algorithm", noSuchAlgorithmException);
        }
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(sRP6CryptoParams.N));
        byte[] byArray = messageDigest.digest();
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(sRP6CryptoParams.g));
        byte[] byArray2 = messageDigest.digest();
        byte[] byArray3 = ClientEvidenceRoutineImpl.xor(byArray, byArray2);
        messageDigest.update(sRP6ClientEvidenceContext.userID.getBytes(StandardCharsets.UTF_8));
        byte[] byArray4 = messageDigest.digest();
        messageDigest.update(byArray3);
        messageDigest.update(byArray4);
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(sRP6ClientEvidenceContext.s));
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(sRP6ClientEvidenceContext.A));
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(sRP6ClientEvidenceContext.B));
        messageDigest.update(this.srp6ClientSession.getSessionKeyHash());
        return new BigInteger(1, messageDigest.digest());
    }

    private static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
        return byArray3;
    }
}

