/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.BrowserResolver;
import com.hpplay.sdk.source.utils.CastUtil;
import java.util.ArrayList;
import java.util.List;

public class BrowserDispatcher
implements IBrowseListener {
    private static final String TAG = "IBrowserDispatcher";
    private final int WHAT_DELAY_NOTIFY_WITH_DLNA = 1;
    private final int DELAY_NOTIFY_WITH_DLNA = 2000;
    private long mBrowserTimeStamp = -1L;
    private boolean isOnlyNotifyLelink = false;
    private IBrowseListener mRetryIBrowseListener;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (BrowserDispatcher.this.hasLelink()) {
                        BrowserDispatcher.this.isOnlyNotifyLelink = true;
                        break;
                    }
                    BrowserDispatcher.this.isOnlyNotifyLelink = false;
                    SourceLog.i(BrowserDispatcher.TAG, "WHAT_DELAY_NOTIFY_ALL ");
                    if (BrowserDispatcher.this.mBrowserList.size() <= 0 || BrowserDispatcher.this.mOuterBrowseListener == null) break;
                    BrowserDispatcher.this.mOuterBrowseListener.onBrowse(1, BrowserDispatcher.this.mBrowserList);
                }
            }
            return false;
        }
    });
    private final List<LelinkServiceInfo> mBrowserList = new ArrayList<LelinkServiceInfo>();
    private IBrowseListener mOuterBrowseListener;

    public void browser() {
        this.mBrowserTimeStamp = System.currentTimeMillis();
        this.isOnlyNotifyLelink = Session.getInstance().isPreferLelink;
        if (Session.getInstance().isPreferLelink) {
            this.mHandler.sendEmptyMessageDelayed(1, 2000L);
        }
    }

    public void setRetryBrowseListener(IBrowseListener iBrowseListener) {
        this.mRetryIBrowseListener = iBrowseListener;
    }

    public void stopBrowser() {
        this.mHandler.removeMessages(1);
    }

    @Override
    public void onBrowse(int n2, List<LelinkServiceInfo> list) {
        BrowserResolver.updateServiceList(list);
        this.notifyBrowserResult(n2);
        if (this.mRetryIBrowseListener != null) {
            this.mRetryIBrowseListener.onBrowse(n2, list);
        }
    }

    public void setBrowseListener(IBrowseListener iBrowseListener) {
        this.mOuterBrowseListener = iBrowseListener;
    }

    private boolean hasLelink() {
        for (LelinkServiceInfo lelinkServiceInfo : this.mBrowserList) {
            if (!CastUtil.isSupportLelink(lelinkServiceInfo)) continue;
            return true;
        }
        return false;
    }

    public List<LelinkServiceInfo> getBrowserList() {
        return this.mBrowserList;
    }

    private void notifyBrowserResult(int n2) {
        if (this.mOuterBrowseListener != null) {
            List<LelinkServiceInfo> list = this.filterLelink();
            if (n2 == 1) {
                if (!list.isEmpty()) {
                    this.mHandler.removeMessages(1);
                    this.mOuterBrowseListener.onBrowse(n2, list);
                }
                return;
            }
            this.mHandler.removeMessages(1);
            this.mOuterBrowseListener.onBrowse(n2, list);
        }
    }

    private List<LelinkServiceInfo> filterLelink() {
        if (!this.isOnlyNotifyLelink) {
            return this.mBrowserList;
        }
        ArrayList<LelinkServiceInfo> arrayList = new ArrayList<LelinkServiceInfo>();
        for (LelinkServiceInfo lelinkServiceInfo : this.mBrowserList) {
            if (!CastUtil.isSupportLelink(lelinkServiceInfo)) continue;
            arrayList.add(lelinkServiceInfo);
        }
        return arrayList;
    }

    public void notifyBrowserSuccess() {
        this.notifyBrowserResult(1);
    }

    public void notifyBrowserStop() {
        if (this.mOuterBrowseListener != null) {
            this.mOuterBrowseListener.onBrowse(2, this.filterLelink());
        }
    }

    public void clearBrowserList() {
        if (this.mBrowserList != null) {
            this.mBrowserList.clear();
        }
        this.mRetryIBrowseListener = null;
    }
}

