/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass;

import android.text.TextUtils;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.cloud.RightsManager;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.SinkBean;
import com.hpplay.sdk.source.pass.bean.ConnectBean;
import com.hpplay.sdk.source.pass.bean.DescribeBean;
import com.hpplay.sdk.source.pass.bean.MirrorStateBean;
import com.hpplay.sdk.source.pass.bean.PassDecoderBean;
import com.hpplay.sdk.source.pass.bean.PassLeboBean;
import com.hpplay.sdk.source.pass.bean.PassThirdBean;
import com.hpplay.sdk.source.pass.bean.PlayerRateBean;
import com.hpplay.sdk.source.pass.bean.SinkKeyEventBean;
import com.hpplay.sdk.source.pass.bean.SinkTouchEventInfoBean;
import com.hpplay.sdk.source.pass.sinkkey.SinkKeyEventDispatcher;
import com.hpplay.sdk.source.process.CommonListenerWrapper;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.connect.ConnectBridge;
import com.hpplay.sdk.source.transceiver.IRemoteServerListener;
import com.hpplay.sdk.source.utils.Feature;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Parser {
    private static final String TAG = "Parser";
    private static Parser sInstance;
    private Map<String, SinkBean> mSinkMap = new HashMap<String, SinkBean>();
    private OnSinkTouchEventInfoListener mSinkTouchEventInfoListener;

    private Parser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Parser getInstance() {
        Class<Parser> clazz = Parser.class;
        synchronized (Parser.class) {
            if (sInstance == null) {
                sInstance = new Parser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setOnSinkTouchEventInfoListener(OnSinkTouchEventInfoListener onSinkTouchEventInfoListener) {
        this.mSinkTouchEventInfoListener = onSinkTouchEventInfoListener;
    }

    public void parseByNetCast(String string) {
        String[] stringArray = string.split("]]]]]L");
        DescribeBean describeBean = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            if (TextUtils.isEmpty((CharSequence)stringArray[i2]) || !stringArray[i2].startsWith("L[[[[[")) {
                SourceLog.w(TAG, "parseByNetCast invalid msg at " + i2);
                break;
            }
            if (i2 == 0) {
                string2 = stringArray[i2].substring("L[[[[[".length());
                describeBean = DescribeBean.formJson(string2);
                if (describeBean == null) {
                    SourceLog.w(TAG, "parseByNetCast describeBean failed");
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)describeBean.uid)) {
                    SourceLog.w(TAG, "parseByNetCast describeBean miss cuid");
                    break;
                }
                if (describeBean.handler == 1 || describeBean.handler == 2) continue;
                this.sendErrorMessage(describeBean, 5, "wrong handler");
                break;
            }
            if (i2 != 1) continue;
            string2 = stringArray[i2].substring("L[[[[[".length());
            this.parse(2, describeBean, string2);
        }
    }

    public void parseByLocalCast(DescribeBean describeBean, String string) {
        if (describeBean == null || TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "parseByLocalCast invalid input");
            return;
        }
        this.parse(1, describeBean, string);
    }

    private void parse(int n2, DescribeBean describeBean, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "parse invalid input");
            return;
        }
        if (describeBean == null) {
            SourceLog.w(TAG, "parse describeBean failed");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)describeBean.uid)) {
            SourceLog.w(TAG, "parse describeBean miss uid");
            return;
        }
        if (describeBean.handler != 1 && describeBean.handler != 2) {
            SourceLog.w(TAG, "parse describeBean invalid handler");
            return;
        }
        SourceLog.i(TAG, "parse ");
        if (describeBean.handler == 2) {
            this.handleSDKMessage(n2, describeBean, string);
        } else {
            this.handleAPPMessage(n2, describeBean, string);
        }
    }

    private void handleSDKMessage(int n2, DescribeBean describeBean, String string) {
        if (describeBean == null || TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "handleSDKMessage invalid input");
            return;
        }
        int n3 = -1;
        String string2 = null;
        SinkBean sinkBean = this.getSinkBean(describeBean.uid);
        switch (describeBean.manifestType) {
            case -1: {
                this.handleErrorMessage(describeBean, string);
                break;
            }
            case 4: {
                sinkBean.connectBean = ConnectBean.formJson(string);
                ConnectBridge connectBridge = ConnectManager.getInstance().getConnectBridge(describeBean.uid);
                if (connectBridge != null && sinkBean.connectBean != null) {
                    connectBridge.setSinkSM(sinkBean.connectBean.sm);
                    connectBridge.saveConnectBean(string);
                }
                SourceLog.i(TAG, "handleSDKMessage parse receive connect ");
                if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener == null) break;
                LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(describeBean.manifestType, string);
                break;
            }
            case 16: {
                PlayerRateBean playerRateBean = PlayerRateBean.formJson(string);
                if (playerRateBean == null) {
                    SourceLog.i(TAG, "handleSDKMessage parse MANIFEST_RATE_QUERY_REPLY ignore ");
                    break;
                }
                SourceLog.i(TAG, "handleSDKMessage parse MANIFEST_RATE_QUERY_REPLY " + playerRateBean.rate);
                if (BusinessEntity.getInstance().getListenerDispatcher() == null) break;
                BusinessEntity.getInstance().getListenerDispatcher().onInfo(null, 16, String.valueOf(playerRateBean.rate));
                break;
            }
            case 14: {
                sinkBean.decoderBean = PassDecoderBean.formJson(string);
                break;
            }
            case 26: {
                SourceLog.i(TAG, "handleSDKMessage parse mirror state");
                MirrorStateBean mirrorStateBean = MirrorStateBean.fromJson(string);
                if (mirrorStateBean == null) {
                    SourceLog.i(TAG, "handleSDKMessage parse mirror state failed");
                    return;
                }
                ConnectManager.getInstance().getLastConnectBridge().notifyPassReceivedData(describeBean.manifestType, mirrorStateBean);
                break;
            }
            case 29: {
                SinkKeyEventBean sinkKeyEventBean = SinkKeyEventBean.fromJson(string);
                if (sinkKeyEventBean == null) {
                    SourceLog.w(TAG, "handleSDKMessage: sinkKeyEventBean is null");
                    break;
                }
                SourceLog.i(TAG, "handleAPPMessage: sinkKeyEventBean keyCode: " + sinkKeyEventBean.keyCode + " action: " + sinkKeyEventBean.action);
                SinkKeyEventDispatcher.getInstance().handleEvent(sinkKeyEventBean.keyCode, sinkKeyEventBean.action);
                break;
            }
            case 11: {
                SinkTouchEventInfoBean sinkTouchEventInfoBean = SinkTouchEventInfoBean.fromJson(string);
                if (sinkTouchEventInfoBean == null) {
                    SourceLog.w(TAG, "handleSDKMessage: sinkTouchEventInfoBean is null");
                } else {
                    ConnectBridge connectBridge = ConnectManager.getInstance().getConnectBridge(describeBean.uid);
                    if (connectBridge != null && connectBridge.getServiceInfo() != null && !TextUtils.isEmpty((CharSequence)connectBridge.getServiceInfo().getIp())) {
                        sinkTouchEventInfoBean.ip = connectBridge.getServiceInfo().getIp();
                    }
                    SourceLog.i(TAG, "handleSDKMessage: sinkTouchEventInfoBean : " + sinkTouchEventInfoBean.toString());
                    sinkBean.sinkTouchEventInfoBean = sinkTouchEventInfoBean;
                }
                if (this.mSinkTouchEventInfoListener == null) break;
                this.mSinkTouchEventInfoListener.onInfo(sinkTouchEventInfoBean);
                break;
            }
            case 100: {
                SourceLog.i(TAG, "handleSDKMessage sdk pass lebo msg ignore");
                break;
            }
            case 10000: {
                SourceLog.w(TAG, "handleSDKMessage parse pass msg ignore");
                break;
            }
            case 34: {
                if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener == null) break;
                LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(describeBean.manifestType, string);
                break;
            }
            case 37: {
                PlayerRateBean playerRateBean = PlayerRateBean.formJson(string);
                if (playerRateBean == null) {
                    SourceLog.i(TAG, "handleSDKMessage parse MANIFEST_RATE_UPDATE ignore ");
                    break;
                }
                SourceLog.i(TAG, "handleSDKMessage parse MANIFEST_RATE_UPDATE " + playerRateBean.rate);
                if (BusinessEntity.getInstance().getListenerDispatcher() == null) break;
                BusinessEntity.getInstance().getListenerDispatcher().onInfo(null, 37, String.valueOf(playerRateBean.rate));
                break;
            }
            case 38: {
                break;
            }
            case 40: {
                IRemoteServerListener iRemoteServerListener = CommonListenerWrapper.getInstance().getRemoteServerListener();
                SourceLog.w(TAG, "MANIFEST_NOTIFY_REMOTE_REPLAY " + iRemoteServerListener);
                if (iRemoteServerListener == null) break;
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    int n4 = jSONObject.optInt("result");
                    if (n4 == 1) {
                        iRemoteServerListener.onServerStarted(jSONObject.optInt("port"));
                        break;
                    }
                    iRemoteServerListener.onServerFailed(n4);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            default: {
                SourceLog.w(TAG, "handleSDKMessage parse nonsupport msg type: " + describeBean.manifestType);
                n3 = 1;
                string2 = "Nonsupport message";
            }
        }
        this.mSinkMap.put(describeBean.uid, sinkBean);
        if (n3 > 0 && !TextUtils.isEmpty(string2)) {
            this.sendErrorMessage(describeBean, n3, string2);
        }
    }

    private void handleAPPMessage(int n2, DescribeBean describeBean, String string) {
        if (describeBean == null || TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "handleAPPMessage invalid input");
            return;
        }
        int n3 = -1;
        String string2 = null;
        switch (describeBean.manifestType) {
            case -1: {
                this.handleErrorMessage(describeBean, string);
                break;
            }
            case 23: {
                if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener != null) {
                    LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(describeBean.manifestType, string);
                }
                RightsManager.getInstance().handleRightMessage(describeBean.uid, string);
                break;
            }
            case 100: {
                if (!Feature.isLeboApp()) {
                    SourceLog.i(TAG, "MANIFEST_PASS_LEBO ignore,not lebo app");
                    break;
                }
                PassLeboBean passLeboBean = PassLeboBean.formJSON(string);
                if (passLeboBean == null) {
                    SourceLog.w(TAG, "handleAPPMessage, parse pass lebo failed");
                    n3 = 2;
                    string2 = "parse pass lebo failed";
                    break;
                }
                if (passLeboBean.data == null) {
                    SourceLog.w(TAG, "handleAPPMessage, parse pass lebo invalid data");
                    n3 = 3;
                    string2 = "parse pass lebo invalid data";
                    break;
                }
                if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener == null) break;
                LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(100, string);
                break;
            }
            case 10000: {
                PassThirdBean passThirdBean = PassThirdBean.formJSON(string);
                if (passThirdBean == null) {
                    SourceLog.w(TAG, "handleAPPMessage parse pass failed");
                    n3 = 2;
                    string2 = "parse pass failed";
                    break;
                }
                if (passThirdBean.data == null) {
                    SourceLog.w(TAG, "handleAPPMessage parse pass invalid data");
                    n3 = 3;
                    string2 = "parse pass invalid data";
                    break;
                }
                if (!TextUtils.equals((CharSequence)Session.getInstance().appKey, (CharSequence)passThirdBean.appID)) {
                    SourceLog.w(TAG, "handleAPPMessage parse pass unequal appID");
                    n3 = 4;
                    string2 = "wrong appID";
                    break;
                }
                SourceLog.w(TAG, "MANIFEST_PASS_THIRD " + LelinkSdkManager.getInstance().mOuterRelevantInfoListener);
                if (LelinkSdkManager.getInstance().mOuterRelevantInfoListener == null) break;
                LelinkSdkManager.getInstance().mOuterRelevantInfoListener.onReverseInfoResult(10000, string);
                break;
            }
            default: {
                SourceLog.w(TAG, "handleAPPMessage parse nonsupport msg type: " + describeBean.manifestType);
                n3 = 1;
                string2 = "Nonsupport message";
            }
        }
        if (n3 > 0 && !TextUtils.isEmpty(string2)) {
            this.sendErrorMessage(describeBean, n3, string2);
        }
    }

    public ConnectBean getConnectBean(String string) {
        SinkBean sinkBean = this.getSinkBean(string);
        if (sinkBean == null || sinkBean.connectBean == null) {
            return null;
        }
        return sinkBean.connectBean;
    }

    private void handleErrorMessage(DescribeBean describeBean, String string) {
        SourceLog.w(TAG, "handleErrorMessage " + string);
    }

    private void sendErrorMessage(DescribeBean describeBean, int n2, String string) {
        SourceLog.w(TAG, "sendErrorMessage " + string);
    }

    private SinkBean getSinkBean(String string) {
        SinkBean sinkBean = this.mSinkMap.get(string);
        if (sinkBean == null) {
            sinkBean = new SinkBean();
            sinkBean.uid = string;
        }
        return sinkBean;
    }

    public static interface OnSinkTouchEventInfoListener {
        public void onInfo(SinkTouchEventInfoBean var1);
    }
}

