/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class TXTBase
extends Record {
    private static final long serialVersionUID = -4319510507246305931L;
    protected List strings;

    protected TXTBase() {
    }

    protected TXTBase(Name name, int n2, int n3, long l2) {
        super(name, n2, n3, l2);
    }

    protected TXTBase(Name name, int n2, int n3, long l2, List list) {
        super(name, n2, n3, l2);
        if (list == null) {
            throw new IllegalArgumentException("strings must not be null");
        }
        this.strings = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.strings.add(TXTBase.byteArrayFromString(string));
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    protected TXTBase(Name name, int n2, int n3, long l2, String string) {
        this(name, n2, n3, l2, Collections.singletonList(string));
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        this.strings = new ArrayList(2);
        while (dNSInput.remaining() > 0) {
            byte[] byArray = dNSInput.readCountedString();
            this.strings.add(byArray);
        }
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        Tokenizer.Token token;
        this.strings = new ArrayList(2);
        while ((token = tokenizer.get()).isString()) {
            try {
                this.strings.add(TXTBase.byteArrayFromString(token.value));
            }
            catch (Exception exception) {
                throw tokenizer.exception(exception.getMessage());
            }
        }
        tokenizer.unget();
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.strings.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            stringBuffer.append(TXTBase.byteArrayToString(byArray, true));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public List getStrings() {
        ArrayList<String> arrayList = new ArrayList<String>(this.strings.size());
        for (int i2 = 0; i2 < this.strings.size(); ++i2) {
            arrayList.add(TXTBase.byteArrayToString((byte[])this.strings.get(i2), false));
        }
        return arrayList;
    }

    public List getStringsAsByteArrays() {
        return this.strings;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        for (byte[] byArray : this.strings) {
            dNSOutput.writeCountedString(byArray);
        }
    }
}

