/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import java.net.InetAddress;

public final class ReverseMap {
    private static Name inaddr4 = Name.fromConstantString("in-addr.arpa.");
    private static Name inaddr6 = Name.fromConstantString("ip6.arpa.");

    private ReverseMap() {
    }

    public static Name fromAddress(byte[] byArray) {
        if (byArray.length != 4 && byArray.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length == 4) {
            for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
                stringBuffer.append(byArray[i2] & 0xFF);
                if (i2 <= 0) continue;
                stringBuffer.append(".");
            }
        } else {
            int[] nArray = new int[2];
            for (int i3 = byArray.length - 1; i3 >= 0; --i3) {
                nArray[0] = (byArray[i3] & 0xFF) >> 4;
                nArray[1] = byArray[i3] & 0xFF & 0xF;
                for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
                    stringBuffer.append(Integer.toHexString(nArray[i4]));
                    if (i3 <= 0 && i4 <= 0) continue;
                    stringBuffer.append(".");
                }
            }
        }
        try {
            return byArray.length == 4 ? Name.fromString(stringBuffer.toString(), inaddr4) : Name.fromString(stringBuffer.toString(), inaddr6);
        }
        catch (Exception exception) {
            throw new IllegalStateException("name cannot be invalid");
        }
    }

    public static Name fromAddress(InetAddress inetAddress) {
        return ReverseMap.fromAddress(inetAddress.getAddress());
    }
}

