/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.EDNSOption;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OPTRecord
extends Record {
    private static final long serialVersionUID = -6254521894809367938L;
    private List options;

    OPTRecord() {
    }

    @Override
    Record getObject() {
        return new OPTRecord();
    }

    public OPTRecord(int n2, int n3, int n4, int n5, List list) {
        super(Name.root, 41, n2, 0L);
        OPTRecord.checkU16("payloadSize", n2);
        OPTRecord.checkU8("xrcode", n3);
        OPTRecord.checkU8("version", n4);
        OPTRecord.checkU16("flags", n5);
        this.ttl = ((long)n3 << 24) + ((long)n4 << 16) + (long)n5;
        if (list != null) {
            this.options = new ArrayList(list);
        }
    }

    public OPTRecord(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null);
    }

    public OPTRecord(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, null);
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        if (dNSInput.remaining() > 0) {
            this.options = new ArrayList();
        }
        while (dNSInput.remaining() > 0) {
            EDNSOption eDNSOption = EDNSOption.fromWire(dNSInput);
            this.options.add(eDNSOption);
        }
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        throw tokenizer.exception("no text format defined for OPT");
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.options != null) {
            stringBuffer.append(this.options);
            stringBuffer.append(" ");
        }
        stringBuffer.append(" ; payload ");
        stringBuffer.append(this.getPayloadSize());
        stringBuffer.append(", xrcode ");
        stringBuffer.append(this.getExtendedRcode());
        stringBuffer.append(", version ");
        stringBuffer.append(this.getVersion());
        stringBuffer.append(", flags ");
        stringBuffer.append(this.getFlags());
        return stringBuffer.toString();
    }

    public int getPayloadSize() {
        return this.dclass;
    }

    public int getExtendedRcode() {
        return (int)(this.ttl >>> 24);
    }

    public int getVersion() {
        return (int)(this.ttl >>> 16 & 0xFFL);
    }

    public int getFlags() {
        return (int)(this.ttl & 0xFFFFL);
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        if (this.options == null) {
            return;
        }
        for (EDNSOption eDNSOption : this.options) {
            eDNSOption.toWire(dNSOutput);
        }
    }

    public List getOptions() {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.options);
    }

    public List getOptions(int n2) {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EDNSOption> arrayList = Collections.EMPTY_LIST;
        for (EDNSOption eDNSOption : this.options) {
            if (eDNSOption.getCode() != n2) continue;
            if (arrayList == Collections.EMPTY_LIST) {
                arrayList = new ArrayList<EDNSOption>();
            }
            arrayList.add(eDNSOption);
        }
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.ttl == ((OPTRecord)object).ttl;
    }
}

