/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device.qr;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.common.utils.HttpEncrypt;
import com.hpplay.sdk.source.bean.ShortUrlBean;
import com.hpplay.sdk.source.browse.api.AuthListener;
import com.hpplay.sdk.source.browse.api.ICreateShortUrlListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.browse.data.LelinkServiceInfoCreator;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CreateUtil;
import com.hpplay.sdk.source.utils.Feature;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class QRCodeController {
    private final String TAG = "QRCodeController";
    private long startMarkTime = 0L;
    private IServiceInfoParseListener listener;
    private String plateForm;
    private String mConnectSession;
    private static final int WHAT_CALLBACK_IM = 1;
    private static final int DELAY_CALLBACK_IM = 500;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (message.obj == null) break;
                    QRCodeController.this.callbackIMFirst((LelinkServiceInfo)message.obj);
                }
            }
            return false;
        }
    });

    public void addQRCodeServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        this.startMarkTime = System.currentTimeMillis();
        this.mConnectSession = CreateUtil.createSessionId();
        SourceDataReport.getInstance().onQRScanStart(this.mConnectSession);
        this.QRCodeParseCheck(string, iServiceInfoParseListener);
    }

    private void QRCodeParseCheck(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        this.listener = iServiceInfoParseListener;
        if (null == this.listener) {
            SourceLog.i("QRCodeController", "addQRCodeServiceInfo ParceQRCodeListener listener is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i("QRCodeController", "addQRCodeServiceInfo qrCodeStr is empty");
            this.callbackToApp(0, null);
            return;
        }
        SourceLog.i("QRCodeController", "addQRCodeServiceInfo qrCodeStr:" + string);
        if (!string.contains("ip=") && !string.contains("remotePort=")) {
            SourceLog.i("QRCodeController", "addQRCodeServiceInfo split length less than 2");
            this.requestShortUrlForServer(string, this.listener);
            return;
        }
        int n2 = string.indexOf("?");
        String string2 = string.substring(n2 + 1, string.length());
        Map<String, String> map = this.getUrlParams(string2);
        if (null == map) {
            SourceLog.i("QRCodeController", "addQRCodeServiceInfo getUrlParams is empty");
            this.requestShortUrlForServer(string, this.listener);
            return;
        }
        String string3 = map.get("remotePort");
        String string4 = map.get("ip");
        String string5 = map.get("cname");
        String string6 = map.get("deviceName");
        this.plateForm = map.get("platform");
        if (TextUtils.isEmpty((CharSequence)string4) || TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string5) || TextUtils.isEmpty((CharSequence)string6)) {
            SourceLog.i("QRCodeController", "addQRCodeServiceInfo ip or remotePort is empty");
            this.requestShortUrlForServer(string, this.listener);
            return;
        }
        try {
            string6 = URLDecoder.decode(string6, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w("QRCodeController", exception);
        }
        this.delayCallbackIM(LelinkServiceInfoCreator.getQRCodeInfo(string2));
        this.requestLelinkTxtInfo(string5, string6, string4, string3, string2);
    }

    private void requestLelinkTxtInfo(final String string, final String string2, final String string3, final String string4, final String string5) {
        String string6 = CloudAPI.getHttpServerUrl(string3, string4);
        SourceLog.i("QRCodeController", "infoUlr" + string6);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string6, null);
        asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(2L);
        asyncHttpParameter.in.tryCount = 1;
        long l2 = System.currentTimeMillis();
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i("QRCodeController", "requestLelinkTxtInfo cancel");
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    String string6 = asyncHttpParameter.out.result;
                    SourceLog.debug("QRCodeController", "requestLelinkTxtInfo response:" + string6);
                    LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getLelinkTxtInfo(string, string2, string3, string4, QRCodeController.this.plateForm, string6, 2);
                    if (null != lelinkServiceInfo) {
                        QRCodeController.this.callbackToApp(1, lelinkServiceInfo);
                    } else {
                        if (Feature.isDisableIM()) {
                            QRCodeController.this.callbackToApp(5, null);
                            return;
                        }
                        if (Feature.isNubiaChannel()) {
                            QRCodeController.this.callbackToApp(5, null);
                        } else {
                            QRCodeController.this.callbackToApp(1, LelinkServiceInfoCreator.getQRCodeInfo(string5));
                        }
                    }
                } else {
                    SourceLog.i("QRCodeController", "requestLelinkTxtInfo failed");
                    if (Feature.isDisableIM()) {
                        QRCodeController.this.callbackToApp(5, null);
                    }
                }
            }
        });
    }

    private void callbackToApp(int n2, LelinkServiceInfo lelinkServiceInfo) {
        this.mHandler.removeMessages(1);
        if (null != this.listener) {
            this.listener.onParseResult(n2, lelinkServiceInfo);
        }
        SourceDataReport.getInstance().onQRScanEnd(lelinkServiceInfo, this.mConnectSession, n2, System.currentTimeMillis() - this.startMarkTime);
    }

    private void requestShortUrlForServer(final String string, final IServiceInfoParseListener iServiceInfoParseListener) {
        if (TextUtils.isEmpty((CharSequence)a.a())) {
            AuthSDK.getInstance().addAuthListener(new AuthListener(){

                @Override
                public void onAuthSuccess(String string3, String string2) {
                    AuthSDK.getInstance().removeListener(this);
                    QRCodeController.this.parseQRCodeforServer(string, iServiceInfoParseListener);
                }

                @Override
                public void onAuthFailed(int n2) {
                    AuthSDK.getInstance().removeListener(this);
                }
            });
            AuthSDK.getInstance().authSDKByInvalidToken();
            return;
        }
        this.parseQRCodeforServer(string, iServiceInfoParseListener);
    }

    private void parseQRCodeforServer(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("appid", Session.getInstance().appKey);
        hashMap.put("uid", Session.getInstance().getUID());
        hashMap.put("token", a.a());
        hashMap.put("shortUrl", string);
        hashMap.put("ver", "2.0");
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sParseQRInfoUrl, HapplayUtils.getJsonParams(hashMap));
        SourceLog.i("QRCodeController", "request params=" + HapplayUtils.getJsonParams(hashMap));
        asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(2L);
        asyncHttpParameter.in.tryCount = 2;
        asyncHttpParameter.in.requestMethod = 1;
        SourceLog.i("QRCodeController", "parseQRCodeforServer url:" + CloudAPI.sParseQRInfoUrl + " params:" + HapplayUtils.getJsonParams(hashMap));
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i("QRCodeController", "parseQRCodeforServer cancel");
                    return;
                }
                SourceLog.debug("QRCodeController", "parseQRCodeforServer  : " + asyncHttpParameter.out.result);
                if (asyncHttpParameter.out.resultType == 0) {
                    QRCodeController.this.parseLongUrl(asyncHttpParameter.out.result);
                } else {
                    SourceLog.w("QRCodeController", "parseQRCodeforServer  : " + asyncHttpParameter.out.result);
                    if (!TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result) && asyncHttpParameter.out.result.contains("411")) {
                        QRCodeController.this.callbackToApp(4, null);
                    } else if (TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                        QRCodeController.this.callbackToApp(5, null);
                    } else {
                        QRCodeController.this.callbackToApp(5, null);
                    }
                }
            }
        });
    }

    private void parseLongUrl(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            int n2 = jSONObject.optInt("status");
            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
            if (n2 == 200 && null != jSONObject2) {
                String string2 = jSONObject2.optString("url");
                this.QRCodeParseCheck(string2, this.listener);
            } else {
                SourceLog.i("QRCodeController", "addQRCodeServiceInfo status not 200 or data is null");
                this.callbackToApp(4, null);
            }
        }
        catch (Exception exception) {
            SourceLog.i("QRCodeController", "addQRCodeServiceInfo not json");
            this.callbackToApp(5, null);
        }
    }

    public void requestShortUrl(final ICreateShortUrlListener iCreateShortUrlListener) {
        if (iCreateShortUrlListener == null) {
            SourceLog.w("QRCodeController", "requestShortUrl,value is invalid");
            return;
        }
        String string = "http://hpplay.cdn.cibn.cc/release/out/weixin.html?" + this.getShortUrlParameter();
        String string2 = this.getQrAsyncHttpParameter(string);
        final HttpEncrypt httpEncrypt = new HttpEncrypt();
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sCreateShortUrl, httpEncrypt.encode(string2));
        asyncHttpParameter.in.requestMethod = 1;
        asyncHttpParameter.in.requestHeaders = httpEncrypt.buildHeader();
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                SourceLog.debug("QRCodeController", "requestShortUrl onRequestResult:" + asyncHttpParameter.out);
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.w("QRCodeController", "requestShortUrl cancel request");
                    return;
                }
                ShortUrlBean shortUrlBean = null;
                if (asyncHttpParameter.out.result != null) {
                    try {
                        String string = httpEncrypt.decode(asyncHttpParameter.out);
                        shortUrlBean = new ShortUrlBean(new JSONObject(string));
                    }
                    catch (Exception exception) {
                        SourceLog.w("QRCodeController", exception);
                    }
                }
                if (shortUrlBean != null) {
                    if (shortUrlBean.status == 200 && shortUrlBean.data != null && !TextUtils.isEmpty((CharSequence)shortUrlBean.data.shorturl)) {
                        SourceLog.i("QRCodeController", "requestShortUrl callback shortUrl to caller");
                        if (iCreateShortUrlListener != null) {
                            iCreateShortUrlListener.onCreateShortUrl(shortUrlBean.data.shorturl);
                            return;
                        }
                    } else if (shortUrlBean.status == 401 || shortUrlBean.status == 410) {
                        AuthSDK.getInstance().authSDKByInvalidToken();
                        return;
                    }
                }
                if (iCreateShortUrlListener != null) {
                    iCreateShortUrlListener.onCreateShortUrl(null);
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private String getShortUrlParameter() {
        Session session = Session.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("a=" + session.appKey);
        stringBuilder.append("&cname=" + session.getUID());
        stringBuilder.append("&tc=" + session.serverPort);
        stringBuilder.append("&remotePort=" + session.serverPort);
        stringBuilder.append("&ip=" + HapplayUtils.getLoaclIp());
        stringBuilder.append("&ver=2.0");
        stringBuilder.append("&").append(FieldUtil.getString(FieldUtil.m)).append("=").append("02:00:00:00:00:00");
        stringBuilder.append("&hid=" + session.getHID());
        return stringBuilder.toString();
    }

    private String getQrAsyncHttpParameter(String string) {
        Session session = Session.getInstance();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", session.getUID());
        hashMap.put("appid", session.appKey);
        hashMap.put("token", a.a());
        try {
            hashMap.put("url", URLEncoder.encode(string, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SourceLog.w("QRCodeController", unsupportedEncodingException);
        }
        hashMap.put("t", String.valueOf(TimeUnit.HOURS.toSeconds(session.mExpireTime)));
        hashMap.put("sdk_ver", String.valueOf(41201));
        String string2 = HapplayUtils.getMapParams(hashMap);
        SourceLog.i("QRCodeController", "getQrAsyncHttpParameter: " + CloudAPI.sCreateShortUrl + string2);
        return string2;
    }

    private Map<String, String> getUrlParams(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    private void delayCallbackIM(LelinkServiceInfo lelinkServiceInfo) {
        if (Feature.isDisableIM()) {
            return;
        }
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, (Object)lelinkServiceInfo), 500L);
    }

    private void callbackIMFirst(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return;
        }
        SourceLog.w("QRCodeController", "callbackIMFirst");
        try {
            if (lelinkServiceInfo.getBrowserInfos().size() > 1 && lelinkServiceInfo.getBrowserInfos().containsKey(4)) {
                lelinkServiceInfo.getBrowserInfos().remove(1);
            }
        }
        catch (Exception exception) {
            SourceLog.w("QRCodeController", exception);
        }
        if (!CastUtil.isSupportIM(lelinkServiceInfo)) {
            return;
        }
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4);
        if (browserInfo != null) {
            browserInfo.setOnLine(true);
        }
        this.callbackToApp(1, lelinkServiceInfo);
    }
}

