/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business.cloud;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.common.utils.FileUtil;
import com.hpplay.common.utils.HttpEncrypt;
import com.hpplay.component.common.utils.DeviceProperties;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.bean.AuthRepeatInfoBean;
import com.hpplay.sdk.source.browse.api.AuthListener;
import com.hpplay.sdk.source.business.cloud.AuthSDKBean;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.IMTask;
import com.hpplay.sdk.source.business.cloud.LicenseManager;
import com.hpplay.sdk.source.business.cloud.RightsManager;
import com.hpplay.sdk.source.business.cloud.SDKConfig;
import com.hpplay.sdk.source.business.cloud.ServListEntity;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.business.cloud.SwitchEntity;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.device.ServiceUpdater;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.LeboUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class AuthSDK {
    private static final String TAG = "AuthSDK";
    private static final String URL_SDK_AUTH = "sdkauth";
    private static final String URL_TYPE_REPORT = "report";
    private static final String URL_TYPE_GSLB = "gslb";
    private static final String URL_TYPE_AD_ENGINE = "adengine";
    private static final String URL_DEVICE_MANAGER = "devicemgr";
    private static final String URL_TYPE_IM_DNS = "imdns";
    private static final String URL_TYPE_PIN = "pin";
    private static final String URL_TYPE_SHORT_LINK = "shorturl";
    private static final String URL_TYPE_LOG_REPORT = "logreport";
    private static final String URL_TYPE_REPORT_SEARCH = "reportsearch";
    private static final String URL_IM_CONNECT = "im";
    private static final String URL_VIP_AUTH = "vipauth";
    private static final int AUTH_FAIL_RETRY_LIMIT = 180000;
    private static final int CODE_AUTH_DEFAULT = -100;
    public static final int CODE_AUTH_TIME_DONE = -101;
    public static final int CODE_AUTH_DISABLE = 402;
    private static final int CODE_AUTH_PARAM_ERROR = 401;
    private static final int CODE_AUTH_SER_ERROR = 405;
    private static final int MAX_RETRY_SER_ERROR = 3;
    private int mServerErrorCount = 0;
    private static final String AUTH_PARSE_ERROR = "120102034";
    private static final String AUTH_NETWORK_ERROR = "120102035";
    private static final String AUTH_DATA_ERROR = "120102036";
    private static final String REPEAT_INFO_FILE_DIR = Session.getInstance().getContextPath().getPath("sdcard_hpplay");
    public static final String REPEAT_INFO_FILE_NAME = REPEAT_INFO_FILE_DIR + File.separator + "lecast";
    private static final int AUTH_DEFAULT_TIME = 100;
    private static final int AUTH_DEFAULT_TIME_DEBUG = 10;
    private static final int SER_STATE_NOTFOUND = 404;
    private static final int SER_STATE_ERROR = 500;
    private static final int SER_STATE_FAILED = -1;
    private static AuthSDK mAuthSDK;
    private Context mContext;
    private AsyncTask mAuthTask;
    private List<String> mAuthUrlList = new ArrayList<String>();
    private int mAuthUrlIndex = 0;
    private List<AuthListener> mAuthListeners;
    private int mAuthStatusCode = -100;
    private boolean isHasIMConnectDomain = false;
    private static final int MAX_INVALID_TOKEN_COUNT = 3;
    private int mInvalidTokenCount = 0;

    public static synchronized AuthSDK getInstance() {
        if (mAuthSDK == null) {
            mAuthSDK = new AuthSDK();
        }
        return mAuthSDK;
    }

    public void init(Context context) {
        this.mContext = context;
        this.initAuthUrlList();
        String string = Preference.getInstance().get("sdk_verify", null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                AuthSDKBean authSDKBean = new AuthSDKBean(jSONObject);
                this.analysisVerifyData(authSDKBean);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, "AuthSDK preVerifyData parser error", exception);
            }
        } else {
            SourceLog.w(TAG, "AuthSDK preVerifyData is empty");
        }
        Session.getInstance().updateRepeatInfo(this.readRepeatInfoFromLocal());
    }

    private void initAuthUrlList() {
        this.mAuthUrlList.clear();
        if (Feature.isMUIChannel()) {
            this.mAuthUrlList.add("https://misdkauth.hpplay.cn/Author/PhoneAuthor/?");
            return;
        }
        if (Feature.isOPPOChannel()) {
            this.mAuthUrlList.add("https://vosdkauth.hpplay.cn/Author/PhoneAuthor/?");
            return;
        }
        if ("release".equals("develop")) {
            this.mAuthUrlList.add("http://47.112.113.131:90/Author/PhoneAuthor/?");
            return;
        }
        if (CloudAPI.isDebug()) {
            this.mAuthUrlList.add("https://uat.hpplay.cn:90/Author/PhoneAuthor/?");
            this.mAuthUrlList.add("https://uat.hpplay.cn:1001/Author/PhoneAuthor/?");
            this.mAuthUrlList.add("https://uat.hpplay.cn:1002/Author/PhoneAuthor/?");
            return;
        }
        this.mAuthUrlList.add("https://ssdkauth.hpplay.cn/Author/PhoneAuthor/?");
        this.mAuthUrlList.add("https://cdnauth1.hpplay.cn/Author/PhoneAuthor/?");
        this.mAuthUrlList.add("https://cdnauth2.hpplay.cn/Author/PhoneAuthor/?");
    }

    public void addAuthListener(AuthListener authListener) {
        if (null == authListener) {
            return;
        }
        if (null == this.mAuthListeners) {
            this.mAuthListeners = new ArrayList<AuthListener>();
        }
        this.mAuthListeners.add(authListener);
    }

    public void removeListener(AuthListener authListener) {
        try {
            this.mAuthListeners.remove(authListener);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void authSDKByInvalidToken() {
        if (this.mAuthStatusCode == 401 || this.mAuthStatusCode == 402) {
            return;
        }
        ++this.mInvalidTokenCount;
        if (this.mInvalidTokenCount >= 3) {
            return;
        }
        this.authSDK();
    }

    public void authSDK() {
        if (this.mAuthUrlList.isEmpty()) {
            SourceLog.w(TAG, "authSDK ignore, never should be here");
            return;
        }
        this.mAuthUrlIndex = 1;
        this.mServerErrorCount = 0;
        this.startAuth(this.mAuthUrlList.get(0));
    }

    private void startAuth(final String string) {
        long l2 = Preference.getInstance().get("auth_fail_time", 0L);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 < 180000L) {
            SourceLog.w(TAG, "startAuth ignore : " + (l3 - l2));
            return;
        }
        if (this.mAuthTask != null) {
            try {
                this.mAuthTask.cancel(true);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            this.mAuthTask = null;
        }
        final String string2 = Session.getInstance().appVersion;
        String string3 = Session.getInstance().appKey;
        String string4 = Session.getInstance().appSecret;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", Session.getInstance().getUID());
        hashMap.put("appid", string3);
        hashMap.put("package", this.mContext.getPackageName());
        hashMap.put("prot_ver", "4.0");
        hashMap.put("sever_ver", Session.getInstance().serverProtocolVer);
        hashMap.put("hid", Session.getInstance().getHID());
        hashMap.put("board", DeviceProperties.getBoard());
        hashMap.put("brand", DeviceProperties.getBrand());
        hashMap.put(FieldUtil.getString(FieldUtil.a), LeboUtil.getAID(this.mContext));
        hashMap.put("facturer", DeviceProperties.getManufacturer());
        hashMap.put("model", DeviceProperties.getModel());
        hashMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        String string5 = FieldUtil.getString(FieldUtil.m);
        Session.getInstance();
        hashMap.put(string5, "02:00:00:00:00:00");
        String string6 = "0";
        if (Feature.isMirrorCustomMode()) {
            string6 = "1";
            hashMap.put("oaid", DeviceUtil.getOAID(this.mContext));
        } else {
            hashMap.put("iemi", "");
        }
        hashMap.put("ismd5", string6);
        if (Session.getInstance().getRegTime() > 0L) {
            hashMap.put("reg_time", Session.getInstance().getRegTime() + "");
        }
        String string7 = (String)hashMap.get("uid") + (String)hashMap.get("appid") + (String)hashMap.get("package") + (String)hashMap.get("timestamp");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("appid=").append(string3).append("&uid=").append(Session.getInstance().getUID()).append("&version=").append(41201).append("&prot_ver=").append("4.0");
        hashMap.put("sign", EncryptUtil.md5EncryData(string7 + string4));
        final HttpEncrypt httpEncrypt = new HttpEncrypt();
        SourceLog.i(TAG, "authSDK map = " + HapplayUtils.getJsonParams(hashMap) + "\r\n " + string + stringBuilder);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string + stringBuilder, httpEncrypt.encode(HapplayUtils.getJsonParams(hashMap)), 1);
        asyncHttpParameter.in.connectTimeout = 10000;
        asyncHttpParameter.in.readTimeout = 10000;
        asyncHttpParameter.in.requestHeaders = httpEncrypt.buildHeader();
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                AuthSDK.this.mAuthTask = null;
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.w(AuthSDK.TAG, "onRequestResult cancel");
                    return;
                }
                if (asyncHttpParameter.out.result == null || asyncHttpParameter.out.responseCode == -1 || asyncHttpParameter.out.responseCode == 500 || asyncHttpParameter.out.responseCode == 404) {
                    AuthSDK.this.updateAuthTime();
                    AuthSDK.this.changeUrl();
                    return;
                }
                SourceLog.i(AuthSDK.TAG, "authSDK onRequestResult = " + asyncHttpParameter.out.result);
                try {
                    if (asyncHttpParameter.out.resultType == 0) {
                        Object object;
                        String string3 = asyncHttpParameter.out.result;
                        AuthSDKBean authSDKBean = null;
                        try {
                            string3 = httpEncrypt.decode(asyncHttpParameter.out);
                            object = new JSONObject(string3);
                            AuthSDK.this.cacheServerList((JSONObject)object);
                            AuthSDK.this.cacheSwitch((JSONObject)object);
                            authSDKBean = new AuthSDKBean((JSONObject)object);
                        }
                        catch (Exception exception) {
                            SourceLog.w(AuthSDK.TAG, "AuthSDK parse error:", exception);
                            AuthSDK.this.reportAuthFailedInfo(AuthSDK.AUTH_PARSE_ERROR);
                        }
                        if (authSDKBean != null && authSDKBean.data != null && (AuthSDK.this.mAuthStatusCode = authSDKBean.status) == 200) {
                            object = new AuthRepeatInfoBean();
                            if (!TextUtils.isEmpty((CharSequence)authSDKBean.data.uid)) {
                                SourceLog.w(AuthSDK.TAG, "uid reduplicate with other device, use server uid instead");
                                ((AuthRepeatInfoBean)object).setUid(authSDKBean.data.uid);
                            }
                            if (!TextUtils.isEmpty((CharSequence)authSDKBean.data.hid)) {
                                SourceLog.w(AuthSDK.TAG, "hid reduplicate with other device, use server hid instead");
                                ((AuthRepeatInfoBean)object).setHid(authSDKBean.data.hid);
                            }
                            if (authSDKBean.data.reg_time > 0L) {
                                ((AuthRepeatInfoBean)object).setReg_time(authSDKBean.data.reg_time);
                            }
                            if (((AuthRepeatInfoBean)object).hasRepeatInfo()) {
                                AuthSDK.this.saveRepeatInfoToLocal((AuthRepeatInfoBean)object);
                                Session.getInstance().updateRepeatInfo((AuthRepeatInfoBean)object);
                                if (!TextUtils.isEmpty((CharSequence)((AuthRepeatInfoBean)object).getUid())) {
                                    Session.getInstance().updateUID();
                                }
                                if (!TextUtils.isEmpty((CharSequence)((AuthRepeatInfoBean)object).getHid())) {
                                    Session.getInstance().updateHID();
                                }
                                if (((AuthRepeatInfoBean)object).getRegTime() > 0L) {
                                    Session.getInstance().setRegTime(((AuthRepeatInfoBean)object).getRegTime());
                                }
                            }
                            Preference.getInstance().put("sdk_verify", string3);
                            AuthSDK.this.analysisVerifyData(authSDKBean);
                            Session.getInstance().isAuthSuccess = true;
                            Preference.getInstance().put("sdk_verify_successful", true);
                            Preference.getInstance().put("key_sdk_auth_disable", false);
                            if (null != AuthSDK.this.mAuthListeners && !AuthSDK.this.mAuthListeners.isEmpty()) {
                                for (int i2 = 0; i2 < AuthSDK.this.mAuthListeners.size(); ++i2) {
                                    ((AuthListener)AuthSDK.this.mAuthListeners.get(i2)).onAuthSuccess(com.hpplay.sdk.source.d.a.a(), string3);
                                }
                            }
                            RightsManager.getInstance().vipAuth();
                            SDKConfig.getInstance().requestConfig();
                            AuthSDK.this.requestResPosition();
                        } else if (authSDKBean != null && authSDKBean.data != null && AuthSDK.this.mAuthStatusCode == 405) {
                            AuthSDK.this.updateAuthTime();
                            if (++AuthSDK.this.mServerErrorCount < 3) {
                                AuthSDK.this.startAuth(string);
                            } else {
                                AuthSDK.this.authFailed(String.valueOf(AuthSDK.this.mAuthStatusCode));
                            }
                        } else {
                            AuthSDK.this.updateAuthTime();
                            if (AuthSDK.this.mAuthStatusCode != 401 && AuthSDK.this.mAuthStatusCode != 402) {
                                AuthSDK.this.changeUrl();
                            } else {
                                Preference.getInstance().put("auth_fail_time", System.currentTimeMillis());
                            }
                            Session.getInstance().isAuthSuccess = false;
                            if (402 == AuthSDK.this.mAuthStatusCode) {
                                Preference.getInstance().put("key_sdk_auth_disable", true);
                            }
                            AuthSDK.this.authFailed(String.valueOf(AuthSDK.this.mAuthStatusCode));
                        }
                    } else {
                        AuthSDK.this.updateAuthTime();
                        AuthSDK.this.changeUrl();
                        Session.getInstance().isAuthSuccess = false;
                        Preference.getInstance().put("sdk_verify_successful", false);
                        if (null != AuthSDK.this.mAuthListeners && !AuthSDK.this.mAuthListeners.isEmpty()) {
                            for (int i3 = 0; i3 < AuthSDK.this.mAuthListeners.size(); ++i3) {
                                ((AuthListener)AuthSDK.this.mAuthListeners.get(i3)).onAuthFailed(AuthSDK.this.mAuthStatusCode);
                            }
                        }
                        SourceLog.i(AuthSDK.TAG, "authSDK auth failed");
                        AuthSDK.this.reportAuthFailedInfo(AuthSDK.AUTH_NETWORK_ERROR + String.valueOf(asyncHttpParameter.out.responseCode));
                    }
                    if (!TextUtils.isEmpty((CharSequence)Session.getInstance().getToken())) {
                        AuthSDK.this.requestLicense();
                    }
                    ServiceUpdater.getInstance().uploadDeviceInfo(AuthSDK.this.mContext);
                    if (AuthSDK.this.mAuthStatusCode != 402) {
                        AuthSDK.this.reportLogin(string2);
                    }
                    SDKConfig.getInstance().requestConfig();
                }
                catch (Exception exception) {
                    SourceLog.w(AuthSDK.TAG, exception);
                }
            }
        };
        this.mAuthTask = AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private void requestLicense() {
        boolean bl = a.l();
        boolean bl2 = a.n();
        SourceLog.i(TAG, "requestLicense :" + bl + " / " + bl2);
        if (!bl && bl2) {
            LicenseManager.getInstance().requestLicense(this.mContext);
        }
    }

    private void requestResPosition() {
        SourceLog.i(TAG, "requestResPosition");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", Session.getInstance().getUID());
        hashMap.put("appid", Session.getInstance().appKey);
        hashMap.put("token", Session.getInstance().getToken());
        hashMap.put("sourceId", "SDK_UI_LIST_BANNER,SDK_UI_LIST_BANNER_HORIZONTAL");
        hashMap.put("pro_ver", "1.0");
        hashMap.put("sdk_ver", "41201");
        hashMap.put("apk_ver", "" + HapplayUtils.getAppVersion(this.mContext));
        SourceLog.debug(TAG, "requestResPosition, " + CloudAPI.sResPositionUrl + "?" + HapplayUtils.getMapParams(hashMap));
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sResPositionUrl, HapplayUtils.getMapParams(hashMap), 1);
        asyncHttpParameter.in.connectTimeout = 10000;
        asyncHttpParameter.in.readTimeout = 10000;
        asyncHttpParameter.in.requestMethod = 0;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter != null && asyncHttpParameter.out != null && asyncHttpParameter.out.resultType == 0) {
                    SourceLog.i(AuthSDK.TAG, "requestResPosition,updateBannerData");
                    if (LelinkSdkManager.getInstance().mSearchBannerDataCallback != null) {
                        LelinkSdkManager.getInstance().mSearchBannerDataCallback.onBannerData(asyncHttpParameter.out.result);
                    }
                } else {
                    SourceLog.i(AuthSDK.TAG, "requestResPosition,result is null");
                    if (LelinkSdkManager.getInstance().mSearchBannerDataCallback != null) {
                        LelinkSdkManager.getInstance().mSearchBannerDataCallback.onBannerData(null);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private void cacheServerList(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
            if (jSONObject2 == null) {
                return;
            }
            JSONObject jSONObject3 = null;
            jSONObject3 = jSONObject2.optJSONObject("serv_list");
            long l2 = 0L;
            l2 = Preference.getInstance().get("key_sdk_login_time", l2);
            long l3 = System.currentTimeMillis() - l2;
            if ((jSONObject3 != null || l2 > 0L && l3 / 1000L / 60L / 60L > 24L) && this.mAuthStatusCode != 402) {
                this.reportLogin(Session.getInstance().appVersion);
                Preference.getInstance().put("key_sdk_login_time", System.currentTimeMillis());
            }
            if (jSONObject3 == null) {
                return;
            }
            Preference.getInstance().put("sdk_server_list", jSONObject3.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void cacheSwitch(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
            if (jSONObject2 == null) {
                return;
            }
            JSONObject jSONObject3 = jSONObject2.optJSONObject("switch");
            if (jSONObject3 == null) {
                return;
            }
            Preference.getInstance().put("sdk_switch", jSONObject3.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void changeUrl() {
        if (this.mAuthUrlIndex < this.mAuthUrlList.size()) {
            this.startAuth(this.mAuthUrlList.get(this.mAuthUrlIndex++));
            return;
        }
        this.authFailed("");
    }

    private void authFailed(String string) {
        try {
            Preference.getInstance().put("sdk_verify_successful", false);
            Session.getInstance().isAuthSuccess = false;
            int n2 = Preference.getInstance().get("key_sdk_auth_time", 0);
            if (this.isUseDone(n2)) {
                this.mAuthStatusCode = -101;
            }
            if (null != this.mAuthListeners && !this.mAuthListeners.isEmpty()) {
                for (int i2 = 0; i2 < this.mAuthListeners.size(); ++i2) {
                    this.mAuthListeners.get(i2).onAuthFailed(this.mAuthStatusCode);
                }
            }
            SourceLog.i(TAG, "authSDK auth failed " + string);
            this.reportAuthFailedInfo(AUTH_DATA_ERROR + string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void reportAuthFailedInfo(String string) {
        SourceDataReport.getInstance().onAuthFailed(string);
    }

    private void reportLogin(String string) {
        SourceLog.i(TAG, "reportLogin");
        SourceDataReport.getInstance().login(string);
    }

    private void analysisVerifyData(AuthSDKBean authSDKBean) {
        SourceLog.i(TAG, "analysisVerifyData");
        if (authSDKBean == null || authSDKBean.data == null) {
            return;
        }
        Session.getInstance().setToken(authSDKBean.data.token);
        Session.getInstance().tid = String.valueOf(authSDKBean.data.tid);
        Session.getInstance().scanTime = authSDKBean.data.scan_time;
        Session.getInstance().mExpireTime = authSDKBean.data.expire_time;
        this.analysisSwitch();
        this.analysisServerList();
    }

    private void analysisSwitch() {
        SwitchEntity switchEntity;
        String string = Preference.getInstance().get("sdk_switch");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        try {
            switchEntity = new SwitchEntity(new JSONObject(string));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return;
        }
        Session.getInstance().isPreferLelink = switchEntity.switchBean != null && switchEntity.switchBean.sl == 1;
    }

    private void analysisServerList() {
        ServListEntity servListEntity;
        String string = Preference.getInstance().get("sdk_server_list");
        try {
            servListEntity = new ServListEntity(new JSONObject(string));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception.getMessage());
            return;
        }
        Session.getInstance().serverProtocolVer = servListEntity.ver + "";
        for (ServListEntity.UrlListEntity urlListEntity : servListEntity.url_list) {
            String string2 = urlListEntity.name;
            String string3 = urlListEntity.url;
            if (TextUtils.isEmpty((CharSequence)string3)) continue;
            if (URL_SDK_AUTH.equalsIgnoreCase(string2)) {
                Preference.getInstance().put("key_sdk_auth_url", string3);
                this.parseAuthUrl(string3);
            }
            if (!string3.startsWith("http")) {
                string3 = "http://" + string3;
            }
            if (URL_TYPE_REPORT.equalsIgnoreCase(string2)) {
                CloudAPI.sReportRoot = string3;
                continue;
            }
            if (URL_TYPE_GSLB.equalsIgnoreCase(string2)) {
                CloudAPI.sGLSBRoot = string3;
                CloudAPI.sResPositionRoot = string3;
                continue;
            }
            if (URL_TYPE_IM_DNS.equalsIgnoreCase(string2)) {
                CloudAPI.sImDNSUrl = string3;
                continue;
            }
            if (URL_TYPE_AD_ENGINE.equalsIgnoreCase(string2)) {
                CloudAPI.sADEngineUrl = string3;
                continue;
            }
            if (URL_DEVICE_MANAGER.equalsIgnoreCase(string2)) {
                CloudAPI.sDeviceMgrUrl = string3;
                continue;
            }
            if (URL_TYPE_PIN.equalsIgnoreCase(string2)) {
                CloudAPI.sPinRoot = string3;
                continue;
            }
            if (URL_TYPE_SHORT_LINK.equalsIgnoreCase(string2)) {
                CloudAPI.sShortLink = string3;
                continue;
            }
            if (URL_TYPE_LOG_REPORT.equalsIgnoreCase(string2)) {
                CloudAPI.sLogReportUrl = string3;
                continue;
            }
            if (URL_TYPE_REPORT_SEARCH.equals(string2)) {
                CloudAPI.sLogReportQueryUrl = string3;
                continue;
            }
            if (URL_IM_CONNECT.equalsIgnoreCase(string2)) {
                SourceLog.i(TAG, "has im connect domain");
                this.isHasIMConnectDomain = true;
                CloudAPI.sImServer = string3;
                continue;
            }
            if ("conf".equalsIgnoreCase(string2)) {
                CloudAPI.sConfigRoot = string3;
                continue;
            }
            if (!URL_VIP_AUTH.equalsIgnoreCase(string2)) continue;
            CloudAPI.sVipAuthRoot = string3;
        }
        CloudAPI.updateDynamicUrls();
        if (!this.isHasIMConnectDomain) {
            this.updateIMRootUrl();
        }
    }

    public void updateIMRootUrl() {
        IMTask.getIMUrl();
    }

    private void parseAuthUrl(String string) {
        String[] stringArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (this.mAuthUrlList == null) {
            this.mAuthUrlList = new LinkedList<String>();
        } else {
            this.mAuthUrlList.clear();
        }
        if (CloudAPI.isDebug()) {
            this.mAuthUrlList.add("https://uat.hpplay.cn:90/Author/PhoneAuthor/?");
        } else {
            this.mAuthUrlList.add("https://ssdkauth.hpplay.cn/Author/PhoneAuthor/?");
        }
        for (String string2 : stringArray = string.split(",")) {
            if (!string2.startsWith("http")) {
                string2 = "http://" + string2;
            }
            if (this.mAuthUrlList.contains(string2 = string2 + "/Author/PhoneAuthor/?")) break;
            this.mAuthUrlList.add(string2);
        }
    }

    public void release() {
        this.isHasIMConnectDomain = false;
    }

    private void saveRepeatInfoToLocal(AuthRepeatInfoBean authRepeatInfoBean) {
        SourceLog.i(TAG, "saveRepeatInfoToLocal info =" + authRepeatInfoBean);
        File file = new File(REPEAT_INFO_FILE_DIR);
        if (!file.exists()) {
            boolean bl = file.mkdirs();
            SourceLog.i(TAG, "make dir status =" + bl);
        }
        try {
            Preference.getInstance().put("repeat_info", AuthRepeatInfoBean.beanToJson(authRepeatInfoBean));
            FileUtil.string2File(AuthRepeatInfoBean.beanToJson(authRepeatInfoBean), REPEAT_INFO_FILE_NAME);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "saveRepeatInfoToLocal error :" + exception.toString());
        }
    }

    private boolean isUseDone(int n2) {
        if (CloudAPI.isDebug()) {
            return n2 >= 10;
        }
        return n2 >= 100;
    }

    private void updateAuthTime() {
        try {
            SourceLog.i(TAG, "update auth time");
            if (this.isHistorySuccess()) {
                Preference.getInstance().put("key_sdk_auth_time", 0);
                return;
            }
            int n2 = Preference.getInstance().get("key_sdk_auth_time", 0) + 1;
            Preference.getInstance().put("key_sdk_auth_time", n2);
            SourceLog.i(TAG, "update auth time\uff0c current time = " + n2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private boolean isHistorySuccess() {
        String string = Session.getInstance().tid;
        SourceLog.w(TAG, " tid = " + string);
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public int getAuthCode() {
        return this.mAuthStatusCode;
    }

    private AuthRepeatInfoBean readRepeatInfoFromLocal() {
        String string = null;
        try {
            string = Preference.getInstance().get("repeat_info");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            try {
                string = FileUtil.file2String(REPEAT_INFO_FILE_NAME);
                SourceLog.i(TAG, "form file info = " + string);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = Preference.getInstance().get("repeat_info");
                    SourceLog.i(TAG, "form sp info = " + string);
                }
            }
            catch (Exception exception) {
                string = Preference.getInstance().get("repeat_info");
            }
        }
        return AuthRepeatInfoBean.jsonToBean(string);
    }

    public boolean checkSdkUsable() {
        boolean bl = Preference.getInstance().get("sdk_verify_successful", false);
        boolean bl2 = Preference.getInstance().get("key_sdk_auth_disable", false);
        SourceLog.i(TAG, "checkSdkUsable AuthStatusCode:" + this.mAuthStatusCode);
        int n2 = Preference.getInstance().get("key_sdk_auth_time", 0);
        if (!bl && !Feature.isAuthFailedBrowse()) {
            if (this.mAuthStatusCode == 402 || AuthSDK.getInstance().isUseDone(n2) || bl2) {
                return false;
            }
            if (this.mAuthStatusCode == -100 && AuthSDK.getInstance().isUseDone(n2)) {
                return false;
            }
        }
        return true;
    }
}

