/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request.animation;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import com.hpplay.glide.request.animation.GlideAnimation;

public class DrawableCrossFadeViewAnimation<T extends Drawable>
implements GlideAnimation<T> {
    private final GlideAnimation<T> defaultAnimation;
    private final int duration;

    public DrawableCrossFadeViewAnimation(GlideAnimation<T> glideAnimation, int n2) {
        this.defaultAnimation = glideAnimation;
        this.duration = n2;
    }

    @Override
    public boolean animate(T t2, GlideAnimation.ViewAdapter viewAdapter) {
        Drawable drawable = viewAdapter.getCurrentDrawable();
        if (drawable != null) {
            TransitionDrawable transitionDrawable = new TransitionDrawable(new Drawable[]{drawable, t2});
            transitionDrawable.setCrossFadeEnabled(true);
            transitionDrawable.startTransition(this.duration);
            viewAdapter.setDrawable((Drawable)transitionDrawable);
            return true;
        }
        this.defaultAnimation.animate(t2, viewAdapter);
        return false;
    }
}

