/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.os.Build;
import android.util.Log;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;

public final class TransformationUtils {
    private static final String TAG = "TransformationUtils";
    public static final int PAINT_FLAGS = 6;

    private TransformationUtils() {
    }

    public static Bitmap centerCrop(Bitmap bitmap, Bitmap bitmap2, int n2, int n3) {
        float f2;
        if (bitmap2 == null) {
            return null;
        }
        if (bitmap2.getWidth() == n2 && bitmap2.getHeight() == n3) {
            return bitmap2;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        Matrix matrix = new Matrix();
        if (bitmap2.getWidth() * n3 > n2 * bitmap2.getHeight()) {
            f2 = (float)n3 / (float)bitmap2.getHeight();
            f3 = ((float)n2 - (float)bitmap2.getWidth() * f2) * 0.5f;
        } else {
            f2 = (float)n2 / (float)bitmap2.getWidth();
            f4 = ((float)n3 - (float)bitmap2.getHeight() * f2) * 0.5f;
        }
        matrix.setScale(f2, f2);
        matrix.postTranslate((float)((int)(f3 + 0.5f)), (float)((int)(f4 + 0.5f)));
        Bitmap bitmap3 = bitmap != null ? bitmap : Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)TransformationUtils.getSafeConfig(bitmap2));
        TransformationUtils.setAlpha(bitmap2, bitmap3);
        Canvas canvas = new Canvas(bitmap3);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap2, matrix, paint);
        return bitmap3;
    }

    public static Bitmap fitCenter(Bitmap bitmap, BitmapPool bitmapPool, int n2, int n3) {
        if (bitmap.getWidth() == n2 && bitmap.getHeight() == n3) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size matches input, returning input");
            }
            return bitmap;
        }
        float f2 = (float)n2 / (float)bitmap.getWidth();
        float f3 = (float)n3 / (float)bitmap.getHeight();
        float f4 = Math.min(f2, f3);
        int n4 = (int)(f4 * (float)bitmap.getWidth());
        int n5 = (int)(f4 * (float)bitmap.getHeight());
        if (bitmap.getWidth() == n4 && bitmap.getHeight() == n5) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"adjusted target size matches input, returning input");
            }
            return bitmap;
        }
        Bitmap.Config config = TransformationUtils.getSafeConfig(bitmap);
        Bitmap bitmap2 = bitmapPool.get(n4, n5, config);
        if (bitmap2 == null) {
            bitmap2 = Bitmap.createBitmap((int)n4, (int)n5, (Bitmap.Config)config);
        }
        TransformationUtils.setAlpha(bitmap, bitmap2);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("request: " + n2 + "x" + n3));
            Log.v((String)TAG, (String)("toFit:   " + bitmap.getWidth() + "x" + bitmap.getHeight()));
            Log.v((String)TAG, (String)("toReuse: " + bitmap2.getWidth() + "x" + bitmap2.getHeight()));
            Log.v((String)TAG, (String)("minPct:   " + f4));
        }
        Canvas canvas = new Canvas(bitmap2);
        Matrix matrix = new Matrix();
        matrix.setScale(f4, f4);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, matrix, paint);
        return bitmap2;
    }

    @TargetApi(value=12)
    public static void setAlpha(Bitmap bitmap, Bitmap bitmap2) {
        if (Build.VERSION.SDK_INT >= 12 && bitmap2 != null) {
            bitmap2.setHasAlpha(bitmap.hasAlpha());
        }
    }

    @Deprecated
    @TargetApi(value=5)
    public static int getOrientation(String string) {
        int n2 = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n3 = exifInterface.getAttributeInt("Orientation", 0);
            return TransformationUtils.getExifOrientationDegrees(n3);
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)("Unable to get orientation for image with path=" + string), (Throwable)exception);
            }
            return n2;
        }
    }

    @Deprecated
    public static Bitmap orientImage(String string, Bitmap bitmap) {
        int n2 = TransformationUtils.getOrientation(string);
        return TransformationUtils.rotateImage(bitmap, n2);
    }

    public static Bitmap rotateImage(Bitmap bitmap, int n2) {
        Bitmap bitmap2;
        block3: {
            bitmap2 = bitmap;
            try {
                if (n2 != 0) {
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)n2);
                    bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                }
            }
            catch (Exception exception) {
                if (!Log.isLoggable((String)TAG, (int)6)) break block3;
                Log.e((String)TAG, (String)"Exception when trying to orient image", (Throwable)exception);
            }
        }
        return bitmap2;
    }

    public static int getExifOrientationDegrees(int n2) {
        int n3;
        switch (n2) {
            case 5: 
            case 6: {
                n3 = 90;
                break;
            }
            case 3: 
            case 4: {
                n3 = 180;
                break;
            }
            case 7: 
            case 8: {
                n3 = 270;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    public static Bitmap rotateImageExif(Bitmap bitmap, BitmapPool bitmapPool, int n2) {
        Matrix matrix = new Matrix();
        TransformationUtils.initializeMatrixForRotation(n2, matrix);
        if (matrix.isIdentity()) {
            return bitmap;
        }
        RectF rectF = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        matrix.mapRect(rectF);
        int n3 = Math.round(rectF.width());
        int n4 = Math.round(rectF.height());
        Bitmap.Config config = TransformationUtils.getSafeConfig(bitmap);
        Bitmap bitmap2 = bitmapPool.get(n3, n4, config);
        if (bitmap2 == null) {
            bitmap2 = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)config);
        }
        matrix.postTranslate(-rectF.left, -rectF.top);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, matrix, paint);
        return bitmap2;
    }

    private static Bitmap.Config getSafeConfig(Bitmap bitmap) {
        return bitmap.getConfig() != null ? bitmap.getConfig() : Bitmap.Config.ARGB_8888;
    }

    static void initializeMatrixForRotation(int n2, Matrix matrix) {
        switch (n2) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                break;
            }
        }
    }
}

