/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.util.Log;
import com.hpplay.glide.load.ResourceEncoder;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.util.LogTime;
import com.hpplay.glide.util.Util;
import java.io.OutputStream;

public class BitmapEncoder
implements ResourceEncoder<Bitmap> {
    private static final String TAG = "BitmapEncoder";
    private static final int DEFAULT_COMPRESSION_QUALITY = 90;
    private Bitmap.CompressFormat compressFormat;
    private int quality;

    public BitmapEncoder() {
        this(null, 90);
    }

    public BitmapEncoder(Bitmap.CompressFormat compressFormat, int n2) {
        this.compressFormat = compressFormat;
        this.quality = n2;
    }

    @Override
    public boolean encode(Resource<Bitmap> resource, OutputStream outputStream) {
        Bitmap bitmap = resource.get();
        long l2 = LogTime.getLogTime();
        Bitmap.CompressFormat compressFormat = this.getFormat(bitmap);
        bitmap.compress(compressFormat, this.quality, outputStream);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Compressed with type: " + compressFormat + " of size " + Util.getBitmapByteSize(bitmap) + " in " + LogTime.getElapsedMillis(l2)));
        }
        return true;
    }

    @Override
    public String getId() {
        return "BitmapEncoder.com.bumptech.glide.load.resource.bitmap";
    }

    private Bitmap.CompressFormat getFormat(Bitmap bitmap) {
        if (this.compressFormat != null) {
            return this.compressFormat;
        }
        if (bitmap.hasAlpha()) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }
}

