/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide;

import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import com.hpplay.glide.BitmapRequestBuilder;
import com.hpplay.glide.GenericRequestBuilder;
import com.hpplay.glide.Glide;
import com.hpplay.glide.RequestManager;
import com.hpplay.glide.load.model.ImageVideoModelLoader;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.resource.transcode.BitmapBytesTranscoder;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.provider.DataLoadProvider;
import com.hpplay.glide.provider.FixedLoadProvider;
import java.io.InputStream;

public class BitmapTypeRequest<ModelType>
extends BitmapRequestBuilder<ModelType, Bitmap> {
    private final ModelLoader<ModelType, InputStream> streamModelLoader;
    private final ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader;
    private final Glide glide;
    private final RequestManager.OptionsApplier optionsApplier;

    private static <A, R> FixedLoadProvider<A, ImageVideoWrapper, Bitmap, R> buildProvider(Glide glide, ModelLoader<A, InputStream> modelLoader, ModelLoader<A, ParcelFileDescriptor> modelLoader2, Class<R> clazz, ResourceTranscoder<Bitmap, R> resourceTranscoder) {
        if (modelLoader == null && modelLoader2 == null) {
            return null;
        }
        if (resourceTranscoder == null) {
            resourceTranscoder = glide.buildTranscoder(Bitmap.class, clazz);
        }
        DataLoadProvider<ImageVideoWrapper, Bitmap> dataLoadProvider = glide.buildDataProvider(ImageVideoWrapper.class, Bitmap.class);
        ImageVideoModelLoader<A> imageVideoModelLoader = new ImageVideoModelLoader<A>(modelLoader, modelLoader2);
        return new FixedLoadProvider(imageVideoModelLoader, resourceTranscoder, dataLoadProvider);
    }

    BitmapTypeRequest(GenericRequestBuilder<ModelType, ?, ?, ?> genericRequestBuilder, ModelLoader<ModelType, InputStream> modelLoader, ModelLoader<ModelType, ParcelFileDescriptor> modelLoader2, RequestManager.OptionsApplier optionsApplier) {
        super(BitmapTypeRequest.buildProvider(genericRequestBuilder.glide, modelLoader, modelLoader2, Bitmap.class, null), Bitmap.class, genericRequestBuilder);
        this.streamModelLoader = modelLoader;
        this.fileDescriptorModelLoader = modelLoader2;
        this.glide = genericRequestBuilder.glide;
        this.optionsApplier = optionsApplier;
    }

    public <R> BitmapRequestBuilder<ModelType, R> transcode(ResourceTranscoder<Bitmap, R> resourceTranscoder, Class<R> clazz) {
        return this.optionsApplier.apply(new BitmapRequestBuilder<ModelType, R>(BitmapTypeRequest.buildProvider(this.glide, this.streamModelLoader, this.fileDescriptorModelLoader, clazz, resourceTranscoder), clazz, this));
    }

    public BitmapRequestBuilder<ModelType, byte[]> toBytes() {
        return this.transcode(new BitmapBytesTranscoder(), byte[].class);
    }

    public BitmapRequestBuilder<ModelType, byte[]> toBytes(Bitmap.CompressFormat compressFormat, int n2) {
        return this.transcode(new BitmapBytesTranscoder(compressFormat, n2), byte[].class);
    }
}

