/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.cybergarage.upnp.Argument;
import com.hpplay.cybergarage.upnp.ArgumentList;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.UPnPStatus;
import com.hpplay.cybergarage.upnp.control.ActionListener;
import com.hpplay.cybergarage.upnp.control.ActionRequest;
import com.hpplay.cybergarage.upnp.control.ActionResponse;
import com.hpplay.cybergarage.upnp.control.ControlResponse;
import com.hpplay.cybergarage.upnp.xml.ActionData;
import com.hpplay.cybergarage.util.Mutex;
import com.hpplay.cybergarage.xml.Node;

public class Action {
    public static final String ELEM_NAME = "action";
    public static final String STATUS_FLAG = "L@L";
    private Node serviceNode;
    private Node actionNode;
    private Mutex mutex = new Mutex();
    private static final String NAME = "name";
    private ResponseCallbackLisener mResponseCallbackLisener;
    public boolean isSuccessful;
    private UPnPStatus upnpStatus = new UPnPStatus();
    private Object userData = null;

    private Node getServiceNode() {
        return this.serviceNode;
    }

    public Service getService() {
        return new Service(this.getServiceNode());
    }

    void setService(Service service) {
        this.serviceNode = service.getServiceNode();
        for (Argument argument : this.getArgumentList()) {
            argument.setService(service);
        }
    }

    public Node getActionNode() {
        return this.actionNode;
    }

    public Action(Node node) {
        this.serviceNode = node;
        this.actionNode = new Node(ELEM_NAME);
    }

    public Action(Node node, Node node2) {
        this.serviceNode = node;
        this.actionNode = node2;
    }

    public Action(Action action) {
        this.serviceNode = action.getServiceNode();
        this.actionNode = action.getActionNode();
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public static boolean isActionNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setName(String string) {
        this.getActionNode().setNode(NAME, string);
    }

    public String getName() {
        return this.getActionNode().getNodeValue(NAME);
    }

    public ArgumentList getArgumentList() {
        ArgumentList argumentList = new ArgumentList();
        Node node = this.getActionNode().getNode("argumentList");
        if (node == null) {
            return argumentList;
        }
        int n2 = node.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = node.getNode(i2);
            if (!Argument.isArgumentNode(node2)) continue;
            Argument argument = new Argument(this.getServiceNode(), node2);
            argumentList.add(argument);
        }
        return argumentList;
    }

    public void setArgumentList(ArgumentList argumentList) {
        Node node = this.getActionNode().getNode("argumentList");
        if (node == null) {
            node = new Node("argumentList");
            this.getActionNode().addNode(node);
        } else {
            node.removeAllNodes();
        }
        for (Argument argument : argumentList) {
            argument.setService(this.getService());
            node.addNode(argument.getArgumentNode());
        }
    }

    public ArgumentList getInputArgumentList() {
        ArgumentList argumentList = this.getArgumentList();
        int n2 = argumentList.size();
        ArgumentList argumentList2 = new ArgumentList();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentList.getArgument(i2);
            if (!argument.isInDirection()) continue;
            argumentList2.add(argument);
        }
        return argumentList2;
    }

    public ArgumentList getOutputArgumentList() {
        ArgumentList argumentList = this.getArgumentList();
        int n2 = argumentList.size();
        ArgumentList argumentList2 = new ArgumentList();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentList.getArgument(i2);
            if (!argument.isOutDirection()) continue;
            argumentList2.add(argument);
        }
        return argumentList2;
    }

    public Argument getArgument(String string) {
        ArgumentList argumentList = this.getArgumentList();
        int n2 = argumentList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentList.getArgument(i2);
            String string2 = argument.getName();
            if (string2 == null || !string.equals(string2)) continue;
            return argument;
        }
        return null;
    }

    public void setArgumentValues(ArgumentList argumentList) {
        this.getArgumentList().set(argumentList);
    }

    public void setInArgumentValues(ArgumentList argumentList) {
        this.getArgumentList().setReqArgs(argumentList);
    }

    public void setOutArgumentValues(ArgumentList argumentList) {
        this.getArgumentList().setResArgs(argumentList);
    }

    public void setArgumentValue(String string, String string2) {
        Argument argument = this.getArgument(string);
        if (argument == null) {
            return;
        }
        argument.setValue(string2);
    }

    public void setArgumentValue(String string, int n2) {
        this.setArgumentValue(string, Integer.toString(n2));
    }

    private void clearOutputAgumentValues() {
        ArgumentList argumentList = this.getArgumentList();
        int n2 = argumentList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentList.getArgument(i2);
            if (!argument.isOutDirection()) continue;
            argument.setValue("");
        }
    }

    public String getArgumentValue(String string) {
        Argument argument = this.getArgument(string);
        if (argument == null) {
            return "";
        }
        return argument.getValue();
    }

    public int getArgumentIntegerValue(String string) {
        Argument argument = this.getArgument(string);
        if (argument == null) {
            return 0;
        }
        return argument.getIntegerValue();
    }

    private ActionData getActionData() {
        Node node = this.getActionNode();
        ActionData actionData = (ActionData)node.getUserData();
        if (actionData == null) {
            actionData = new ActionData();
            node.setUserData(actionData);
            actionData.setNode(node);
        }
        return actionData;
    }

    public ActionListener getActionListener() {
        return this.getActionData().getActionListener();
    }

    public void setActionListener(ActionListener actionListener) {
        this.getActionData().setActionListener(actionListener);
    }

    public boolean performActionListener(ActionRequest actionRequest) {
        ActionListener actionListener = this.getActionListener();
        if (actionListener == null) {
            return false;
        }
        ActionResponse actionResponse = new ActionResponse();
        this.setStatus(401);
        this.clearOutputAgumentValues();
        if (actionListener.actionControlReceived(this)) {
            actionResponse.setResponse(this);
        } else {
            UPnPStatus uPnPStatus = this.getStatus();
            actionResponse.setFaultResponse(uPnPStatus.getCode(), uPnPStatus.getDescription());
        }
        actionResponse.print();
        actionRequest.post(actionResponse);
        return true;
    }

    private ControlResponse getControlResponse() {
        return this.getActionData().getControlResponse();
    }

    private void setControlResponse(ControlResponse controlResponse) {
        this.getActionData().setControlResponse(controlResponse);
    }

    public UPnPStatus getControlStatus() {
        return this.getControlResponse().getUPnPError();
    }

    public void setResponseCallbackLisener(ResponseCallbackLisener responseCallbackLisener) {
        this.mResponseCallbackLisener = responseCallbackLisener;
    }

    public boolean postControlAction(String string) {
        ArgumentList argumentList = this.getArgumentList();
        ArgumentList argumentList2 = this.getInputArgumentList();
        ActionRequest actionRequest = new ActionRequest(string);
        actionRequest.setRequest(this, argumentList2);
        actionRequest.print();
        ActionResponse actionResponse = actionRequest.post();
        actionResponse.print();
        this.setControlResponse(actionResponse);
        int n2 = actionResponse.getStatusCode();
        this.setStatus(n2);
        ArgumentList argumentList3 = actionResponse.getResponse();
        try {
            if (actionRequest.getHeader().contains("Play") || actionRequest.getHeader().contains("SetAVTransportURI")) {
                String string2 = actionResponse.getHeader() + "\r\n" + new String(actionResponse.getContent());
                if (this.mResponseCallbackLisener != null) {
                    this.mResponseCallbackLisener.onCallback(actionRequest.getHeader() + "\r\n" + new String(actionRequest.getContent()), string2);
                }
            }
            argumentList.setResArgs(argumentList3);
        }
        catch (Exception exception) {
            this.setStatus(402, "Action succesfully delivered but invalid arguments returned.");
            return false;
        }
        return actionResponse.isSuccessful();
    }

    public String postPlayAction(String string) {
        this.isSuccessful = false;
        ArgumentList argumentList = this.getArgumentList();
        ArgumentList argumentList2 = this.getInputArgumentList();
        ActionRequest actionRequest = new ActionRequest(string);
        actionRequest.setRequest(this, argumentList2);
        actionRequest.print();
        ActionResponse actionResponse = actionRequest.post();
        actionResponse.print();
        this.setControlResponse(actionResponse);
        int n2 = actionResponse.getStatusCode();
        this.setStatus(n2);
        ArgumentList argumentList3 = actionResponse.getResponse();
        try {
            String string2 = actionResponse.getHeader() + "\r\n" + new String(actionResponse.getContent());
            if (this.mResponseCallbackLisener != null) {
                this.mResponseCallbackLisener.onCallback(actionRequest.getHeader() + "\r\n" + new String(actionRequest.getContent()), string2);
            }
            argumentList.setResArgs(argumentList3);
            this.isSuccessful = actionResponse.isSuccessful();
            return string2 + STATUS_FLAG + actionResponse.getStatusCode();
        }
        catch (Exception exception) {
            this.setStatus(402, "Action succesfully delivered but invalid arguments returned.");
            return exception.toString();
        }
    }

    public void print() {
        System.out.println("Action : " + this.getName());
        ArgumentList argumentList = this.getArgumentList();
        int n2 = argumentList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentList.getArgument(i2);
            String string = argument.getName();
            String string2 = argument.getValue();
            String string3 = argument.getDirection();
            System.out.println(" [" + i2 + "] = " + string3 + ", " + string + ", " + string2);
        }
    }

    public void setStatus(int n2, String string) {
        this.upnpStatus.setCode(n2);
        this.upnpStatus.setDescription(string);
    }

    public void setStatus(int n2) {
        this.setStatus(n2, UPnPStatus.code2String(n2));
    }

    public UPnPStatus getStatus() {
        return this.upnpStatus;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public static interface ResponseCallbackLisener {
        public void onCallback(String var1, String var2);
    }
}

