/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.asyncmanager;

import android.os.AsyncTask;
import com.hpplay.common.asyncmanager.AsyncFileParameter;
import com.hpplay.common.asyncmanager.AsyncFileRequestListener;
import com.hpplay.common.asyncmanager.FileRequest;
import com.hpplay.common.log.LeLog;

public class AsyncFileJob
extends AsyncTask {
    private String TAG = "AsyncFileJob";
    public int id;
    private AsyncFileParameter fileParameter;
    private AsyncFileRequestListener requestListener;
    private FileRequest.DownloadListener downloadListener = new FileRequest.DownloadListener(){

        @Override
        public void onDownLoad(int n2, long l2, long l3, int n3) {
            if (n3 == 0) {
                AsyncFileJob.this.publishProgress(new Object[]{l2, l3});
            }
        }
    };
    private FileRequest fileRequest;

    public AsyncFileJob(AsyncFileParameter asyncFileParameter, AsyncFileRequestListener asyncFileRequestListener) {
        this.fileParameter = asyncFileParameter;
        this.requestListener = asyncFileRequestListener;
    }

    protected Object doInBackground(Object[] objectArray) {
        this.fileRequest = new FileRequest(this.fileParameter.in.fileUrl, this.fileParameter.in.savePath);
        this.fileRequest.setDownloadListener(this.downloadListener);
        return this.fileRequest.download();
    }

    protected void onPostExecute(Object object) {
        super.onPostExecute(object);
        boolean bl = false;
        try {
            bl = (Boolean)object;
        }
        catch (Exception exception) {
            LeLog.w(this.TAG, exception);
        }
        if (this.requestListener != null && this.fileParameter != null) {
            this.fileParameter.out.resultType = bl ? 8 : 7;
            this.requestListener.onDownloadFinish(this.fileParameter);
        }
    }

    protected void onProgressUpdate(Object[] objectArray) {
        super.onProgressUpdate(objectArray);
        long l2 = 0L;
        long l3 = 0L;
        try {
            l2 = Long.valueOf(objectArray[0].toString());
            l3 = Long.valueOf(objectArray[1].toString());
        }
        catch (Exception exception) {
            LeLog.w(this.TAG, exception);
        }
        if (this.requestListener != null && this.fileParameter != null) {
            this.fileParameter.out.resultType = 5;
            this.fileParameter.out.currentSize = l2;
            this.fileParameter.out.totalSize = l3;
            this.requestListener.onDownloadUpdate(l2, l3);
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        if (this.fileRequest != null) {
            try {
                this.fileRequest.shutDown();
            }
            catch (Exception exception) {
                LeLog.w(this.TAG, exception);
            }
        }
        if (this.requestListener != null && this.fileParameter != null) {
            this.fileParameter.out.resultType = 6;
            this.requestListener.onDownloadFinish(this.fileParameter);
        }
    }
}

