/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.OPTRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Rcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Resolver;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverConfig;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import com.hpplay.sdk.source.mdns.xbill.dns.TCPClient;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIG;
import com.hpplay.sdk.source.mdns.xbill.dns.UDPClient;
import com.hpplay.sdk.source.mdns.xbill.dns.ZoneTransferIn;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;

public class SimpleResolver
implements Resolver {
    private InetSocketAddress address;
    private InetSocketAddress localAddress;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private OPTRecord queryOPT;
    private TSIG tsig;
    private long timeoutValue = 10000L;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;

    public SimpleResolver(String string) {
        if (string == null && (string = ResolverConfig.getCurrentConfig().server()) == null) {
            string = defaultResolver;
        }
        InetAddress inetAddress = string.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        this.address = new InetSocketAddress(inetAddress, 53);
    }

    public SimpleResolver() {
        this(null);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public void setPort(int n2) {
        this.address = new InetSocketAddress(this.address.getAddress(), n2);
    }

    public void setAddress(InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = new InetSocketAddress(inetAddress, this.address.getPort());
    }

    @Override
    public void setTCP(boolean bl) {
        this.useTCP = bl;
    }

    @Override
    public void setIgnoreTruncation(boolean bl) {
        this.ignoreTruncation = bl;
    }

    @Override
    public void setEDNS(int n2, int n3, int n4, List list) {
        if (n2 != 0 && n2 != -1) {
            throw new IllegalArgumentException("invalid EDNS level - must be 0 or -1");
        }
        if (n3 == 0) {
            n3 = 1280;
        }
        this.queryOPT = new OPTRecord(n3, 0, n2, n4, list);
    }

    @Override
    public void setEDNS(int n2) {
        this.setEDNS(n2, 0, 0, null);
    }

    @Override
    public void setTSIGKey(TSIG tSIG) {
        this.tsig = tSIG;
    }

    @Override
    public void setTimeout(int n2, int n3) {
        this.timeoutValue = (long)n2 * 1000L + (long)n3;
    }

    @Override
    public void setTimeout(int n2) {
        this.setTimeout(n2, 0);
    }

    long getTimeout() {
        return this.timeoutValue;
    }

    private Message parseMessage(byte[] byArray) {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            if (Options.check("verbose")) {
                iOException.printStackTrace();
            }
            throw new Exception("Error parsing message");
        }
    }

    private void verifyTSIG(Message message, Message message2, byte[] byArray, TSIG tSIG) {
        if (tSIG != null) {
            int n2 = tSIG.verify(message2, byArray, message.getTSIG());
            if (Options.check("verbose")) {
                System.err.println("TSIG verify: " + Rcode.TSIGstring(n2));
            }
        }
    }

    private void applyEDNS(Message message) {
        if (this.queryOPT != null && message.getOPT() == null) {
            message.addRecord(this.queryOPT, 3);
        }
    }

    private int maxUDPSize(Message message) {
        OPTRecord oPTRecord = message.getOPT();
        return oPTRecord == null ? 512 : oPTRecord.getPayloadSize();
    }

    @Override
    public Message send(Message message) {
        Object object;
        if (message.getHeader().getOpcode() == 0 && (object = message.getQuestion()) != null && ((Record)object).getType() == 252) {
            return this.sendAXFR(message);
        }
        message = (Message)message.clone();
        this.applyEDNS(message);
        if (this.tsig != null) {
            this.tsig.apply(message, null);
        }
        object = message.toWire(65535);
        int n2 = this.maxUDPSize(message);
        boolean bl = false;
        long l2 = System.currentTimeMillis() + this.timeoutValue;
        while (true) {
            Object object2;
            byte[] byArray;
            if (this.useTCP || ((Object)object).length > n2) {
                bl = true;
            }
            if ((byArray = bl ? TCPClient.sendrecv(this.localAddress, this.address, (byte[])object, l2) : UDPClient.sendrecv(this.localAddress, this.address, (byte[])object, n2, l2)).length < 12) {
                throw new Exception("invalid DNS header - too short");
            }
            int n3 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
            int n4 = message.getHeader().getID();
            if (n3 == n4) {
                object2 = this.parseMessage(byArray);
                this.verifyTSIG(message, (Message)object2, byArray, this.tsig);
                if (bl || this.ignoreTruncation || !((Message)object2).getHeader().getFlag(6)) {
                    return object2;
                }
                bl = true;
                continue;
            }
            object2 = "invalid message id: expected " + n4 + "; got id " + n3;
            if (bl) {
                throw new Exception((String)object2);
            }
            if (!Options.check("verbose")) continue;
            System.err.println((String)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Integer n2;
        Object object = this;
        synchronized (object) {
            n2 = new Integer(uniqueID++);
        }
        object = message.getQuestion();
        if (object != null) {
            String string = ((Record)object).getName().toString();
        } else {
            String string = "(none)";
        }
        return n2;
    }

    private Message sendAXFR(Message message) {
        Name name = message.getQuestion().getName();
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newAXFR(name, this.address, this.tsig);
        zoneTransferIn.setTimeout((int)(this.getTimeout() / 1000L));
        zoneTransferIn.setLocalAddress(this.localAddress);
        try {
            zoneTransferIn.run();
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        List list = zoneTransferIn.getAXFR();
        Message message2 = new Message(message.getHeader().getID());
        message2.getHeader().setFlag(5);
        message2.getHeader().setFlag(0);
        message2.addRecord(message.getQuestion(), 0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            message2.addRecord((Record)iterator.next(), 1);
        }
        return message2;
    }
}

