/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;

public class Generator {
    public long start;
    public long end;
    public long step;
    public final String namePattern;
    public final int type;
    public final int dclass;
    public final long ttl;
    public final String rdataPattern;
    public final Name origin;
    private long current;

    public static boolean supportedType(int n2) {
        Type.check(n2);
        return n2 == 12 || n2 == 5 || n2 == 39 || n2 == 1 || n2 == 28 || n2 == 2;
    }

    public Generator(long l2, long l3, long l4, String string, int n2, int n3, long l5, String string2, Name name) {
        if (l2 < 0L || l3 < 0L || l2 > l3 || l4 <= 0L) {
            throw new IllegalArgumentException("invalid range specification");
        }
        if (!Generator.supportedType(n2)) {
            throw new IllegalArgumentException("unsupported type");
        }
        DClass.check(n3);
        this.start = l2;
        this.end = l3;
        this.step = l4;
        this.namePattern = string;
        this.type = n2;
        this.dclass = n3;
        this.ttl = l5;
        this.rdataPattern = string2;
        this.origin = name;
        this.current = l2;
    }

    private String substitute(String string, long l2) {
        boolean bl = false;
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            char c2 = (char)(byArray[i2] & 0xFF);
            if (bl) {
                stringBuffer.append(c2);
                bl = false;
                continue;
            }
            if (c2 == '\\') {
                if (i2 + 1 == byArray.length) {
                    throw new Exception("invalid escape character");
                }
                bl = true;
                continue;
            }
            if (c2 == '$') {
                long l3;
                boolean bl2 = false;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 10L;
                boolean bl3 = false;
                if (i2 + 1 < byArray.length && byArray[i2 + 1] == 36) {
                    c2 = (char)(byArray[++i2] & 0xFF);
                    stringBuffer.append(c2);
                    continue;
                }
                if (i2 + 1 < byArray.length && byArray[i2 + 1] == 123) {
                    if (++i2 + 1 < byArray.length && byArray[i2 + 1] == 45) {
                        bl2 = true;
                        ++i2;
                    }
                    while (i2 + 1 < byArray.length && (c2 = (char)(byArray[++i2] & 0xFF)) != ',' && c2 != '}') {
                        if (c2 < '0' || c2 > '9') {
                            throw new Exception("invalid offset");
                        }
                        c2 = (char)(c2 - 48);
                        l4 *= 10L;
                        l4 += (long)c2;
                    }
                    if (bl2) {
                        l4 = -l4;
                    }
                    if (c2 == ',') {
                        while (i2 + 1 < byArray.length && (c2 = (char)(byArray[++i2] & 0xFF)) != ',' && c2 != '}') {
                            if (c2 < '0' || c2 > '9') {
                                throw new Exception("invalid width");
                            }
                            c2 = (char)(c2 - 48);
                            l5 *= 10L;
                            l5 += (long)c2;
                        }
                    }
                    if (c2 == ',') {
                        if (i2 + 1 == byArray.length) {
                            throw new Exception("invalid base");
                        }
                        if ((c2 = (char)(byArray[++i2] & 0xFF)) == 'o') {
                            l6 = 8L;
                        } else if (c2 == 'x') {
                            l6 = 16L;
                        } else if (c2 == 'X') {
                            l6 = 16L;
                            bl3 = true;
                        } else if (c2 != 'd') {
                            throw new Exception("invalid base");
                        }
                    }
                    if (i2 + 1 == byArray.length || byArray[i2 + 1] != 125) {
                        throw new Exception("invalid modifiers");
                    }
                    ++i2;
                }
                if ((l3 = l2 + l4) < 0L) {
                    throw new Exception("invalid offset expansion");
                }
                String string2 = l6 == 8L ? Long.toOctalString(l3) : (l6 == 16L ? Long.toHexString(l3) : Long.toString(l3));
                if (bl3) {
                    string2 = string2.toUpperCase();
                }
                if (l5 != 0L && l5 > (long)string2.length()) {
                    int n2 = (int)l5 - string2.length();
                    while (n2-- > 0) {
                        stringBuffer.append('0');
                    }
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public Record nextRecord() {
        if (this.current > this.end) {
            return null;
        }
        String string = this.substitute(this.namePattern, this.current);
        Name name = Name.fromString(string, this.origin);
        String string2 = this.substitute(this.rdataPattern, this.current);
        this.current += this.step;
        return Record.fromString(name, this.type, this.dclass, this.ttl, string2, this.origin);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("$GENERATE ");
        stringBuffer.append(this.start + "-" + this.end);
        if (this.step > 1L) {
            stringBuffer.append("/" + this.step);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.namePattern + " ");
        stringBuffer.append(this.ttl + " ");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            stringBuffer.append(DClass.string(this.dclass) + " ");
        }
        stringBuffer.append(Type.string(this.type) + " ");
        stringBuffer.append(this.rdataPattern + " ");
        return stringBuffer.toString();
    }
}

