/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.net;

import android.util.Log;
import com.hpplay.sdk.source.mdns.net.Packet;
import com.hpplay.sdk.source.mdns.net.PacketListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class DNSParserThread
extends Thread {
    private static final String TAG = "DNSParserThread";
    private BlockingQueue<Packet> mPacketQueue = new LinkedBlockingQueue<Packet>(20);
    private AtomicBoolean isQuit = new AtomicBoolean();
    private PacketListener mDispatcher;

    public DNSParserThread(PacketListener packetListener) {
        Log.i((String)TAG, (String)"DNSParserThread create");
        this.mDispatcher = packetListener;
        this.setName(TAG);
    }

    public synchronized void updateReceiveData(Packet packet) {
        if (!this.isQuit.get()) {
            this.mPacketQueue.offer(packet);
        }
    }

    @Override
    public void run() {
        super.run();
        this.isQuit.set(false);
        while (!this.isQuit.get() && !this.isInterrupted()) {
            try {
                Packet packet = this.mPacketQueue.take();
                if (this.mDispatcher == null) continue;
                this.mDispatcher.packetReceived(packet);
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)(Thread.currentThread() + "  InterruptedException exit..."));
                break;
            }
        }
        Log.i((String)TAG, (String)(Thread.currentThread() + " DNSParserThread exit..."));
    }

    public synchronized void release() {
        Log.i((String)TAG, (String)"  release ...");
        this.isQuit.set(true);
        this.interrupt();
        this.mDispatcher = null;
        this.mPacketQueue.clear();
    }
}

