/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.MessageInfos;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ReceiveMessageThread
extends Thread {
    private static final String TAG = "ReceiveMessageThread";
    private BlockingQueue<MessageInfos> mMsgQueue = new LinkedBlockingQueue<MessageInfos>(20);
    private Boolean isQuit = false;

    public ReceiveMessageThread() {
        this.setName(TAG);
    }

    public synchronized void updateReceiveData(MessageInfos messageInfos) {
        if (!this.isQuit.booleanValue()) {
            this.mMsgQueue.offer(messageInfos);
        }
    }

    @Override
    public void run() {
        super.run();
        this.isQuit = false;
        while (!this.isQuit.booleanValue() && !this.isInterrupted()) {
            try {
                MessageInfos messageInfos = this.mMsgQueue.take();
                ((ResolverListener)messageInfos.getListener().get()).receiveMessage(messageInfos.getIds().get(), (Message)messageInfos.getMessage().get());
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)"=============>>>ReceiveMessageThread InterruptedException exit");
                break;
            }
        }
        Log.i((String)TAG, (String)"=============>>> ReceiveMessageThread exit");
    }

    public void release() {
        this.isQuit = true;
        this.interrupt();
        this.mMsgQueue.clear();
    }
}

