/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.annotation.SuppressLint;
import android.util.Log;
import com.hpplay.sdk.source.mdns.MulticastDNSCache;
import com.hpplay.sdk.source.mdns.MulticastDNSMulticastOnlyQuerier;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CacheMonitors
implements MulticastDNSCache.CacheMonitor {
    private static final String TAG = "CacheMonitors";
    private final List authRecords = new ArrayList();
    private final List nonauthRecords = new ArrayList();
    private long lastPoll = System.currentTimeMillis();
    private WeakReference<MulticastDNSMulticastOnlyQuerier> querierWeakReference;

    public CacheMonitors(MulticastDNSMulticastOnlyQuerier multicastDNSMulticastOnlyQuerier) {
        this.querierWeakReference = new WeakReference<MulticastDNSMulticastOnlyQuerier>(multicastDNSMulticastOnlyQuerier);
    }

    @Override
    public void begin() {
        if (this.querierWeakReference.get() == null) {
            return;
        }
        if (((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mdnsVerbose || ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).cacheVerbose) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.lastPoll > 0L) {
                stringBuilder.append("Last Poll " + (double)(System.nanoTime() - this.lastPoll) / 1.0E9 + " seconds ago. ");
            }
            stringBuilder.append(" Cache Monitor Check ");
            Log.i((String)TAG, (String)("begin" + stringBuilder.toString()));
        }
        this.lastPoll = System.currentTimeMillis();
        this.authRecords.clear();
        this.nonauthRecords.clear();
    }

    @Override
    @SuppressLint(value={"LongLogTag"})
    public void check(RRset rRset, int n2, int n3) {
        if (((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mdnsVerbose || ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).cacheVerbose) {
            // empty if block
        }
        long l2 = rRset.getTTL();
        if (n2 >= 4 && this.isAboutToExpire(l2, n3)) {
            Record[] recordArray;
            for (Record record : recordArray = MulticastDNSUtils.extractRecords(rRset)) {
                try {
                    MulticastDNSUtils.setTLLForRecord(record, l2);
                    this.authRecords.add(record);
                }
                catch (Exception exception) {
                    Log.i((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void end() {
        try {
            int n2;
            Header header;
            Message message;
            if (this.authRecords.size() > 0) {
                message = new Message();
                header = message.getHeader();
                header.setOpcode(5);
                for (n2 = 0; n2 < this.authRecords.size(); ++n2) {
                    message.addRecord((Record)this.authRecords.get(n2), 2);
                }
                if (((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mdnsVerbose || ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).cacheVerbose) {
                    Log.i((String)TAG, (String)("end CacheMonitor Broadcasting update for Authoritative Records:\n" + message));
                }
                ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).broadcast(message, false);
            }
            if (this.nonauthRecords.size() > 0) {
                message = new Message();
                header = message.getHeader();
                header.setOpcode(0);
                header.setFlag(0);
                for (n2 = 0; n2 < this.nonauthRecords.size(); ++n2) {
                    message.addRecord((Record)this.nonauthRecords.get(n2), 2);
                }
                if (((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mdnsVerbose || ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).cacheVerbose) {
                    Log.i((String)TAG, (String)("end CacheMonitor Locally Broadcasting Non-Authoritative Records:\n" + message));
                }
                for (ResolverListener resolverListener : ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mResolverListener) {
                    resolverListener.receiveMessage(header.getID(), message);
                }
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Exception \"" + iOException.getMessage() + "\" occured while refreshing cached entries.");
            iOException2.setStackTrace(iOException.getStackTrace());
            for (ResolverListener resolverListener : ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mResolverListener) {
                resolverListener.handleException(TAG, iOException2);
            }
            if (((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mdnsVerbose) {
                Log.i((String)TAG, (String)iOException.getMessage(), (Throwable)iOException);
            }
        }
        catch (Exception exception) {
            Log.i((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
        this.authRecords.clear();
        this.nonauthRecords.clear();
    }

    @Override
    public void expired(RRset rRset, int n2) {
        if (((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).mdnsVerbose || ((MulticastDNSMulticastOnlyQuerier)this.querierWeakReference.get()).cacheVerbose) {
            Log.i((String)TAG, (String)("expiredCacheMonitor RRset expired : " + rRset));
        }
        List list = n2 >= 4 ? this.authRecords : this.nonauthRecords;
        Record[] recordArray = MulticastDNSUtils.extractRecords(rRset);
        if (recordArray != null && recordArray.length > 0) {
            for (int i2 = 0; i2 < recordArray.length; ++i2) {
                try {
                    MulticastDNSUtils.setTLLForRecord(recordArray[i2], 0L);
                    list.add(recordArray[i2]);
                    continue;
                }
                catch (Exception exception) {
                    Log.i((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public boolean isOperational() {
        return System.currentTimeMillis() < this.lastPoll + 10000L;
    }

    protected boolean isAboutToExpire(long l2, int n2) {
        double d2 = (double)n2 / (double)l2;
        return d2 <= (double)0.07f || d2 >= (double)0.1f && d2 <= (double)0.12f || d2 >= (double)0.15f && d2 <= (double)0.17f || d2 >= (double)0.2f && d2 <= (double)0.22f;
    }
}

