/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device.pincode;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.HttpEncrypt;
import com.hpplay.sdk.source.bean.DataBean;
import com.hpplay.sdk.source.bean.PinCodeBean;
import com.hpplay.sdk.source.browse.api.ICreatePinCodeListener;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.HashMap;
import org.json.JSONObject;

public class LelinkCodeCreator {
    private final String TAG = "LelinkCodeCreator";
    private AsyncTask mCodeTask;
    private final int WHAT_REFRESH = 1;
    private ICreatePinCodeListener mCreatePinCodeListener;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    LelinkCodeCreator.this.createPinCode(LelinkCodeCreator.this.mCreatePinCodeListener);
                }
            }
            return false;
        }
    });

    public void createPinCode(ICreatePinCodeListener iCreatePinCodeListener) {
        this.mCreatePinCodeListener = iCreatePinCodeListener;
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1);
        }
        SourceLog.i("LelinkCodeCreator", "createPinCode");
        Session session = Session.getInstance();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", session.getUID());
        hashMap.put("appid", session.appKey);
        hashMap.put("token", a.a());
        DataBean dataBean = new DataBean();
        dataBean.m = "02:00:00:00:00:00";
        dataBean.tmp = String.valueOf(System.currentTimeMillis());
        dataBean.extendStr = "";
        dataBean.uid = session.getUID();
        dataBean.a = session.appKey;
        dataBean.pt = "2";
        hashMap.put("data", dataBean.toJson().toString());
        final HttpEncrypt httpEncrypt = new HttpEncrypt();
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sPinCodeCreateUrl, httpEncrypt.encode(HapplayUtils.getMapParams(hashMap)));
        SourceLog.i("LelinkCodeCreator", "requestUrl:" + asyncHttpParameter.in.requestUrl);
        asyncHttpParameter.in.requestMethod = 1;
        asyncHttpParameter.in.requestHeaders = httpEncrypt.buildHeader();
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.result == null) {
                    SourceLog.i("LelinkCodeCreator", "createPinCode failed, result is null");
                    if (LelinkCodeCreator.this.mCreatePinCodeListener != null) {
                        LelinkCodeCreator.this.mCreatePinCodeListener.onCreatePinCode(null);
                    }
                    LelinkCodeCreator.this.startRefreshCode(60000);
                    return;
                }
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i("LelinkCodeCreator", "createPinCode task cancel");
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    String string = httpEncrypt.decode(asyncHttpParameter.out);
                    SourceLog.debug("LelinkCodeCreator", "result:" + string);
                    PinCodeBean pinCodeBean = null;
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        pinCodeBean = new PinCodeBean(jSONObject);
                    }
                    catch (Exception exception) {
                        SourceLog.w("LelinkCodeCreator", exception);
                    }
                    if (pinCodeBean != null) {
                        if (pinCodeBean.status == 200) {
                            if (!TextUtils.isEmpty((CharSequence)pinCodeBean.data.code)) {
                                LelinkCodeCreator.this.callbackPinCode(pinCodeBean.data.code, Math.max(1, pinCodeBean.data.codeTime - 1) * 60 * 1000);
                                return;
                            }
                            LelinkCodeCreator.this.callbackPinCode(null, 300000);
                            return;
                        }
                        if (pinCodeBean.status == 401 || pinCodeBean.status == 410) {
                            AuthSDK.getInstance().authSDKByInvalidToken();
                            SourceLog.i("LelinkCodeCreator", "createPinCode fail token timeout!");
                            LelinkCodeCreator.this.startRefreshCode(30000);
                            return;
                        }
                        LelinkCodeCreator.this.callbackPinCode(null, 300000);
                        return;
                    }
                    LelinkCodeCreator.this.callbackPinCode(null, 60000);
                }
            }
        };
        this.mCodeTask = AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private void callbackPinCode(String string, int n2) {
        SourceLog.i("LelinkCodeCreator", "callbackPinCode,pinCode " + string);
        if (this.mCreatePinCodeListener != null) {
            this.mCreatePinCodeListener.onCreatePinCode(string);
            this.startRefreshCode(n2);
        }
    }

    private void startRefreshCode(int n2) {
        if (this.mHandler == null) {
            SourceLog.w("LelinkCodeCreator", "startRefreshCode ignore");
            return;
        }
        SourceLog.i("LelinkCodeCreator", "startRefreshCode " + n2);
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), (long)n2);
    }

    public void release() {
        SourceLog.i("LelinkCodeCreator", "release");
        if (this.mCodeTask != null) {
            this.mCodeTask.cancel(true);
            this.mCodeTask = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
    }
}

