/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.browse.data.LelinkServiceInfoCreator;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.Feature;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class ServerInfoResolver {
    private static final String TAG = "ServerInfoResolver";
    private static final int WHAT_CALLBACK_IM = 1;
    private static final int DELAY_CALLBACK_IM = 500;
    private IServiceInfoParseListener mServiceInfoParseListener;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (message.obj == null) break;
                    ServerInfoResolver.this.callbackIMFirst((LelinkServiceInfo)message.obj);
                }
            }
            return false;
        }
    });

    public void parserServerInfo(SinkServerBean sinkServerBean, IServiceInfoParseListener iServiceInfoParseListener) {
        this.mServiceInfoParseListener = iServiceInfoParseListener;
        SourceLog.w(TAG, "parserServerInfo");
        if (sinkServerBean == null) {
            this.notifyParseResult(0, null);
            return;
        }
        int n2 = 0;
        try {
            if (!TextUtils.isEmpty((CharSequence)sinkServerBean.port)) {
                n2 = Integer.parseInt(sinkServerBean.port);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (TextUtils.isEmpty((CharSequence)sinkServerBean.ip) || n2 <= 0) {
            this.notifyParseResult(9, null);
            return;
        }
        LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.createIMServiceByUID(sinkServerBean.appID, sinkServerBean.uid, sinkServerBean.name, sinkServerBean.pt, sinkServerBean.tunnels, 1);
        this.delayCallbackIM(lelinkServiceInfo);
        this.requestLelinkTxtInfo(sinkServerBean.ip, n2);
    }

    private void requestLelinkTxtInfo(final String string, int n2) {
        if (TextUtils.isEmpty((CharSequence)string) || n2 <= 0) {
            SourceLog.w(TAG, "requestLelinkTxtInfo ignore," + string + "/" + n2);
            return;
        }
        SourceLog.w(TAG, "requestLelinkTxtInfo");
        String string2 = CloudAPI.getHttpServerUrl(string, n2 + "");
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string2, null);
        asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(5L);
        asyncHttpParameter.in.tryCount = 1;
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i(ServerInfoResolver.TAG, "requestLelinkTxtInfo cancel");
                    return;
                }
                if (asyncHttpParameter.out.resultType == 0) {
                    String string3 = asyncHttpParameter.out.result;
                    try {
                        JSONObject jSONObject = new JSONObject(string3);
                        String string2 = jSONObject.optString("serviceName");
                        JSONObject jSONObject2 = jSONObject.optJSONObject("leLinkTxt");
                        if (jSONObject2 != null) {
                            Object object;
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            Iterator iterator = jSONObject2.keys();
                            while (iterator.hasNext()) {
                                object = (String)iterator.next();
                                hashMap.put((String)object, jSONObject2.optString((String)object));
                                SourceLog.i(ServerInfoResolver.TAG, "key  : " + (String)object);
                            }
                            object = ServerInfoResolver.this.resolveServiceInfo(string2, string, hashMap);
                            LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo(1, (BrowserInfo)object);
                            BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4);
                            if (browserInfo != null) {
                                browserInfo.setOnLine(true);
                            }
                            ServerInfoResolver.this.notifyParseResult(1, lelinkServiceInfo);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.w(ServerInfoResolver.TAG, exception);
                    }
                }
                SourceLog.i(ServerInfoResolver.TAG, "requestLelinkTxtInfo failed");
                if (Feature.isDisableIM()) {
                    ServerInfoResolver.this.notifyParseResult(0, null);
                }
            }
        });
    }

    private BrowserInfo resolveServiceInfo(String string, String string2, Map<String, String> map) {
        String string3;
        String string4 = map.get("vv");
        SourceLog.i(TAG, "resolveServiceInfo vv:" + string4);
        if (TextUtils.isEmpty((CharSequence)string4) || !"2".equals(string4)) {
            return null;
        }
        BrowserInfo browserInfo = new BrowserInfo(1, 1);
        browserInfo.setName(string);
        browserInfo.setIp(string2);
        browserInfo.setLocalWifi(true);
        browserInfo.setOnLine(true);
        String string5 = map.get("u");
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            browserInfo.setUid(string5);
        }
        if (!TextUtils.isEmpty((CharSequence)(string3 = map.get("lelinkport")))) {
            try {
                int n2 = Integer.parseInt(string3);
                browserInfo.setPort(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("  -- ");
        while (iterator.hasNext()) {
            String string6 = iterator.next();
            String string7 = map.get(string6);
            hashMap.put(string6, string7);
            stringBuilder.append(string6).append("  ").append(string7).append(" ");
        }
        browserInfo.setExtras(hashMap);
        return browserInfo;
    }

    private void delayCallbackIM(LelinkServiceInfo lelinkServiceInfo) {
        if (Feature.isDisableIM()) {
            return;
        }
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, (Object)lelinkServiceInfo), 500L);
    }

    private void callbackIMFirst(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return;
        }
        SourceLog.w(TAG, "callbackIMFirst");
        try {
            if (lelinkServiceInfo.getBrowserInfos().size() > 1 && lelinkServiceInfo.getBrowserInfos().containsKey(4)) {
                lelinkServiceInfo.getBrowserInfos().remove(1);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (!CastUtil.isSupportIM(lelinkServiceInfo)) {
            return;
        }
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4);
        if (browserInfo != null) {
            browserInfo.setOnLine(true);
        }
        this.notifyParseResult(1, lelinkServiceInfo);
    }

    private void notifyParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
        this.mHandler.removeMessages(1);
        SourceLog.i(TAG, "notifyParseResult " + this.mServiceInfoParseListener + "/" + lelinkServiceInfo);
        if (this.mServiceInfoParseListener != null) {
            this.mServiceInfoParseListener.onParseResult(n2, lelinkServiceInfo);
        }
    }

    public static class SinkServerBean {
        public String dsn;
        public String appID;
        public String uid;
        public String name;
        public String pt;
        public String ip;
        public String port;
        public String tunnels;
    }
}

