/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.util;

import java.io.FilterInputStream;
import java.io.InputStream;

public class MarkEnforcingInputStream
extends FilterInputStream {
    private static final int UNSET = Integer.MIN_VALUE;
    private static final int END_OF_STREAM = -1;
    private int availableBytes = Integer.MIN_VALUE;

    public MarkEnforcingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void mark(int n2) {
        super.mark(n2);
        this.availableBytes = n2;
    }

    @Override
    public int read() {
        if (this.getBytesToRead(1L) == -1L) {
            return -1;
        }
        int n2 = super.read();
        this.updateAvailableBytesAfterRead(1L);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = (int)this.getBytesToRead(n3);
        if (n4 == -1) {
            return -1;
        }
        int n5 = super.read(byArray, n2, n4);
        this.updateAvailableBytesAfterRead(n5);
        return n5;
    }

    @Override
    public void reset() {
        super.reset();
        this.availableBytes = Integer.MIN_VALUE;
    }

    @Override
    public long skip(long l2) {
        long l3 = this.getBytesToRead(l2);
        if (l3 == -1L) {
            return -1L;
        }
        long l4 = super.skip(l3);
        this.updateAvailableBytesAfterRead(l4);
        return l4;
    }

    @Override
    public int available() {
        return this.availableBytes == Integer.MIN_VALUE ? super.available() : Math.min(this.availableBytes, super.available());
    }

    private long getBytesToRead(long l2) {
        if (this.availableBytes == 0) {
            return -1L;
        }
        if (this.availableBytes != Integer.MIN_VALUE && l2 > (long)this.availableBytes) {
            return this.availableBytes;
        }
        return l2;
    }

    private void updateAvailableBytesAfterRead(long l2) {
        if (this.availableBytes != Integer.MIN_VALUE && l2 != -1L) {
            this.availableBytes = (int)((long)this.availableBytes - l2);
        }
    }
}

