/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request.target;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.hpplay.glide.load.resource.drawable.GlideDrawable;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.target.ImageViewTarget;
import com.hpplay.glide.request.target.SquaringDrawable;

public class GlideDrawableImageViewTarget
extends ImageViewTarget<GlideDrawable> {
    private static final float SQUARE_RATIO_MARGIN = 0.05f;
    private int maxLoopCount;
    private GlideDrawable resource;

    public GlideDrawableImageViewTarget(ImageView imageView) {
        this(imageView, -1);
    }

    public GlideDrawableImageViewTarget(ImageView imageView, int n2) {
        super(imageView);
        this.maxLoopCount = n2;
    }

    @Override
    public void onResourceReady(GlideDrawable glideDrawable, GlideAnimation<? super GlideDrawable> glideAnimation) {
        if (!glideDrawable.isAnimated()) {
            float f2 = (float)((ImageView)this.view).getWidth() / (float)((ImageView)this.view).getHeight();
            float f3 = (float)glideDrawable.getIntrinsicWidth() / (float)glideDrawable.getIntrinsicHeight();
            if (Math.abs(f2 - 1.0f) <= 0.05f && Math.abs(f3 - 1.0f) <= 0.05f) {
                glideDrawable = new SquaringDrawable(glideDrawable, ((ImageView)this.view).getWidth());
            }
        }
        super.onResourceReady(glideDrawable, glideAnimation);
        this.resource = glideDrawable;
        glideDrawable.setLoopCount(this.maxLoopCount);
        glideDrawable.start();
    }

    @Override
    protected void setResource(GlideDrawable glideDrawable) {
        ((ImageView)this.view).setImageDrawable((Drawable)glideDrawable);
    }

    @Override
    public void onStart() {
        if (this.resource != null) {
            this.resource.start();
        }
    }

    @Override
    public void onStop() {
        if (this.resource != null) {
            this.resource.stop();
        }
    }
}

